// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMappingRequest
type CreateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	//
	//    * Amazon Kinesis - Default 100. Max 10,000.
	//
	//    * Amazon DynamoDB Streams - Default 100. Max 1,000.
	//
	//    * Amazon Simple Queue Service - Default 10. Max 10.
	BatchSize *int64 `min:"1" type:"integer"`

	// Disables the event source mapping to pause polling and invocation.
	Enabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the event source.
	//
	//    * Amazon Kinesis - The ARN of the data stream or a stream consumer.
	//
	//    * Amazon DynamoDB Streams - The ARN of the stream.
	//
	//    * Amazon Simple Queue Service - The ARN of the queue.
	//
	// EventSourceArn is a required field
	EventSourceArn *string `type:"string" required:"true"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Version or Alias ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it's limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The position in a stream from which to start reading. Required for Amazon
	// Kinesis and Amazon DynamoDB Streams sources. AT_TIMESTAMP is only supported
	// for Amazon Kinesis streams.
	StartingPosition EventSourcePosition `type:"string" enum:"true"`

	// With StartingPosition set to AT_TIMESTAMP, the time from which to start reading.
	StartingPositionTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s CreateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSourceMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEventSourceMappingInput"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("BatchSize", 1))
	}

	if s.EventSourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventSourceArn"))
	}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateEventSourceMappingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.BatchSize != nil {
		v := *s.BatchSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchSize", protocol.Int64Value(v), metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.EventSourceArn != nil {
		v := *s.EventSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.StartingPosition) > 0 {
		v := s.StartingPosition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartingPosition", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StartingPositionTimestamp != nil {
		v := *s.StartingPositionTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartingPositionTimestamp", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// A mapping between an AWS resource and an AWS Lambda function. See CreateEventSourceMapping
// for details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/EventSourceMappingConfiguration
type CreateEventSourceMappingOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the event source.
	EventSourceArn *string `type:"string"`

	// The ARN of the Lambda function.
	FunctionArn *string `type:"string"`

	// The date that the event source mapping was last updated.
	LastModified *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The result of the last AWS Lambda invocation of your Lambda function.
	LastProcessingResult *string `type:"string"`

	// The state of the event source mapping. It can be one of the following: Creating,
	// Enabling, Enabled, Disabling, Disabled, Updating, or Deleting.
	State *string `type:"string"`

	// The cause of the last state change, either User initiated or Lambda initiated.
	StateTransitionReason *string `type:"string"`

	// The identifier of the event source mapping.
	UUID *string `type:"string"`
}

// String returns the string representation
func (s CreateEventSourceMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateEventSourceMappingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchSize != nil {
		v := *s.BatchSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchSize", protocol.Int64Value(v), metadata)
	}
	if s.EventSourceArn != nil {
		v := *s.EventSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastProcessingResult != nil {
		v := *s.LastProcessingResult

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastProcessingResult", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StateTransitionReason != nil {
		v := *s.StateTransitionReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateTransitionReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UUID != nil {
		v := *s.UUID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UUID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateEventSourceMapping = "CreateEventSourceMapping"

// CreateEventSourceMappingRequest returns a request value for making API operation for
// AWS Lambda.
//
// Creates a mapping between an event source and an AWS Lambda function. Lambda
// reads items from the event source and triggers the function.
//
// For details about each event source type, see the following topics.
//
//    * Using AWS Lambda with Amazon Kinesis (https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html)
//
//    * Using AWS Lambda with Amazon SQS (https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html)
//
//    * Using AWS Lambda with Amazon DynamoDB (https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html)
//
//    // Example sending a request using CreateEventSourceMappingRequest.
//    req := client.CreateEventSourceMappingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping
func (c *Client) CreateEventSourceMappingRequest(input *CreateEventSourceMappingInput) CreateEventSourceMappingRequest {
	op := &aws.Operation{
		Name:       opCreateEventSourceMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
	}

	if input == nil {
		input = &CreateEventSourceMappingInput{}
	}

	req := c.newRequest(op, input, &CreateEventSourceMappingOutput{})
	return CreateEventSourceMappingRequest{Request: req, Input: input, Copy: c.CreateEventSourceMappingRequest}
}

// CreateEventSourceMappingRequest is the request type for the
// CreateEventSourceMapping API operation.
type CreateEventSourceMappingRequest struct {
	*aws.Request
	Input *CreateEventSourceMappingInput
	Copy  func(*CreateEventSourceMappingInput) CreateEventSourceMappingRequest
}

// Send marshals and sends the CreateEventSourceMapping API request.
func (r CreateEventSourceMappingRequest) Send(ctx context.Context) (*CreateEventSourceMappingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEventSourceMappingResponse{
		CreateEventSourceMappingOutput: r.Request.Data.(*CreateEventSourceMappingOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEventSourceMappingResponse is the response type for the
// CreateEventSourceMapping API operation.
type CreateEventSourceMappingResponse struct {
	*CreateEventSourceMappingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEventSourceMapping request.
func (r *CreateEventSourceMappingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
