// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RevokeGrantRequest
type RevokeGrantInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the grant to be revoked.
	//
	// GrantId is a required field
	GrantId *string `min:"1" type:"string" required:"true"`

	// A unique identifier for the customer master key associated with the grant.
	//
	// Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To specify
	// a CMK in a different AWS account, you must use the key ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeGrantInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeGrantInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RevokeGrantInput"}

	if s.GrantId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GrantId"))
	}
	if s.GrantId != nil && len(*s.GrantId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GrantId", 1))
	}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RevokeGrantOutput
type RevokeGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeGrantOutput) String() string {
	return awsutil.Prettify(s)
}

const opRevokeGrant = "RevokeGrant"

// RevokeGrantRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Revokes the specified grant for the specified customer master key (CMK).
// You can revoke a grant to actively deny operations that depend on it.
//
// To perform this operation on a CMK in a different AWS account, specify the
// key ARN in the value of the KeyId parameter.
//
//    // Example sending a request using RevokeGrantRequest.
//    req := client.RevokeGrantRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RevokeGrant
func (c *Client) RevokeGrantRequest(input *RevokeGrantInput) RevokeGrantRequest {
	op := &aws.Operation{
		Name:       opRevokeGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeGrantInput{}
	}

	req := c.newRequest(op, input, &RevokeGrantOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RevokeGrantRequest{Request: req, Input: input, Copy: c.RevokeGrantRequest}
}

// RevokeGrantRequest is the request type for the
// RevokeGrant API operation.
type RevokeGrantRequest struct {
	*aws.Request
	Input *RevokeGrantInput
	Copy  func(*RevokeGrantInput) RevokeGrantRequest
}

// Send marshals and sends the RevokeGrant API request.
func (r RevokeGrantRequest) Send(ctx context.Context) (*RevokeGrantResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RevokeGrantResponse{
		RevokeGrantOutput: r.Request.Data.(*RevokeGrantOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RevokeGrantResponse is the response type for the
// RevokeGrant API operation.
type RevokeGrantResponse struct {
	*RevokeGrantOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RevokeGrant request.
func (r *RevokeGrantResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
