// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteImportedKeyMaterialRequest
type DeleteImportedKeyMaterialInput struct {
	_ struct{} `type:"structure"`

	// Identifies the CMK from which you are deleting imported key material. The
	// Origin of the CMK must be EXTERNAL.
	//
	// Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteImportedKeyMaterialInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImportedKeyMaterialInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteImportedKeyMaterialInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteImportedKeyMaterialOutput
type DeleteImportedKeyMaterialOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteImportedKeyMaterialOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteImportedKeyMaterial = "DeleteImportedKeyMaterial"

// DeleteImportedKeyMaterialRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Deletes key material that you previously imported. This operation makes the
// specified customer master key (CMK) unusable. For more information about
// importing key material into AWS KMS, see Importing Key Material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
// in the AWS Key Management Service Developer Guide. You cannot perform this
// operation on a CMK in a different AWS account.
//
// When the specified CMK is in the PendingDeletion state, this operation does
// not change the CMK's state. Otherwise, it changes the CMK's state to PendingImport.
//
// After you delete key material, you can use ImportKeyMaterial to reimport
// the same key material into the CMK.
//
// The result of this operation varies with the key state of the CMK. For details,
// see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
//    // Example sending a request using DeleteImportedKeyMaterialRequest.
//    req := client.DeleteImportedKeyMaterialRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteImportedKeyMaterial
func (c *Client) DeleteImportedKeyMaterialRequest(input *DeleteImportedKeyMaterialInput) DeleteImportedKeyMaterialRequest {
	op := &aws.Operation{
		Name:       opDeleteImportedKeyMaterial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteImportedKeyMaterialInput{}
	}

	req := c.newRequest(op, input, &DeleteImportedKeyMaterialOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteImportedKeyMaterialRequest{Request: req, Input: input, Copy: c.DeleteImportedKeyMaterialRequest}
}

// DeleteImportedKeyMaterialRequest is the request type for the
// DeleteImportedKeyMaterial API operation.
type DeleteImportedKeyMaterialRequest struct {
	*aws.Request
	Input *DeleteImportedKeyMaterialInput
	Copy  func(*DeleteImportedKeyMaterialInput) DeleteImportedKeyMaterialRequest
}

// Send marshals and sends the DeleteImportedKeyMaterial API request.
func (r DeleteImportedKeyMaterialRequest) Send(ctx context.Context) (*DeleteImportedKeyMaterialResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteImportedKeyMaterialResponse{
		DeleteImportedKeyMaterialOutput: r.Request.Data.(*DeleteImportedKeyMaterialOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteImportedKeyMaterialResponse is the response type for the
// DeleteImportedKeyMaterial API operation.
type DeleteImportedKeyMaterialResponse struct {
	*DeleteImportedKeyMaterialOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteImportedKeyMaterial request.
func (r *DeleteImportedKeyMaterialResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
