// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInputRequest
type AddApplicationInputInput struct {
	_ struct{} `type:"structure"`

	// The name of your existing application to which you want to add the streaming
	// source.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The current version of your application. You can use the DescribeApplication
	// operation to find the current application version.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The Input to add.
	//
	// Input is a required field
	Input *Input `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddApplicationInputInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationInputInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddApplicationInputInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}

	if s.Input == nil {
		invalidParams.Add(aws.NewErrParamRequired("Input"))
	}
	if s.Input != nil {
		if err := s.Input.Validate(); err != nil {
			invalidParams.AddNested("Input", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInputResponse
type AddApplicationInputOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	ApplicationARN *string `min:"1" type:"string"`

	// Provides the current application version.
	ApplicationVersionId *int64 `min:"1" type:"long"`

	// Describes the application input configuration.
	InputDescriptions []InputDescription `type:"list"`
}

// String returns the string representation
func (s AddApplicationInputOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddApplicationInput = "AddApplicationInput"

// AddApplicationInputRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
// Adds a streaming source to your SQL-based Amazon Kinesis Data Analytics application.
//
// You can add a streaming source when you create an application, or you can
// use this operation to add a streaming source after you create an application.
// For more information, see CreateApplication.
//
// Any configuration update, including adding a streaming source using this
// operation, results in a new version of the application. You can use the DescribeApplication
// operation to find the current application version.
//
//    // Example sending a request using AddApplicationInputRequest.
//    req := client.AddApplicationInputRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInput
func (c *Client) AddApplicationInputRequest(input *AddApplicationInputInput) AddApplicationInputRequest {
	op := &aws.Operation{
		Name:       opAddApplicationInput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationInputInput{}
	}

	req := c.newRequest(op, input, &AddApplicationInputOutput{})
	return AddApplicationInputRequest{Request: req, Input: input, Copy: c.AddApplicationInputRequest}
}

// AddApplicationInputRequest is the request type for the
// AddApplicationInput API operation.
type AddApplicationInputRequest struct {
	*aws.Request
	Input *AddApplicationInputInput
	Copy  func(*AddApplicationInputInput) AddApplicationInputRequest
}

// Send marshals and sends the AddApplicationInput API request.
func (r AddApplicationInputRequest) Send(ctx context.Context) (*AddApplicationInputResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddApplicationInputResponse{
		AddApplicationInputOutput: r.Request.Data.(*AddApplicationInputOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddApplicationInputResponse is the response type for the
// AddApplicationInput API operation.
type AddApplicationInputResponse struct {
	*AddApplicationInputOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddApplicationInput request.
func (r *AddApplicationInputResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
