// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreatePipelineRequest
type CreatePipelineInput struct {
	_ struct{} `type:"structure"`

	// A list of "PipelineActivity" objects. Activities perform transformations
	// on your messages, such as removing, renaming or adding message attributes;
	// filtering messages based on attribute values; invoking your Lambda functions
	// on messages for advanced processing; or performing mathematical transformations
	// to normalize device data.
	//
	// The list can be 2-25 PipelineActivity objects and must contain both a channel
	// and a datastore activity. Each entry in the list must contain only one activity,
	// for example:
	//
	// pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ...
	// ]
	//
	// PipelineActivities is a required field
	PipelineActivities []PipelineActivity `locationName:"pipelineActivities" min:"1" type:"list" required:"true"`

	// The name of the pipeline.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// Metadata which can be used to manage the pipeline.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s CreatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePipelineInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePipelineInput"}

	if s.PipelineActivities == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineActivities"))
	}
	if s.PipelineActivities != nil && len(s.PipelineActivities) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineActivities", 1))
	}

	if s.PipelineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.PipelineActivities != nil {
		for i, v := range s.PipelineActivities {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PipelineActivities", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreatePipelineInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.PipelineActivities) > 0 {
		v := s.PipelineActivities

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "pipelineActivities", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.PipelineName != nil {
		v := *s.PipelineName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelineName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreatePipelineResponse
type CreatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipeline.
	PipelineArn *string `locationName:"pipelineArn" type:"string"`

	// The name of the pipeline.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreatePipelineOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PipelineArn != nil {
		v := *s.PipelineArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelineArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PipelineName != nil {
		v := *s.PipelineName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelineName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreatePipeline = "CreatePipeline"

// CreatePipelineRequest returns a request value for making API operation for
// AWS IoT Analytics.
//
// Creates a pipeline. A pipeline consumes messages from one or more channels
// and allows you to process the messages before storing them in a data store.
// You must specify both a channel and a datastore activity and, optionally,
// as many as 23 additional activities in the pipelineActivities array.
//
//    // Example sending a request using CreatePipelineRequest.
//    req := client.CreatePipelineRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreatePipeline
func (c *Client) CreatePipelineRequest(input *CreatePipelineInput) CreatePipelineRequest {
	op := &aws.Operation{
		Name:       opCreatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/pipelines",
	}

	if input == nil {
		input = &CreatePipelineInput{}
	}

	req := c.newRequest(op, input, &CreatePipelineOutput{})
	return CreatePipelineRequest{Request: req, Input: input, Copy: c.CreatePipelineRequest}
}

// CreatePipelineRequest is the request type for the
// CreatePipeline API operation.
type CreatePipelineRequest struct {
	*aws.Request
	Input *CreatePipelineInput
	Copy  func(*CreatePipelineInput) CreatePipelineRequest
}

// Send marshals and sends the CreatePipeline API request.
func (r CreatePipelineRequest) Send(ctx context.Context) (*CreatePipelineResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePipelineResponse{
		CreatePipelineOutput: r.Request.Data.(*CreatePipelineOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePipelineResponse is the response type for the
// CreatePipeline API operation.
type CreatePipelineResponse struct {
	*CreatePipelineOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePipeline request.
func (r *CreatePipelineResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
