// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Details of abort criteria to abort the job.
type AbortConfig struct {
	_ struct{} `type:"structure"`

	// The list of abort criteria to define rules to abort the job.
	//
	// CriteriaList is a required field
	CriteriaList []AbortCriteria `locationName:"criteriaList" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AbortConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AbortConfig"}

	if s.CriteriaList == nil {
		invalidParams.Add(aws.NewErrParamRequired("CriteriaList"))
	}
	if s.CriteriaList != nil && len(s.CriteriaList) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CriteriaList", 1))
	}
	if s.CriteriaList != nil {
		for i, v := range s.CriteriaList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CriteriaList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AbortConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CriteriaList) > 0 {
		v := s.CriteriaList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "criteriaList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Details of abort criteria to define rules to abort the job.
type AbortCriteria struct {
	_ struct{} `type:"structure"`

	// The type of abort action to initiate a job abort.
	//
	// Action is a required field
	Action AbortAction `locationName:"action" type:"string" required:"true" enum:"true"`

	// The type of job execution failure to define a rule to initiate a job abort.
	//
	// FailureType is a required field
	FailureType JobExecutionFailureType `locationName:"failureType" type:"string" required:"true" enum:"true"`

	// Minimum number of executed things before evaluating an abort rule.
	//
	// MinNumberOfExecutedThings is a required field
	MinNumberOfExecutedThings *int64 `locationName:"minNumberOfExecutedThings" min:"1" type:"integer" required:"true"`

	// The threshold as a percentage of the total number of executed things that
	// will initiate a job abort.
	//
	// AWS IoT supports up to two digits after the decimal (for example, 10.9 and
	// 10.99, but not 10.999).
	//
	// ThresholdPercentage is a required field
	ThresholdPercentage *float64 `locationName:"thresholdPercentage" type:"double" required:"true"`
}

// String returns the string representation
func (s AbortCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AbortCriteria"}
	if len(s.Action) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}
	if len(s.FailureType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FailureType"))
	}

	if s.MinNumberOfExecutedThings == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinNumberOfExecutedThings"))
	}
	if s.MinNumberOfExecutedThings != nil && *s.MinNumberOfExecutedThings < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MinNumberOfExecutedThings", 1))
	}

	if s.ThresholdPercentage == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThresholdPercentage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AbortCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.FailureType) > 0 {
		v := s.FailureType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MinNumberOfExecutedThings != nil {
		v := *s.MinNumberOfExecutedThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minNumberOfExecutedThings", protocol.Int64Value(v), metadata)
	}
	if s.ThresholdPercentage != nil {
		v := *s.ThresholdPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thresholdPercentage", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Describes the actions associated with a rule.
type Action struct {
	_ struct{} `type:"structure"`

	// Change the state of a CloudWatch alarm.
	CloudwatchAlarm *CloudwatchAlarmAction `locationName:"cloudwatchAlarm" type:"structure"`

	// Capture a CloudWatch metric.
	CloudwatchMetric *CloudwatchMetricAction `locationName:"cloudwatchMetric" type:"structure"`

	// Write to a DynamoDB table.
	DynamoDB *DynamoDBAction `locationName:"dynamoDB" type:"structure"`

	// Write to a DynamoDB table. This is a new version of the DynamoDB action.
	// It allows you to write each attribute in an MQTT message payload into a separate
	// DynamoDB column.
	DynamoDBv2 *DynamoDBv2Action `locationName:"dynamoDBv2" type:"structure"`

	// Write data to an Amazon Elasticsearch Service domain.
	Elasticsearch *ElasticsearchAction `locationName:"elasticsearch" type:"structure"`

	// Write to an Amazon Kinesis Firehose stream.
	Firehose *FirehoseAction `locationName:"firehose" type:"structure"`

	// Sends message data to an AWS IoT Analytics channel.
	IotAnalytics *IotAnalyticsAction `locationName:"iotAnalytics" type:"structure"`

	// Sends an input to an AWS IoT Events detector.
	IotEvents *IotEventsAction `locationName:"iotEvents" type:"structure"`

	// Write data to an Amazon Kinesis stream.
	Kinesis *KinesisAction `locationName:"kinesis" type:"structure"`

	// Invoke a Lambda function.
	Lambda *LambdaAction `locationName:"lambda" type:"structure"`

	// Publish to another MQTT topic.
	Republish *RepublishAction `locationName:"republish" type:"structure"`

	// Write to an Amazon S3 bucket.
	S3 *S3Action `locationName:"s3" type:"structure"`

	// Send a message to a Salesforce IoT Cloud Input Stream.
	Salesforce *SalesforceAction `locationName:"salesforce" type:"structure"`

	// Publish to an Amazon SNS topic.
	Sns *SnsAction `locationName:"sns" type:"structure"`

	// Publish to an Amazon SQS queue.
	Sqs *SqsAction `locationName:"sqs" type:"structure"`

	// Starts execution of a Step Functions state machine.
	StepFunctions *StepFunctionsAction `locationName:"stepFunctions" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Action"}
	if s.CloudwatchAlarm != nil {
		if err := s.CloudwatchAlarm.Validate(); err != nil {
			invalidParams.AddNested("CloudwatchAlarm", err.(aws.ErrInvalidParams))
		}
	}
	if s.CloudwatchMetric != nil {
		if err := s.CloudwatchMetric.Validate(); err != nil {
			invalidParams.AddNested("CloudwatchMetric", err.(aws.ErrInvalidParams))
		}
	}
	if s.DynamoDB != nil {
		if err := s.DynamoDB.Validate(); err != nil {
			invalidParams.AddNested("DynamoDB", err.(aws.ErrInvalidParams))
		}
	}
	if s.DynamoDBv2 != nil {
		if err := s.DynamoDBv2.Validate(); err != nil {
			invalidParams.AddNested("DynamoDBv2", err.(aws.ErrInvalidParams))
		}
	}
	if s.Elasticsearch != nil {
		if err := s.Elasticsearch.Validate(); err != nil {
			invalidParams.AddNested("Elasticsearch", err.(aws.ErrInvalidParams))
		}
	}
	if s.Firehose != nil {
		if err := s.Firehose.Validate(); err != nil {
			invalidParams.AddNested("Firehose", err.(aws.ErrInvalidParams))
		}
	}
	if s.IotEvents != nil {
		if err := s.IotEvents.Validate(); err != nil {
			invalidParams.AddNested("IotEvents", err.(aws.ErrInvalidParams))
		}
	}
	if s.Kinesis != nil {
		if err := s.Kinesis.Validate(); err != nil {
			invalidParams.AddNested("Kinesis", err.(aws.ErrInvalidParams))
		}
	}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(aws.ErrInvalidParams))
		}
	}
	if s.Republish != nil {
		if err := s.Republish.Validate(); err != nil {
			invalidParams.AddNested("Republish", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(aws.ErrInvalidParams))
		}
	}
	if s.Salesforce != nil {
		if err := s.Salesforce.Validate(); err != nil {
			invalidParams.AddNested("Salesforce", err.(aws.ErrInvalidParams))
		}
	}
	if s.Sns != nil {
		if err := s.Sns.Validate(); err != nil {
			invalidParams.AddNested("Sns", err.(aws.ErrInvalidParams))
		}
	}
	if s.Sqs != nil {
		if err := s.Sqs.Validate(); err != nil {
			invalidParams.AddNested("Sqs", err.(aws.ErrInvalidParams))
		}
	}
	if s.StepFunctions != nil {
		if err := s.StepFunctions.Validate(); err != nil {
			invalidParams.AddNested("StepFunctions", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Action) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudwatchAlarm != nil {
		v := s.CloudwatchAlarm

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "cloudwatchAlarm", v, metadata)
	}
	if s.CloudwatchMetric != nil {
		v := s.CloudwatchMetric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "cloudwatchMetric", v, metadata)
	}
	if s.DynamoDB != nil {
		v := s.DynamoDB

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dynamoDB", v, metadata)
	}
	if s.DynamoDBv2 != nil {
		v := s.DynamoDBv2

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dynamoDBv2", v, metadata)
	}
	if s.Elasticsearch != nil {
		v := s.Elasticsearch

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "elasticsearch", v, metadata)
	}
	if s.Firehose != nil {
		v := s.Firehose

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "firehose", v, metadata)
	}
	if s.IotAnalytics != nil {
		v := s.IotAnalytics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "iotAnalytics", v, metadata)
	}
	if s.IotEvents != nil {
		v := s.IotEvents

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "iotEvents", v, metadata)
	}
	if s.Kinesis != nil {
		v := s.Kinesis

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "kinesis", v, metadata)
	}
	if s.Lambda != nil {
		v := s.Lambda

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "lambda", v, metadata)
	}
	if s.Republish != nil {
		v := s.Republish

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "republish", v, metadata)
	}
	if s.S3 != nil {
		v := s.S3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3", v, metadata)
	}
	if s.Salesforce != nil {
		v := s.Salesforce

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "salesforce", v, metadata)
	}
	if s.Sns != nil {
		v := s.Sns

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sns", v, metadata)
	}
	if s.Sqs != nil {
		v := s.Sqs

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sqs", v, metadata)
	}
	if s.StepFunctions != nil {
		v := s.StepFunctions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "stepFunctions", v, metadata)
	}
	return nil
}

// Information about an active Device Defender security profile behavior violation.
type ActiveViolation struct {
	_ struct{} `type:"structure"`

	// The behavior which is being violated.
	Behavior *Behavior `locationName:"behavior" type:"structure"`

	// The time the most recent violation occurred.
	LastViolationTime *time.Time `locationName:"lastViolationTime" type:"timestamp" timestampFormat:"unix"`

	// The value of the metric (the measurement) which caused the most recent violation.
	LastViolationValue *MetricValue `locationName:"lastViolationValue" type:"structure"`

	// The security profile whose behavior is in violation.
	SecurityProfileName *string `locationName:"securityProfileName" min:"1" type:"string"`

	// The name of the thing responsible for the active violation.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`

	// The ID of the active violation.
	ViolationId *string `locationName:"violationId" min:"1" type:"string"`

	// The time the violation started.
	ViolationStartTime *time.Time `locationName:"violationStartTime" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ActiveViolation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ActiveViolation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Behavior != nil {
		v := s.Behavior

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "behavior", v, metadata)
	}
	if s.LastViolationTime != nil {
		v := *s.LastViolationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastViolationTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastViolationValue != nil {
		v := s.LastViolationValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "lastViolationValue", v, metadata)
	}
	if s.SecurityProfileName != nil {
		v := *s.SecurityProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "securityProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ViolationId != nil {
		v := *s.ViolationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "violationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ViolationStartTime != nil {
		v := *s.ViolationStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "violationStartTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// A structure containing the alert target ARN and the role ARN.
type AlertTarget struct {
	_ struct{} `type:"structure"`

	// The ARN of the notification target to which alerts are sent.
	//
	// AlertTargetArn is a required field
	AlertTargetArn *string `locationName:"alertTargetArn" type:"string" required:"true"`

	// The ARN of the role that grants permission to send alerts to the notification
	// target.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AlertTarget) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlertTarget) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AlertTarget"}

	if s.AlertTargetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlertTargetArn"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AlertTarget) MarshalFields(e protocol.FieldEncoder) error {
	if s.AlertTargetArn != nil {
		v := *s.AlertTargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "alertTargetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information that allowed the authorization.
type Allowed struct {
	_ struct{} `type:"structure"`

	// A list of policies that allowed the authentication.
	Policies []Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s Allowed) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Allowed) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Policies) > 0 {
		v := s.Policies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "policies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The attribute payload.
type AttributePayload struct {
	_ struct{} `type:"structure"`

	// A JSON string containing up to three key-value pair in JSON format. For example:
	//
	// {\"attributes\":{\"string1\":\"string2\"}}
	Attributes map[string]string `locationName:"attributes" type:"map"`

	// Specifies whether the list of attributes provided in the AttributePayload
	// is merged with the attributes stored in the registry, instead of overwriting
	// them.
	//
	// To remove an attribute, call UpdateThing with an empty attribute value.
	//
	// The merge attribute is only valid when calling UpdateThing.
	Merge *bool `locationName:"merge" type:"boolean"`
}

// String returns the string representation
func (s AttributePayload) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttributePayload) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Merge != nil {
		v := *s.Merge

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "merge", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Which audit checks are enabled and disabled for this account.
type AuditCheckConfiguration struct {
	_ struct{} `type:"structure"`

	// True if this audit check is enabled for this account.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation
func (s AuditCheckConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuditCheckConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Information about the audit check.
type AuditCheckDetails struct {
	_ struct{} `type:"structure"`

	// True if the check completed and found all resources compliant.
	CheckCompliant *bool `locationName:"checkCompliant" type:"boolean"`

	// The completion status of this check, one of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION",
	// "CANCELED", "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
	CheckRunStatus AuditCheckRunStatus `locationName:"checkRunStatus" type:"string" enum:"true"`

	// The code of any error encountered when performing this check during this
	// audit. One of "INSUFFICIENT_PERMISSIONS", or "AUDIT_CHECK_DISABLED".
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The message associated with any error encountered when performing this check
	// during this audit.
	Message *string `locationName:"message" type:"string"`

	// The number of resources that the check found non-compliant.
	NonCompliantResourcesCount *int64 `locationName:"nonCompliantResourcesCount" type:"long"`

	// The number of resources on which the check was performed.
	TotalResourcesCount *int64 `locationName:"totalResourcesCount" type:"long"`
}

// String returns the string representation
func (s AuditCheckDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuditCheckDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.CheckCompliant != nil {
		v := *s.CheckCompliant

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "checkCompliant", protocol.BoolValue(v), metadata)
	}
	if len(s.CheckRunStatus) > 0 {
		v := s.CheckRunStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "checkRunStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NonCompliantResourcesCount != nil {
		v := *s.NonCompliantResourcesCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nonCompliantResourcesCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalResourcesCount != nil {
		v := *s.TotalResourcesCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "totalResourcesCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The findings (results) of the audit.
type AuditFinding struct {
	_ struct{} `type:"structure"`

	// The audit check that generated this result.
	CheckName *string `locationName:"checkName" type:"string"`

	// The time the result (finding) was discovered.
	FindingTime *time.Time `locationName:"findingTime" type:"timestamp" timestampFormat:"unix"`

	// The resource that was found to be non-compliant with the audit check.
	NonCompliantResource *NonCompliantResource `locationName:"nonCompliantResource" type:"structure"`

	// The reason the resource was non-compliant.
	ReasonForNonCompliance *string `locationName:"reasonForNonCompliance" type:"string"`

	// A code which indicates the reason that the resource was non-compliant.
	ReasonForNonComplianceCode *string `locationName:"reasonForNonComplianceCode" type:"string"`

	// The list of related resources.
	RelatedResources []RelatedResource `locationName:"relatedResources" type:"list"`

	// The severity of the result (finding).
	Severity AuditFindingSeverity `locationName:"severity" type:"string" enum:"true"`

	// The ID of the audit that generated this result (finding)
	TaskId *string `locationName:"taskId" min:"1" type:"string"`

	// The time the audit started.
	TaskStartTime *time.Time `locationName:"taskStartTime" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s AuditFinding) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuditFinding) MarshalFields(e protocol.FieldEncoder) error {
	if s.CheckName != nil {
		v := *s.CheckName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "checkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FindingTime != nil {
		v := *s.FindingTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "findingTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.NonCompliantResource != nil {
		v := s.NonCompliantResource

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "nonCompliantResource", v, metadata)
	}
	if s.ReasonForNonCompliance != nil {
		v := *s.ReasonForNonCompliance

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reasonForNonCompliance", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReasonForNonComplianceCode != nil {
		v := *s.ReasonForNonComplianceCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reasonForNonComplianceCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RelatedResources) > 0 {
		v := s.RelatedResources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "relatedResources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Severity) > 0 {
		v := s.Severity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "severity", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TaskId != nil {
		v := *s.TaskId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TaskStartTime != nil {
		v := *s.TaskStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskStartTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// Information about the targets to which audit notifications are sent.
type AuditNotificationTarget struct {
	_ struct{} `type:"structure"`

	// True if notifications to the target are enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The ARN of the role that grants permission to send notifications to the target.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The ARN of the target (SNS topic) to which audit notifications are sent.
	TargetArn *string `locationName:"targetArn" type:"string"`
}

// String returns the string representation
func (s AuditNotificationTarget) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuditNotificationTarget) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AuditNotificationTarget"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuditNotificationTarget) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enabled", protocol.BoolValue(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TargetArn != nil {
		v := *s.TargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The audits that were performed.
type AuditTaskMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of this audit.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`

	// The status of this audit: one of "IN_PROGRESS", "COMPLETED", "FAILED" or
	// "CANCELED".
	TaskStatus AuditTaskStatus `locationName:"taskStatus" type:"string" enum:"true"`

	// The type of this audit: one of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
	TaskType AuditTaskType `locationName:"taskType" type:"string" enum:"true"`
}

// String returns the string representation
func (s AuditTaskMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuditTaskMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.TaskId != nil {
		v := *s.TaskId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TaskStatus) > 0 {
		v := s.TaskStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TaskType) > 0 {
		v := s.TaskType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A collection of authorization information.
type AuthInfo struct {
	_ struct{} `type:"structure"`

	// The type of action for which the principal is being authorized.
	ActionType ActionType `locationName:"actionType" type:"string" enum:"true"`

	// The resources for which the principal is being authorized to perform the
	// specified action.
	Resources []string `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s AuthInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuthInfo) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ActionType) > 0 {
		v := s.ActionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "actionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Resources) > 0 {
		v := s.Resources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The authorizer result.
type AuthResult struct {
	_ struct{} `type:"structure"`

	// The policies and statements that allowed the specified action.
	Allowed *Allowed `locationName:"allowed" type:"structure"`

	// The final authorization decision of this scenario. Multiple statements are
	// taken into account when determining the authorization decision. An explicit
	// deny statement can override multiple allow statements.
	AuthDecision AuthDecision `locationName:"authDecision" type:"string" enum:"true"`

	// Authorization information.
	AuthInfo *AuthInfo `locationName:"authInfo" type:"structure"`

	// The policies and statements that denied the specified action.
	Denied *Denied `locationName:"denied" type:"structure"`

	// Contains any missing context values found while evaluating policy.
	MissingContextValues []string `locationName:"missingContextValues" type:"list"`
}

// String returns the string representation
func (s AuthResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuthResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.Allowed != nil {
		v := s.Allowed

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "allowed", v, metadata)
	}
	if len(s.AuthDecision) > 0 {
		v := s.AuthDecision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authDecision", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AuthInfo != nil {
		v := s.AuthInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "authInfo", v, metadata)
	}
	if s.Denied != nil {
		v := s.Denied

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "denied", v, metadata)
	}
	if len(s.MissingContextValues) > 0 {
		v := s.MissingContextValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "missingContextValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The authorizer description.
type AuthorizerDescription struct {
	_ struct{} `type:"structure"`

	// The authorizer ARN.
	AuthorizerArn *string `locationName:"authorizerArn" type:"string"`

	// The authorizer's Lambda function ARN.
	AuthorizerFunctionArn *string `locationName:"authorizerFunctionArn" type:"string"`

	// The authorizer name.
	AuthorizerName *string `locationName:"authorizerName" min:"1" type:"string"`

	// The UNIX timestamp of when the authorizer was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The UNIX timestamp of when the authorizer was last updated.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// The status of the authorizer.
	Status AuthorizerStatus `locationName:"status" type:"string" enum:"true"`

	// The key used to extract the token from the HTTP headers.
	TokenKeyName *string `locationName:"tokenKeyName" min:"1" type:"string"`

	// The public keys used to validate the token signature returned by your custom
	// authentication service.
	TokenSigningPublicKeys map[string]string `locationName:"tokenSigningPublicKeys" type:"map"`
}

// String returns the string representation
func (s AuthorizerDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuthorizerDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthorizerArn != nil {
		v := *s.AuthorizerArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerFunctionArn != nil {
		v := *s.AuthorizerFunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerFunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerName != nil {
		v := *s.AuthorizerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastModifiedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TokenKeyName != nil {
		v := *s.TokenKeyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "tokenKeyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TokenSigningPublicKeys) > 0 {
		v := s.TokenSigningPublicKeys

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tokenSigningPublicKeys", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// The authorizer summary.
type AuthorizerSummary struct {
	_ struct{} `type:"structure"`

	// The authorizer ARN.
	AuthorizerArn *string `locationName:"authorizerArn" type:"string"`

	// The authorizer name.
	AuthorizerName *string `locationName:"authorizerName" min:"1" type:"string"`
}

// String returns the string representation
func (s AuthorizerSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AuthorizerSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthorizerArn != nil {
		v := *s.AuthorizerArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerName != nil {
		v := *s.AuthorizerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Configuration for the rollout of OTA updates.
type AwsJobExecutionsRolloutConfig struct {
	_ struct{} `type:"structure"`

	// The maximum number of OTA update job executions started per minute.
	MaximumPerMinute *int64 `locationName:"maximumPerMinute" min:"1" type:"integer"`
}

// String returns the string representation
func (s AwsJobExecutionsRolloutConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsJobExecutionsRolloutConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AwsJobExecutionsRolloutConfig"}
	if s.MaximumPerMinute != nil && *s.MaximumPerMinute < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaximumPerMinute", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsJobExecutionsRolloutConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaximumPerMinute != nil {
		v := *s.MaximumPerMinute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maximumPerMinute", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A Device Defender security profile behavior.
type Behavior struct {
	_ struct{} `type:"structure"`

	// The criteria that determine if a device is behaving normally in regard to
	// the metric.
	Criteria *BehaviorCriteria `locationName:"criteria" type:"structure"`

	// What is measured by the behavior.
	Metric *string `locationName:"metric" type:"string"`

	// The name you have given to the behavior.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Behavior) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Behavior) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Behavior"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Criteria != nil {
		if err := s.Criteria.Validate(); err != nil {
			invalidParams.AddNested("Criteria", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Behavior) MarshalFields(e protocol.FieldEncoder) error {
	if s.Criteria != nil {
		v := s.Criteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "criteria", v, metadata)
	}
	if s.Metric != nil {
		v := *s.Metric

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "metric", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The criteria by which the behavior is determined to be normal.
type BehaviorCriteria struct {
	_ struct{} `type:"structure"`

	// The operator that relates the thing measured (metric) to the criteria (containing
	// a value or statisticalThreshold).
	ComparisonOperator ComparisonOperator `locationName:"comparisonOperator" type:"string" enum:"true"`

	// If a device is in violation of the behavior for the specified number of consecutive
	// datapoints, an alarm occurs. If not specified, the default is 1.
	ConsecutiveDatapointsToAlarm *int64 `locationName:"consecutiveDatapointsToAlarm" min:"1" type:"integer"`

	// If an alarm has occurred and the offending device is no longer in violation
	// of the behavior for the specified number of consecutive datapoints, the alarm
	// is cleared. If not specified, the default is 1.
	ConsecutiveDatapointsToClear *int64 `locationName:"consecutiveDatapointsToClear" min:"1" type:"integer"`

	// Use this to specify the time duration over which the behavior is evaluated,
	// for those criteria which have a time dimension (for example, NUM_MESSAGES_SENT).
	// For a statisticalThreshhold metric comparison, measurements from all devices
	// are accumulated over this time duration before being used to calculate percentiles,
	// and later, measurements from an individual device are also accumulated over
	// this time duration before being given a percentile rank.
	DurationSeconds *int64 `locationName:"durationSeconds" type:"integer"`

	// A statistical ranking (percentile) which indicates a threshold value by which
	// a behavior is determined to be in compliance or in violation of the behavior.
	StatisticalThreshold *StatisticalThreshold `locationName:"statisticalThreshold" type:"structure"`

	// The value to be compared with the metric.
	Value *MetricValue `locationName:"value" type:"structure"`
}

// String returns the string representation
func (s BehaviorCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BehaviorCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BehaviorCriteria"}
	if s.ConsecutiveDatapointsToAlarm != nil && *s.ConsecutiveDatapointsToAlarm < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ConsecutiveDatapointsToAlarm", 1))
	}
	if s.ConsecutiveDatapointsToClear != nil && *s.ConsecutiveDatapointsToClear < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ConsecutiveDatapointsToClear", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BehaviorCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ComparisonOperator) > 0 {
		v := s.ComparisonOperator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "comparisonOperator", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ConsecutiveDatapointsToAlarm != nil {
		v := *s.ConsecutiveDatapointsToAlarm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "consecutiveDatapointsToAlarm", protocol.Int64Value(v), metadata)
	}
	if s.ConsecutiveDatapointsToClear != nil {
		v := *s.ConsecutiveDatapointsToClear

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "consecutiveDatapointsToClear", protocol.Int64Value(v), metadata)
	}
	if s.DurationSeconds != nil {
		v := *s.DurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "durationSeconds", protocol.Int64Value(v), metadata)
	}
	if s.StatisticalThreshold != nil {
		v := s.StatisticalThreshold

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "statisticalThreshold", v, metadata)
	}
	if s.Value != nil {
		v := s.Value

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "value", v, metadata)
	}
	return nil
}

// Additional information about the billing group.
type BillingGroupMetadata struct {
	_ struct{} `type:"structure"`

	// The date the billing group was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s BillingGroupMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BillingGroupMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// The properties of a billing group.
type BillingGroupProperties struct {
	_ struct{} `type:"structure"`

	// The description of the billing group.
	BillingGroupDescription *string `locationName:"billingGroupDescription" type:"string"`
}

// String returns the string representation
func (s BillingGroupProperties) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BillingGroupProperties) MarshalFields(e protocol.FieldEncoder) error {
	if s.BillingGroupDescription != nil {
		v := *s.BillingGroupDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "billingGroupDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A CA certificate.
type CACertificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the CA certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the CA certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The date the CA certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The status of the CA certificate.
	//
	// The status value REGISTER_INACTIVE is deprecated and should not be used.
	Status CACertificateStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s CACertificate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CACertificate) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateId != nil {
		v := *s.CertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes a CA certificate.
type CACertificateDescription struct {
	_ struct{} `type:"structure"`

	// Whether the CA certificate configured for auto registration of device certificates.
	// Valid values are "ENABLE" and "DISABLE"
	AutoRegistrationStatus AutoRegistrationStatus `locationName:"autoRegistrationStatus" type:"string" enum:"true"`

	// The CA certificate ARN.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The CA certificate ID.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The CA certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The date the CA certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The customer version of the CA certificate.
	CustomerVersion *int64 `locationName:"customerVersion" min:"1" type:"integer"`

	// The generation ID of the CA certificate.
	GenerationId *string `locationName:"generationId" type:"string"`

	// The date the CA certificate was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// The owner of the CA certificate.
	OwnedBy *string `locationName:"ownedBy" min:"12" type:"string"`

	// The status of a CA certificate.
	Status CACertificateStatus `locationName:"status" type:"string" enum:"true"`

	// When the CA certificate is valid.
	Validity *CertificateValidity `locationName:"validity" type:"structure"`
}

// String returns the string representation
func (s CACertificateDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CACertificateDescription) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AutoRegistrationStatus) > 0 {
		v := s.AutoRegistrationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autoRegistrationStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateId != nil {
		v := *s.CertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificatePem != nil {
		v := *s.CertificatePem

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificatePem", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CustomerVersion != nil {
		v := *s.CustomerVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "customerVersion", protocol.Int64Value(v), metadata)
	}
	if s.GenerationId != nil {
		v := *s.GenerationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "generationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastModifiedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.OwnedBy != nil {
		v := *s.OwnedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ownedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Validity != nil {
		v := s.Validity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "validity", v, metadata)
	}
	return nil
}

// Information about a certificate.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. (The last part of the certificate ARN contains
	// the certificate ID.)
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The date and time the certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The status of the certificate.
	//
	// The status value REGISTER_INACTIVE is deprecated and should not be used.
	Status CertificateStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Certificate) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateId != nil {
		v := *s.CertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes a certificate.
type CertificateDescription struct {
	_ struct{} `type:"structure"`

	// The certificate ID of the CA certificate used to sign this certificate.
	CaCertificateId *string `locationName:"caCertificateId" min:"64" type:"string"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The date and time the certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The customer version of the certificate.
	CustomerVersion *int64 `locationName:"customerVersion" min:"1" type:"integer"`

	// The generation ID of the certificate.
	GenerationId *string `locationName:"generationId" type:"string"`

	// The date and time the certificate was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// The ID of the AWS account that owns the certificate.
	OwnedBy *string `locationName:"ownedBy" min:"12" type:"string"`

	// The ID of the AWS account of the previous owner of the certificate.
	PreviousOwnedBy *string `locationName:"previousOwnedBy" min:"12" type:"string"`

	// The status of the certificate.
	Status CertificateStatus `locationName:"status" type:"string" enum:"true"`

	// The transfer data.
	TransferData *TransferData `locationName:"transferData" type:"structure"`

	// When the certificate is valid.
	Validity *CertificateValidity `locationName:"validity" type:"structure"`
}

// String returns the string representation
func (s CertificateDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CertificateDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.CaCertificateId != nil {
		v := *s.CaCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "caCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateId != nil {
		v := *s.CertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificatePem != nil {
		v := *s.CertificatePem

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificatePem", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CustomerVersion != nil {
		v := *s.CustomerVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "customerVersion", protocol.Int64Value(v), metadata)
	}
	if s.GenerationId != nil {
		v := *s.GenerationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "generationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastModifiedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.OwnedBy != nil {
		v := *s.OwnedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ownedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PreviousOwnedBy != nil {
		v := *s.PreviousOwnedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "previousOwnedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TransferData != nil {
		v := s.TransferData

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "transferData", v, metadata)
	}
	if s.Validity != nil {
		v := s.Validity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "validity", v, metadata)
	}
	return nil
}

// When the certificate is valid.
type CertificateValidity struct {
	_ struct{} `type:"structure"`

	// The certificate is not valid after this date.
	NotAfter *time.Time `locationName:"notAfter" type:"timestamp" timestampFormat:"unix"`

	// The certificate is not valid before this date.
	NotBefore *time.Time `locationName:"notBefore" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s CertificateValidity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CertificateValidity) MarshalFields(e protocol.FieldEncoder) error {
	if s.NotAfter != nil {
		v := *s.NotAfter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "notAfter", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.NotBefore != nil {
		v := *s.NotBefore

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "notBefore", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// Describes an action that updates a CloudWatch alarm.
type CloudwatchAlarmAction struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarm name.
	//
	// AlarmName is a required field
	AlarmName *string `locationName:"alarmName" type:"string" required:"true"`

	// The IAM role that allows access to the CloudWatch alarm.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The reason for the alarm change.
	//
	// StateReason is a required field
	StateReason *string `locationName:"stateReason" type:"string" required:"true"`

	// The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
	//
	// StateValue is a required field
	StateValue *string `locationName:"stateValue" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudwatchAlarmAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudwatchAlarmAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudwatchAlarmAction"}

	if s.AlarmName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlarmName"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.StateReason == nil {
		invalidParams.Add(aws.NewErrParamRequired("StateReason"))
	}

	if s.StateValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("StateValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudwatchAlarmAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.AlarmName != nil {
		v := *s.AlarmName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "alarmName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StateReason != nil {
		v := *s.StateReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stateReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StateValue != nil {
		v := *s.StateValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stateValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an action that captures a CloudWatch metric.
type CloudwatchMetricAction struct {
	_ struct{} `type:"structure"`

	// The CloudWatch metric name.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true"`

	// The CloudWatch metric namespace name.
	//
	// MetricNamespace is a required field
	MetricNamespace *string `locationName:"metricNamespace" type:"string" required:"true"`

	// An optional Unix timestamp (https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
	MetricTimestamp *string `locationName:"metricTimestamp" type:"string"`

	// The metric unit (https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit)
	// supported by CloudWatch.
	//
	// MetricUnit is a required field
	MetricUnit *string `locationName:"metricUnit" type:"string" required:"true"`

	// The CloudWatch metric value.
	//
	// MetricValue is a required field
	MetricValue *string `locationName:"metricValue" type:"string" required:"true"`

	// The IAM role that allows access to the CloudWatch metric.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudwatchMetricAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudwatchMetricAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudwatchMetricAction"}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}

	if s.MetricNamespace == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricNamespace"))
	}

	if s.MetricUnit == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricUnit"))
	}

	if s.MetricValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricValue"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudwatchMetricAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.MetricName != nil {
		v := *s.MetricName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "metricName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MetricNamespace != nil {
		v := *s.MetricNamespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "metricNamespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MetricTimestamp != nil {
		v := *s.MetricTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "metricTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MetricUnit != nil {
		v := *s.MetricUnit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "metricUnit", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MetricValue != nil {
		v := *s.MetricValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "metricValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the method to use when code signing a file.
type CodeSigning struct {
	_ struct{} `type:"structure"`

	// The ID of the AWSSignerJob which was created to sign the file.
	AwsSignerJobId *string `locationName:"awsSignerJobId" type:"string"`

	// A custom method for code signing a file.
	CustomCodeSigning *CustomCodeSigning `locationName:"customCodeSigning" type:"structure"`

	// Describes the code-signing job.
	StartSigningJobParameter *StartSigningJobParameter `locationName:"startSigningJobParameter" type:"structure"`
}

// String returns the string representation
func (s CodeSigning) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeSigning) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeSigning"}
	if s.StartSigningJobParameter != nil {
		if err := s.StartSigningJobParameter.Validate(); err != nil {
			invalidParams.AddNested("StartSigningJobParameter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CodeSigning) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsSignerJobId != nil {
		v := *s.AwsSignerJobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsSignerJobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CustomCodeSigning != nil {
		v := s.CustomCodeSigning

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "customCodeSigning", v, metadata)
	}
	if s.StartSigningJobParameter != nil {
		v := s.StartSigningJobParameter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "startSigningJobParameter", v, metadata)
	}
	return nil
}

// Describes the certificate chain being used when code signing a file.
type CodeSigningCertificateChain struct {
	_ struct{} `type:"structure"`

	// The name of the certificate.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// A base64 encoded binary representation of the code signing certificate chain.
	InlineDocument *string `locationName:"inlineDocument" type:"string"`
}

// String returns the string representation
func (s CodeSigningCertificateChain) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CodeSigningCertificateChain) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateName != nil {
		v := *s.CertificateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InlineDocument != nil {
		v := *s.InlineDocument

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inlineDocument", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the signature for a file.
type CodeSigningSignature struct {
	_ struct{} `type:"structure"`

	// A base64 encoded binary representation of the code signing signature.
	//
	// InlineDocument is automatically base64 encoded/decoded by the SDK.
	InlineDocument []byte `locationName:"inlineDocument" type:"blob"`
}

// String returns the string representation
func (s CodeSigningSignature) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CodeSigningSignature) MarshalFields(e protocol.FieldEncoder) error {
	if s.InlineDocument != nil {
		v := s.InlineDocument

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inlineDocument", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// Configuration.
type Configuration struct {
	_ struct{} `type:"structure"`

	// True to enable the configuration.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Configuration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Describes a custom method used to code sign a file.
type CustomCodeSigning struct {
	_ struct{} `type:"structure"`

	// The certificate chain.
	CertificateChain *CodeSigningCertificateChain `locationName:"certificateChain" type:"structure"`

	// The hash algorithm used to code sign the file.
	HashAlgorithm *string `locationName:"hashAlgorithm" type:"string"`

	// The signature for the file.
	Signature *CodeSigningSignature `locationName:"signature" type:"structure"`

	// The signature algorithm used to code sign the file.
	SignatureAlgorithm *string `locationName:"signatureAlgorithm" type:"string"`
}

// String returns the string representation
func (s CustomCodeSigning) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomCodeSigning) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateChain != nil {
		v := s.CertificateChain

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "certificateChain", v, metadata)
	}
	if s.HashAlgorithm != nil {
		v := *s.HashAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "hashAlgorithm", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Signature != nil {
		v := s.Signature

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "signature", v, metadata)
	}
	if s.SignatureAlgorithm != nil {
		v := *s.SignatureAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "signatureAlgorithm", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information that denied the authorization.
type Denied struct {
	_ struct{} `type:"structure"`

	// Information that explicitly denies the authorization.
	ExplicitDeny *ExplicitDeny `locationName:"explicitDeny" type:"structure"`

	// Information that implicitly denies the authorization. When a policy doesn't
	// explicitly deny or allow an action on a resource it is considered an implicit
	// deny.
	ImplicitDeny *ImplicitDeny `locationName:"implicitDeny" type:"structure"`
}

// String returns the string representation
func (s Denied) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Denied) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExplicitDeny != nil {
		v := s.ExplicitDeny

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "explicitDeny", v, metadata)
	}
	if s.ImplicitDeny != nil {
		v := s.ImplicitDeny

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "implicitDeny", v, metadata)
	}
	return nil
}

// Describes the location of the updated firmware.
type Destination struct {
	_ struct{} `type:"structure"`

	// Describes the location in S3 of the updated firmware.
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Destination"}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Destination) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Destination != nil {
		v := s.S3Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3Destination", v, metadata)
	}
	return nil
}

// Describes an action to write to a DynamoDB table.
//
// The tableName, hashKeyField, and rangeKeyField values must match the values
// used when you created the table.
//
// The hashKeyValue and rangeKeyvalue fields use a substitution template syntax.
// These templates provide data at runtime. The syntax is as follows: ${sql-expression}.
//
// You can specify any valid expression in a WHERE or SELECT clause, including
// JSON properties, comparisons, calculations, and functions. For example, the
// following field uses the third level of the topic:
//
// "hashKeyValue": "${topic(3)}"
//
// The following field uses the timestamp:
//
// "rangeKeyValue": "${timestamp()}"
type DynamoDBAction struct {
	_ struct{} `type:"structure"`

	// The hash key name.
	//
	// HashKeyField is a required field
	HashKeyField *string `locationName:"hashKeyField" type:"string" required:"true"`

	// The hash key type. Valid values are "STRING" or "NUMBER"
	HashKeyType DynamoKeyType `locationName:"hashKeyType" type:"string" enum:"true"`

	// The hash key value.
	//
	// HashKeyValue is a required field
	HashKeyValue *string `locationName:"hashKeyValue" type:"string" required:"true"`

	// The type of operation to be performed. This follows the substitution template,
	// so it can be ${operation}, but the substitution must result in one of the
	// following: INSERT, UPDATE, or DELETE.
	Operation *string `locationName:"operation" type:"string"`

	// The action payload. This name can be customized.
	PayloadField *string `locationName:"payloadField" type:"string"`

	// The range key name.
	RangeKeyField *string `locationName:"rangeKeyField" type:"string"`

	// The range key type. Valid values are "STRING" or "NUMBER"
	RangeKeyType DynamoKeyType `locationName:"rangeKeyType" type:"string" enum:"true"`

	// The range key value.
	RangeKeyValue *string `locationName:"rangeKeyValue" type:"string"`

	// The ARN of the IAM role that grants access to the DynamoDB table.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the DynamoDB table.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" type:"string" required:"true"`
}

// String returns the string representation
func (s DynamoDBAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamoDBAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DynamoDBAction"}

	if s.HashKeyField == nil {
		invalidParams.Add(aws.NewErrParamRequired("HashKeyField"))
	}

	if s.HashKeyValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("HashKeyValue"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DynamoDBAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.HashKeyField != nil {
		v := *s.HashKeyField

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "hashKeyField", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.HashKeyType) > 0 {
		v := s.HashKeyType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "hashKeyType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.HashKeyValue != nil {
		v := *s.HashKeyValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "hashKeyValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Operation != nil {
		v := *s.Operation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "operation", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PayloadField != nil {
		v := *s.PayloadField

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "payloadField", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RangeKeyField != nil {
		v := *s.RangeKeyField

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rangeKeyField", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RangeKeyType) > 0 {
		v := s.RangeKeyType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rangeKeyType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RangeKeyValue != nil {
		v := *s.RangeKeyValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rangeKeyValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TableName != nil {
		v := *s.TableName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "tableName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an action to write to a DynamoDB table.
//
// This DynamoDB action writes each attribute in the message payload into it's
// own column in the DynamoDB table.
type DynamoDBv2Action struct {
	_ struct{} `type:"structure"`

	// Specifies the DynamoDB table to which the message data will be written. For
	// example:
	//
	// { "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName":
	// "my-table" } } }
	//
	// Each attribute in the message payload will be written to a separate column
	// in the DynamoDB database.
	//
	// PutItem is a required field
	PutItem *PutItemInput `locationName:"putItem" type:"structure" required:"true"`

	// The ARN of the IAM role that grants access to the DynamoDB table.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DynamoDBv2Action) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamoDBv2Action) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DynamoDBv2Action"}

	if s.PutItem == nil {
		invalidParams.Add(aws.NewErrParamRequired("PutItem"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.PutItem != nil {
		if err := s.PutItem.Validate(); err != nil {
			invalidParams.AddNested("PutItem", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DynamoDBv2Action) MarshalFields(e protocol.FieldEncoder) error {
	if s.PutItem != nil {
		v := s.PutItem

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "putItem", v, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The policy that has the effect on the authorization results.
type EffectivePolicy struct {
	_ struct{} `type:"structure"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The IAM policy document.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`
}

// String returns the string representation
func (s EffectivePolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EffectivePolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.PolicyArn != nil {
		v := *s.PolicyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyDocument != nil {
		v := *s.PolicyDocument

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyDocument", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyName != nil {
		v := *s.PolicyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an action that writes data to an Amazon Elasticsearch Service domain.
type ElasticsearchAction struct {
	_ struct{} `type:"structure"`

	// The endpoint of your Elasticsearch domain.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" type:"string" required:"true"`

	// The unique identifier for the document you are storing.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The Elasticsearch index where you want to store your data.
	//
	// Index is a required field
	Index *string `locationName:"index" type:"string" required:"true"`

	// The IAM role ARN that has access to Elasticsearch.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The type of document you are storing.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticsearchAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ElasticsearchAction"}

	if s.Endpoint == nil {
		invalidParams.Add(aws.NewErrParamRequired("Endpoint"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.Index == nil {
		invalidParams.Add(aws.NewErrParamRequired("Index"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ElasticsearchAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Endpoint != nil {
		v := *s.Endpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Index != nil {
		v := *s.Index

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "index", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Error information.
type ErrorInfo struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string"`

	// The error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := *s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information that explicitly denies authorization.
type ExplicitDeny struct {
	_ struct{} `type:"structure"`

	// The policies that denied the authorization.
	Policies []Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ExplicitDeny) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExplicitDeny) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Policies) > 0 {
		v := s.Policies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "policies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Allows you to create an exponential rate of rollout for a job.
type ExponentialRolloutRate struct {
	_ struct{} `type:"structure"`

	// The minimum number of things that will be notified of a pending job, per
	// minute at the start of job rollout. This parameter allows you to define the
	// initial rate of rollout.
	//
	// BaseRatePerMinute is a required field
	BaseRatePerMinute *int64 `locationName:"baseRatePerMinute" min:"1" type:"integer" required:"true"`

	// The exponential factor to increase the rate of rollout for a job.
	//
	// IncrementFactor is a required field
	IncrementFactor *float64 `locationName:"incrementFactor" min:"1" type:"double" required:"true"`

	// The criteria to initiate the increase in rate of rollout for a job.
	//
	// AWS IoT supports up to one digit after the decimal (for example, 1.5, but
	// not 1.55).
	//
	// RateIncreaseCriteria is a required field
	RateIncreaseCriteria *RateIncreaseCriteria `locationName:"rateIncreaseCriteria" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExponentialRolloutRate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExponentialRolloutRate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExponentialRolloutRate"}

	if s.BaseRatePerMinute == nil {
		invalidParams.Add(aws.NewErrParamRequired("BaseRatePerMinute"))
	}
	if s.BaseRatePerMinute != nil && *s.BaseRatePerMinute < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("BaseRatePerMinute", 1))
	}

	if s.IncrementFactor == nil {
		invalidParams.Add(aws.NewErrParamRequired("IncrementFactor"))
	}
	if s.IncrementFactor != nil && *s.IncrementFactor < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("IncrementFactor", 1))
	}

	if s.RateIncreaseCriteria == nil {
		invalidParams.Add(aws.NewErrParamRequired("RateIncreaseCriteria"))
	}
	if s.RateIncreaseCriteria != nil {
		if err := s.RateIncreaseCriteria.Validate(); err != nil {
			invalidParams.AddNested("RateIncreaseCriteria", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExponentialRolloutRate) MarshalFields(e protocol.FieldEncoder) error {
	if s.BaseRatePerMinute != nil {
		v := *s.BaseRatePerMinute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "baseRatePerMinute", protocol.Int64Value(v), metadata)
	}
	if s.IncrementFactor != nil {
		v := *s.IncrementFactor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "incrementFactor", protocol.Float64Value(v), metadata)
	}
	if s.RateIncreaseCriteria != nil {
		v := s.RateIncreaseCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "rateIncreaseCriteria", v, metadata)
	}
	return nil
}

// The location of the OTA update.
type FileLocation struct {
	_ struct{} `type:"structure"`

	// The location of the updated firmware in S3.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`

	// The stream that contains the OTA update.
	Stream *Stream `locationName:"stream" type:"structure"`
}

// String returns the string representation
func (s FileLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FileLocation"}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(aws.ErrInvalidParams))
		}
	}
	if s.Stream != nil {
		if err := s.Stream.Validate(); err != nil {
			invalidParams.AddNested("Stream", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FileLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Location != nil {
		v := s.S3Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3Location", v, metadata)
	}
	if s.Stream != nil {
		v := s.Stream

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "stream", v, metadata)
	}
	return nil
}

// Describes an action that writes data to an Amazon Kinesis Firehose stream.
type FirehoseAction struct {
	_ struct{} `type:"structure"`

	// The delivery stream name.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `locationName:"deliveryStreamName" type:"string" required:"true"`

	// The IAM role that grants access to the Amazon Kinesis Firehose stream.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// A character separator that will be used to separate records written to the
	// Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows
	// newline), ',' (comma).
	Separator *string `locationName:"separator" type:"string"`
}

// String returns the string representation
func (s FirehoseAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirehoseAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FirehoseAction"}

	if s.DeliveryStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeliveryStreamName"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FirehoseAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeliveryStreamName != nil {
		v := *s.DeliveryStreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deliveryStreamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Separator != nil {
		v := *s.Separator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "separator", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The name and ARN of a group.
type GroupNameAndArn struct {
	_ struct{} `type:"structure"`

	// The group ARN.
	GroupArn *string `locationName:"groupArn" type:"string"`

	// The group name.
	GroupName *string `locationName:"groupName" min:"1" type:"string"`
}

// String returns the string representation
func (s GroupNameAndArn) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupNameAndArn) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupArn != nil {
		v := *s.GroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information that implicitly denies authorization. When policy doesn't explicitly
// deny or allow an action on a resource it is considered an implicit deny.
type ImplicitDeny struct {
	_ struct{} `type:"structure"`

	// Policies that don't contain a matching allow or deny statement for the specified
	// action on the specified resource.
	Policies []Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ImplicitDeny) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImplicitDeny) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Policies) > 0 {
		v := s.Policies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "policies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Sends messge data to an AWS IoT Analytics channel.
type IotAnalyticsAction struct {
	_ struct{} `type:"structure"`

	// (deprecated) The ARN of the IoT Analytics channel to which message data will
	// be sent.
	ChannelArn *string `locationName:"channelArn" type:"string"`

	// The name of the IoT Analytics channel to which message data will be sent.
	ChannelName *string `locationName:"channelName" type:"string"`

	// The ARN of the role which has a policy that grants IoT Analytics permission
	// to send message data via IoT Analytics (iotanalytics:BatchPutMessage).
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s IotAnalyticsAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IotAnalyticsAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChannelArn != nil {
		v := *s.ChannelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChannelName != nil {
		v := *s.ChannelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Sends an input to an AWS IoT Events detector.
type IotEventsAction struct {
	_ struct{} `type:"structure"`

	// The name of the AWS IoT Events input.
	//
	// InputName is a required field
	InputName *string `locationName:"inputName" min:"1" type:"string" required:"true"`

	// [Optional] Use this to ensure that only one input (message) with a given
	// messageId will be processed by an AWS IoT Events detector.
	MessageId *string `locationName:"messageId" type:"string"`

	// The ARN of the role that grants AWS IoT permission to send an input to an
	// AWS IoT Events detector. ("Action":"iotevents:BatchPutMessage").
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s IotEventsAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IotEventsAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IotEventsAction"}

	if s.InputName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputName", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IotEventsAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.InputName != nil {
		v := *s.InputName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "messageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The Job object contains details about a job.
type Job struct {
	_ struct{} `type:"structure"`

	// Configuration for criteria to abort the job.
	AbortConfig *AbortConfig `locationName:"abortConfig" type:"structure"`

	// If the job was updated, describes the reason for the update.
	Comment *string `locationName:"comment" type:"string"`

	// The time, in seconds since the epoch, when the job was completed.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp" timestampFormat:"unix"`

	// The time, in seconds since the epoch, when the job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// A short text description of the job.
	Description *string `locationName:"description" type:"string"`

	// Will be true if the job was canceled with the optional force parameter set
	// to true.
	ForceCanceled *bool `locationName:"forceCanceled" type:"boolean"`

	// An ARN identifying the job with format "arn:aws:iot:region:account:job/jobId".
	JobArn *string `locationName:"jobArn" type:"string"`

	// Allows you to create a staged rollout of a job.
	JobExecutionsRolloutConfig *JobExecutionsRolloutConfig `locationName:"jobExecutionsRolloutConfig" type:"structure"`

	// The unique identifier you assigned to this job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`

	// Details about the job process.
	JobProcessDetails *JobProcessDetails `locationName:"jobProcessDetails" type:"structure"`

	// The time, in seconds since the epoch, when the job was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// Configuration for pre-signed S3 URLs.
	PresignedUrlConfig *PresignedUrlConfig `locationName:"presignedUrlConfig" type:"structure"`

	// If the job was updated, provides the reason code for the update.
	ReasonCode *string `locationName:"reasonCode" type:"string"`

	// The status of the job, one of IN_PROGRESS, CANCELED, DELETION_IN_PROGRESS
	// or COMPLETED.
	Status JobStatus `locationName:"status" type:"string" enum:"true"`

	// Specifies whether the job will continue to run (CONTINUOUS), or will be complete
	// after all those things specified as targets have completed the job (SNAPSHOT).
	// If continuous, the job may also be run on a thing when a change is detected
	// in a target. For example, a job will run on a device when the thing representing
	// the device is added to a target group, even after the job was completed by
	// all things originally in the group.
	TargetSelection TargetSelection `locationName:"targetSelection" type:"string" enum:"true"`

	// A list of IoT things and thing groups to which the job should be sent.
	Targets []string `locationName:"targets" min:"1" type:"list"`

	// Specifies the amount of time each device has to finish its execution of the
	// job. A timer is started when the job execution status is set to IN_PROGRESS.
	// If the job execution status is not set to another terminal state before the
	// timer expires, it will be automatically set to TIMED_OUT.
	TimeoutConfig *TimeoutConfig `locationName:"timeoutConfig" type:"structure"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Job) MarshalFields(e protocol.FieldEncoder) error {
	if s.AbortConfig != nil {
		v := s.AbortConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "abortConfig", v, metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "comment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CompletedAt != nil {
		v := *s.CompletedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "completedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ForceCanceled != nil {
		v := *s.ForceCanceled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "forceCanceled", protocol.BoolValue(v), metadata)
	}
	if s.JobArn != nil {
		v := *s.JobArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobExecutionsRolloutConfig != nil {
		v := s.JobExecutionsRolloutConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "jobExecutionsRolloutConfig", v, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobProcessDetails != nil {
		v := s.JobProcessDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "jobProcessDetails", v, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.PresignedUrlConfig != nil {
		v := s.PresignedUrlConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "presignedUrlConfig", v, metadata)
	}
	if s.ReasonCode != nil {
		v := *s.ReasonCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reasonCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TargetSelection) > 0 {
		v := s.TargetSelection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetSelection", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Targets) > 0 {
		v := s.Targets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "targets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.TimeoutConfig != nil {
		v := s.TimeoutConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "timeoutConfig", v, metadata)
	}
	return nil
}

// The job execution object represents the execution of a job on a particular
// device.
type JobExecution struct {
	_ struct{} `type:"structure"`

	// The estimated number of seconds that remain before the job execution status
	// will be changed to TIMED_OUT. The timeout interval can be anywhere between
	// 1 minute and 7 days (1 to 10080 minutes). The actual job execution timeout
	// can occur up to 60 seconds later than the estimated duration. This value
	// will not be included if the job execution has reached a terminal status.
	ApproximateSecondsBeforeTimedOut *int64 `locationName:"approximateSecondsBeforeTimedOut" type:"long"`

	// A string (consisting of the digits "0" through "9") which identifies this
	// particular job execution on this particular device. It can be used in commands
	// which return or update job execution information.
	ExecutionNumber *int64 `locationName:"executionNumber" type:"long"`

	// Will be true if the job execution was canceled with the optional force parameter
	// set to true.
	ForceCanceled *bool `locationName:"forceCanceled" type:"boolean"`

	// The unique identifier you assigned to the job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`

	// The time, in seconds since the epoch, when the job execution was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// The time, in seconds since the epoch, when the job execution was queued.
	QueuedAt *time.Time `locationName:"queuedAt" type:"timestamp" timestampFormat:"unix"`

	// The time, in seconds since the epoch, when the job execution started.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"unix"`

	// The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED,
	// TIMED_OUT, CANCELED, or REJECTED).
	Status JobExecutionStatus `locationName:"status" type:"string" enum:"true"`

	// A collection of name/value pairs that describe the status of the job execution.
	StatusDetails *JobExecutionStatusDetails `locationName:"statusDetails" type:"structure"`

	// The ARN of the thing on which the job execution is running.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The version of the job execution. Job execution versions are incremented
	// each time they are updated by a device.
	VersionNumber *int64 `locationName:"versionNumber" type:"long"`
}

// String returns the string representation
func (s JobExecution) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobExecution) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApproximateSecondsBeforeTimedOut != nil {
		v := *s.ApproximateSecondsBeforeTimedOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "approximateSecondsBeforeTimedOut", protocol.Int64Value(v), metadata)
	}
	if s.ExecutionNumber != nil {
		v := *s.ExecutionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "executionNumber", protocol.Int64Value(v), metadata)
	}
	if s.ForceCanceled != nil {
		v := *s.ForceCanceled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "forceCanceled", protocol.BoolValue(v), metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.QueuedAt != nil {
		v := *s.QueuedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queuedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.StartedAt != nil {
		v := *s.StartedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusDetails != nil {
		v := s.StatusDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "statusDetails", v, metadata)
	}
	if s.ThingArn != nil {
		v := *s.ThingArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "versionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Details of the job execution status.
type JobExecutionStatusDetails struct {
	_ struct{} `type:"structure"`

	// The job execution status.
	DetailsMap map[string]string `locationName:"detailsMap" type:"map"`
}

// String returns the string representation
func (s JobExecutionStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobExecutionStatusDetails) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DetailsMap) > 0 {
		v := s.DetailsMap

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "detailsMap", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// The job execution summary.
type JobExecutionSummary struct {
	_ struct{} `type:"structure"`

	// A string (consisting of the digits "0" through "9") which identifies this
	// particular job execution on this particular device. It can be used later
	// in commands which return or update job execution information.
	ExecutionNumber *int64 `locationName:"executionNumber" type:"long"`

	// The time, in seconds since the epoch, when the job execution was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// The time, in seconds since the epoch, when the job execution was queued.
	QueuedAt *time.Time `locationName:"queuedAt" type:"timestamp" timestampFormat:"unix"`

	// The time, in seconds since the epoch, when the job execution started.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"unix"`

	// The status of the job execution.
	Status JobExecutionStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s JobExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobExecutionSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExecutionNumber != nil {
		v := *s.ExecutionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "executionNumber", protocol.Int64Value(v), metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.QueuedAt != nil {
		v := *s.QueuedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queuedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.StartedAt != nil {
		v := *s.StartedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains a summary of information about job executions for a specific job.
type JobExecutionSummaryForJob struct {
	_ struct{} `type:"structure"`

	// Contains a subset of information about a job execution.
	JobExecutionSummary *JobExecutionSummary `locationName:"jobExecutionSummary" type:"structure"`

	// The ARN of the thing on which the job execution is running.
	ThingArn *string `locationName:"thingArn" type:"string"`
}

// String returns the string representation
func (s JobExecutionSummaryForJob) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobExecutionSummaryForJob) MarshalFields(e protocol.FieldEncoder) error {
	if s.JobExecutionSummary != nil {
		v := s.JobExecutionSummary

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "jobExecutionSummary", v, metadata)
	}
	if s.ThingArn != nil {
		v := *s.ThingArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The job execution summary for a thing.
type JobExecutionSummaryForThing struct {
	_ struct{} `type:"structure"`

	// Contains a subset of information about a job execution.
	JobExecutionSummary *JobExecutionSummary `locationName:"jobExecutionSummary" type:"structure"`

	// The unique identifier you assigned to this job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`
}

// String returns the string representation
func (s JobExecutionSummaryForThing) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobExecutionSummaryForThing) MarshalFields(e protocol.FieldEncoder) error {
	if s.JobExecutionSummary != nil {
		v := s.JobExecutionSummary

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "jobExecutionSummary", v, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Allows you to create a staged rollout of a job.
type JobExecutionsRolloutConfig struct {
	_ struct{} `type:"structure"`

	// The rate of increase for a job rollout. This parameter allows you to define
	// an exponential rate for a job rollout.
	ExponentialRate *ExponentialRolloutRate `locationName:"exponentialRate" type:"structure"`

	// The maximum number of things that will be notified of a pending job, per
	// minute. This parameter allows you to create a staged rollout.
	MaximumPerMinute *int64 `locationName:"maximumPerMinute" min:"1" type:"integer"`
}

// String returns the string representation
func (s JobExecutionsRolloutConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobExecutionsRolloutConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JobExecutionsRolloutConfig"}
	if s.MaximumPerMinute != nil && *s.MaximumPerMinute < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaximumPerMinute", 1))
	}
	if s.ExponentialRate != nil {
		if err := s.ExponentialRate.Validate(); err != nil {
			invalidParams.AddNested("ExponentialRate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobExecutionsRolloutConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExponentialRate != nil {
		v := s.ExponentialRate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "exponentialRate", v, metadata)
	}
	if s.MaximumPerMinute != nil {
		v := *s.MaximumPerMinute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maximumPerMinute", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The job process details.
type JobProcessDetails struct {
	_ struct{} `type:"structure"`

	// The number of things that cancelled the job.
	NumberOfCanceledThings *int64 `locationName:"numberOfCanceledThings" type:"integer"`

	// The number of things that failed executing the job.
	NumberOfFailedThings *int64 `locationName:"numberOfFailedThings" type:"integer"`

	// The number of things currently executing the job.
	NumberOfInProgressThings *int64 `locationName:"numberOfInProgressThings" type:"integer"`

	// The number of things that are awaiting execution of the job.
	NumberOfQueuedThings *int64 `locationName:"numberOfQueuedThings" type:"integer"`

	// The number of things that rejected the job.
	NumberOfRejectedThings *int64 `locationName:"numberOfRejectedThings" type:"integer"`

	// The number of things that are no longer scheduled to execute the job because
	// they have been deleted or have been removed from the group that was a target
	// of the job.
	NumberOfRemovedThings *int64 `locationName:"numberOfRemovedThings" type:"integer"`

	// The number of things which successfully completed the job.
	NumberOfSucceededThings *int64 `locationName:"numberOfSucceededThings" type:"integer"`

	// The number of things whose job execution status is TIMED_OUT.
	NumberOfTimedOutThings *int64 `locationName:"numberOfTimedOutThings" type:"integer"`

	// The target devices to which the job execution is being rolled out. This value
	// will be null after the job execution has finished rolling out to all the
	// target devices.
	ProcessingTargets []string `locationName:"processingTargets" type:"list"`
}

// String returns the string representation
func (s JobProcessDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobProcessDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.NumberOfCanceledThings != nil {
		v := *s.NumberOfCanceledThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfCanceledThings", protocol.Int64Value(v), metadata)
	}
	if s.NumberOfFailedThings != nil {
		v := *s.NumberOfFailedThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfFailedThings", protocol.Int64Value(v), metadata)
	}
	if s.NumberOfInProgressThings != nil {
		v := *s.NumberOfInProgressThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfInProgressThings", protocol.Int64Value(v), metadata)
	}
	if s.NumberOfQueuedThings != nil {
		v := *s.NumberOfQueuedThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfQueuedThings", protocol.Int64Value(v), metadata)
	}
	if s.NumberOfRejectedThings != nil {
		v := *s.NumberOfRejectedThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfRejectedThings", protocol.Int64Value(v), metadata)
	}
	if s.NumberOfRemovedThings != nil {
		v := *s.NumberOfRemovedThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfRemovedThings", protocol.Int64Value(v), metadata)
	}
	if s.NumberOfSucceededThings != nil {
		v := *s.NumberOfSucceededThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfSucceededThings", protocol.Int64Value(v), metadata)
	}
	if s.NumberOfTimedOutThings != nil {
		v := *s.NumberOfTimedOutThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfTimedOutThings", protocol.Int64Value(v), metadata)
	}
	if len(s.ProcessingTargets) > 0 {
		v := s.ProcessingTargets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "processingTargets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The job summary.
type JobSummary struct {
	_ struct{} `type:"structure"`

	// The time, in seconds since the epoch, when the job completed.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp" timestampFormat:"unix"`

	// The time, in seconds since the epoch, when the job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The job ARN.
	JobArn *string `locationName:"jobArn" type:"string"`

	// The unique identifier you assigned to this job when it was created.
	JobId *string `locationName:"jobId" min:"1" type:"string"`

	// The time, in seconds since the epoch, when the job was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// The job summary status.
	Status JobStatus `locationName:"status" type:"string" enum:"true"`

	// Specifies whether the job will continue to run (CONTINUOUS), or will be complete
	// after all those things specified as targets have completed the job (SNAPSHOT).
	// If continuous, the job may also be run on a thing when a change is detected
	// in a target. For example, a job will run on a thing when the thing is added
	// to a target group, even after the job was completed by all things originally
	// in the group.
	TargetSelection TargetSelection `locationName:"targetSelection" type:"string" enum:"true"`

	// The ID of the thing group.
	ThingGroupId *string `locationName:"thingGroupId" min:"1" type:"string"`
}

// String returns the string representation
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CompletedAt != nil {
		v := *s.CompletedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "completedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.JobArn != nil {
		v := *s.JobArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TargetSelection) > 0 {
		v := s.TargetSelection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetSelection", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ThingGroupId != nil {
		v := *s.ThingGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a key pair.
type KeyPair struct {
	_ struct{} `type:"structure"`

	// The private key.
	PrivateKey *string `min:"1" type:"string"`

	// The public key.
	PublicKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyPair) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s KeyPair) MarshalFields(e protocol.FieldEncoder) error {
	if s.PrivateKey != nil {
		v := *s.PrivateKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrivateKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PublicKey != nil {
		v := *s.PublicKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PublicKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an action to write data to an Amazon Kinesis stream.
type KinesisAction struct {
	_ struct{} `type:"structure"`

	// The partition key.
	PartitionKey *string `locationName:"partitionKey" type:"string"`

	// The ARN of the IAM role that grants access to the Amazon Kinesis stream.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the Amazon Kinesis stream.
	//
	// StreamName is a required field
	StreamName *string `locationName:"streamName" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisAction"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.StreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s KinesisAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.PartitionKey != nil {
		v := *s.PartitionKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "partitionKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamName != nil {
		v := *s.StreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an action to invoke a Lambda function.
type LambdaAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the Lambda function.
	//
	// FunctionArn is a required field
	FunctionArn *string `locationName:"functionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaAction"}

	if s.FunctionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "functionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A log target.
type LogTarget struct {
	_ struct{} `type:"structure"`

	// The target name.
	TargetName *string `locationName:"targetName" type:"string"`

	// The target type.
	//
	// TargetType is a required field
	TargetType LogTargetType `locationName:"targetType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s LogTarget) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogTarget) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LogTarget"}
	if len(s.TargetType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LogTarget) MarshalFields(e protocol.FieldEncoder) error {
	if s.TargetName != nil {
		v := *s.TargetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TargetType) > 0 {
		v := s.TargetType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The target configuration.
type LogTargetConfiguration struct {
	_ struct{} `type:"structure"`

	// The logging level.
	LogLevel LogLevel `locationName:"logLevel" type:"string" enum:"true"`

	// A log target
	LogTarget *LogTarget `locationName:"logTarget" type:"structure"`
}

// String returns the string representation
func (s LogTargetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LogTargetConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LogLevel) > 0 {
		v := s.LogLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "logLevel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LogTarget != nil {
		v := s.LogTarget

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "logTarget", v, metadata)
	}
	return nil
}

// Describes the logging options payload.
type LoggingOptionsPayload struct {
	_ struct{} `type:"structure"`

	// The log level.
	LogLevel LogLevel `locationName:"logLevel" type:"string" enum:"true"`

	// The ARN of the IAM role that grants access.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingOptionsPayload) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingOptionsPayload) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingOptionsPayload"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggingOptionsPayload) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LogLevel) > 0 {
		v := s.LogLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "logLevel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The value to be compared with the metric.
type MetricValue struct {
	_ struct{} `type:"structure"`

	// If the comparisonOperator calls for a set of CIDRs, use this to specify that
	// set to be compared with the metric.
	Cidrs []string `locationName:"cidrs" type:"list"`

	// If the comparisonOperator calls for a numeric value, use this to specify
	// that numeric value to be compared with the metric.
	Count *int64 `locationName:"count" type:"long"`

	// If the comparisonOperator calls for a set of ports, use this to specify that
	// set to be compared with the metric.
	Ports []int64 `locationName:"ports" type:"list"`
}

// String returns the string representation
func (s MetricValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricValue) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Cidrs) > 0 {
		v := s.Cidrs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "cidrs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if len(s.Ports) > 0 {
		v := s.Ports

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ports", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.Int64Value(v1))
		}
		ls0.End()

	}
	return nil
}

// Information about the resource that was non-compliant with the audit check.
type NonCompliantResource struct {
	_ struct{} `type:"structure"`

	// Additional information about the non-compliant resource.
	AdditionalInfo map[string]string `locationName:"additionalInfo" type:"map"`

	// Information identifying the non-compliant resource.
	ResourceIdentifier *ResourceIdentifier `locationName:"resourceIdentifier" type:"structure"`

	// The type of the non-compliant resource.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s NonCompliantResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NonCompliantResource) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdditionalInfo) > 0 {
		v := s.AdditionalInfo

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "additionalInfo", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ResourceIdentifier != nil {
		v := s.ResourceIdentifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resourceIdentifier", v, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes a file to be associated with an OTA update.
type OTAUpdateFile struct {
	_ struct{} `type:"structure"`

	// A list of name/attribute pairs.
	Attributes map[string]string `locationName:"attributes" type:"map"`

	// The code signing method of the file.
	CodeSigning *CodeSigning `locationName:"codeSigning" type:"structure"`

	// The location of the updated firmware.
	FileLocation *FileLocation `locationName:"fileLocation" type:"structure"`

	// The name of the file.
	FileName *string `locationName:"fileName" type:"string"`

	// The file version.
	FileVersion *string `locationName:"fileVersion" type:"string"`
}

// String returns the string representation
func (s OTAUpdateFile) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OTAUpdateFile) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OTAUpdateFile"}
	if s.CodeSigning != nil {
		if err := s.CodeSigning.Validate(); err != nil {
			invalidParams.AddNested("CodeSigning", err.(aws.ErrInvalidParams))
		}
	}
	if s.FileLocation != nil {
		if err := s.FileLocation.Validate(); err != nil {
			invalidParams.AddNested("FileLocation", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OTAUpdateFile) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.CodeSigning != nil {
		v := s.CodeSigning

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "codeSigning", v, metadata)
	}
	if s.FileLocation != nil {
		v := s.FileLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "fileLocation", v, metadata)
	}
	if s.FileName != nil {
		v := *s.FileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FileVersion != nil {
		v := *s.FileVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fileVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about an OTA update.
type OTAUpdateInfo struct {
	_ struct{} `type:"structure"`

	// A collection of name/value pairs
	AdditionalParameters map[string]string `locationName:"additionalParameters" type:"map"`

	// The AWS IoT job ARN associated with the OTA update.
	AwsIotJobArn *string `locationName:"awsIotJobArn" type:"string"`

	// The AWS IoT job ID associated with the OTA update.
	AwsIotJobId *string `locationName:"awsIotJobId" type:"string"`

	// Configuration for the rollout of OTA updates.
	AwsJobExecutionsRolloutConfig *AwsJobExecutionsRolloutConfig `locationName:"awsJobExecutionsRolloutConfig" type:"structure"`

	// The date when the OTA update was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// A description of the OTA update.
	Description *string `locationName:"description" type:"string"`

	// Error information associated with the OTA update.
	ErrorInfo *ErrorInfo `locationName:"errorInfo" type:"structure"`

	// The date when the OTA update was last updated.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// The OTA update ARN.
	OtaUpdateArn *string `locationName:"otaUpdateArn" type:"string"`

	// A list of files associated with the OTA update.
	OtaUpdateFiles []OTAUpdateFile `locationName:"otaUpdateFiles" min:"1" type:"list"`

	// The OTA update ID.
	OtaUpdateId *string `locationName:"otaUpdateId" min:"1" type:"string"`

	// The status of the OTA update.
	OtaUpdateStatus OTAUpdateStatus `locationName:"otaUpdateStatus" type:"string" enum:"true"`

	// Specifies whether the OTA update will continue to run (CONTINUOUS), or will
	// be complete after all those things specified as targets have completed the
	// OTA update (SNAPSHOT). If continuous, the OTA update may also be run on a
	// thing when a change is detected in a target. For example, an OTA update will
	// run on a thing when the thing is added to a target group, even after the
	// OTA update was completed by all things originally in the group.
	TargetSelection TargetSelection `locationName:"targetSelection" type:"string" enum:"true"`

	// The targets of the OTA update.
	Targets []string `locationName:"targets" min:"1" type:"list"`
}

// String returns the string representation
func (s OTAUpdateInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OTAUpdateInfo) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdditionalParameters) > 0 {
		v := s.AdditionalParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "additionalParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.AwsIotJobArn != nil {
		v := *s.AwsIotJobArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsIotJobArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsIotJobId != nil {
		v := *s.AwsIotJobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsIotJobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsJobExecutionsRolloutConfig != nil {
		v := s.AwsJobExecutionsRolloutConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "awsJobExecutionsRolloutConfig", v, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ErrorInfo != nil {
		v := s.ErrorInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "errorInfo", v, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastModifiedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.OtaUpdateArn != nil {
		v := *s.OtaUpdateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "otaUpdateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OtaUpdateFiles) > 0 {
		v := s.OtaUpdateFiles

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "otaUpdateFiles", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.OtaUpdateId != nil {
		v := *s.OtaUpdateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "otaUpdateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OtaUpdateStatus) > 0 {
		v := s.OtaUpdateStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "otaUpdateStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TargetSelection) > 0 {
		v := s.TargetSelection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetSelection", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Targets) > 0 {
		v := s.Targets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "targets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An OTA update summary.
type OTAUpdateSummary struct {
	_ struct{} `type:"structure"`

	// The date when the OTA update was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The OTA update ARN.
	OtaUpdateArn *string `locationName:"otaUpdateArn" type:"string"`

	// The OTA update ID.
	OtaUpdateId *string `locationName:"otaUpdateId" min:"1" type:"string"`
}

// String returns the string representation
func (s OTAUpdateSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OTAUpdateSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.OtaUpdateArn != nil {
		v := *s.OtaUpdateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "otaUpdateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OtaUpdateId != nil {
		v := *s.OtaUpdateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "otaUpdateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A certificate that has been transferred but not yet accepted.
type OutgoingCertificate struct {
	_ struct{} `type:"structure"`

	// The certificate ARN.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The certificate ID.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate creation date.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The date the transfer was initiated.
	TransferDate *time.Time `locationName:"transferDate" type:"timestamp" timestampFormat:"unix"`

	// The transfer message.
	TransferMessage *string `locationName:"transferMessage" type:"string"`

	// The AWS account to which the transfer was made.
	TransferredTo *string `locationName:"transferredTo" min:"12" type:"string"`
}

// String returns the string representation
func (s OutgoingCertificate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutgoingCertificate) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateId != nil {
		v := *s.CertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.TransferDate != nil {
		v := *s.TransferDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "transferDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.TransferMessage != nil {
		v := *s.TransferMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "transferMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TransferredTo != nil {
		v := *s.TransferredTo

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "transferredTo", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an AWS IoT policy.
type Policy struct {
	_ struct{} `type:"structure"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Policy) MarshalFields(e protocol.FieldEncoder) error {
	if s.PolicyArn != nil {
		v := *s.PolicyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyName != nil {
		v := *s.PolicyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a policy version.
type PolicyVersion struct {
	_ struct{} `type:"structure"`

	// The date and time the policy was created.
	CreateDate *time.Time `locationName:"createDate" type:"timestamp" timestampFormat:"unix"`

	// Specifies whether the policy version is the default.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The policy version ID.
	VersionId *string `locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PolicyVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PolicyVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreateDate != nil {
		v := *s.CreateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.IsDefaultVersion != nil {
		v := *s.IsDefaultVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isDefaultVersion", protocol.BoolValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "versionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the version of the policy associated with the resource.
type PolicyVersionIdentifier struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`

	// The ID of the version of the policy associated with the resource.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s PolicyVersionIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyVersionIdentifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PolicyVersionIdentifier"}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PolicyVersionIdentifier) MarshalFields(e protocol.FieldEncoder) error {
	if s.PolicyName != nil {
		v := *s.PolicyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyVersionId != nil {
		v := *s.PolicyVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policyVersionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Configuration for pre-signed S3 URLs.
type PresignedUrlConfig struct {
	_ struct{} `type:"structure"`

	// How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600,
	// the default value is 3600 seconds. Pre-signed URLs are generated when Jobs
	// receives an MQTT request for the job document.
	ExpiresInSec *int64 `locationName:"expiresInSec" min:"60" type:"long"`

	// The ARN of an IAM role that grants grants permission to download files from
	// the S3 bucket where the job data/updates are stored. The role must also grant
	// permission for IoT to download the files.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation
func (s PresignedUrlConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PresignedUrlConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PresignedUrlConfig"}
	if s.ExpiresInSec != nil && *s.ExpiresInSec < 60 {
		invalidParams.Add(aws.NewErrParamMinValue("ExpiresInSec", 60))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PresignedUrlConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExpiresInSec != nil {
		v := *s.ExpiresInSec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expiresInSec", protocol.Int64Value(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The input for the DynamoActionVS action that specifies the DynamoDB table
// to which the message data will be written.
type PutItemInput struct {
	_ struct{} `type:"structure"`

	// The table where the message data will be written
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" type:"string" required:"true"`
}

// String returns the string representation
func (s PutItemInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutItemInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutItemInput"}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutItemInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.TableName != nil {
		v := *s.TableName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "tableName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Allows you to define a criteria to initiate the increase in rate of rollout
// for a job.
type RateIncreaseCriteria struct {
	_ struct{} `type:"structure"`

	// The threshold for number of notified things that will initiate the increase
	// in rate of rollout.
	NumberOfNotifiedThings *int64 `locationName:"numberOfNotifiedThings" min:"1" type:"integer"`

	// The threshold for number of succeeded things that will initiate the increase
	// in rate of rollout.
	NumberOfSucceededThings *int64 `locationName:"numberOfSucceededThings" min:"1" type:"integer"`
}

// String returns the string representation
func (s RateIncreaseCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RateIncreaseCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RateIncreaseCriteria"}
	if s.NumberOfNotifiedThings != nil && *s.NumberOfNotifiedThings < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("NumberOfNotifiedThings", 1))
	}
	if s.NumberOfSucceededThings != nil && *s.NumberOfSucceededThings < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("NumberOfSucceededThings", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RateIncreaseCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.NumberOfNotifiedThings != nil {
		v := *s.NumberOfNotifiedThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfNotifiedThings", protocol.Int64Value(v), metadata)
	}
	if s.NumberOfSucceededThings != nil {
		v := *s.NumberOfSucceededThings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfSucceededThings", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The registration configuration.
type RegistrationConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of the role.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The template body.
	TemplateBody *string `locationName:"templateBody" type:"string"`
}

// String returns the string representation
func (s RegistrationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegistrationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegistrationConfig"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RegistrationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateBody != nil {
		v := *s.TemplateBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a related resource.
type RelatedResource struct {
	_ struct{} `type:"structure"`

	// Additional information about the resource.
	AdditionalInfo map[string]string `locationName:"additionalInfo" type:"map"`

	// Information identifying the resource.
	ResourceIdentifier *ResourceIdentifier `locationName:"resourceIdentifier" type:"structure"`

	// The type of resource.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s RelatedResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RelatedResource) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdditionalInfo) > 0 {
		v := s.AdditionalInfo

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "additionalInfo", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ResourceIdentifier != nil {
		v := s.ResourceIdentifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resourceIdentifier", v, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes an action to republish to another topic.
type RepublishAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that grants access.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the MQTT topic.
	//
	// Topic is a required field
	Topic *string `locationName:"topic" type:"string" required:"true"`
}

// String returns the string representation
func (s RepublishAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepublishAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RepublishAction"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.Topic == nil {
		invalidParams.Add(aws.NewErrParamRequired("Topic"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RepublishAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Topic != nil {
		v := *s.Topic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "topic", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information identifying the non-compliant resource.
type ResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The account with which the resource is associated.
	Account *string `locationName:"account" min:"12" type:"string"`

	// The ID of the CA certificate used to authorize the certificate.
	CaCertificateId *string `locationName:"caCertificateId" min:"64" type:"string"`

	// The client ID.
	ClientId *string `locationName:"clientId" type:"string"`

	// The ID of the Cognito Identity Pool.
	CognitoIdentityPoolId *string `locationName:"cognitoIdentityPoolId" type:"string"`

	// The ID of the certificate attached to the resource.
	DeviceCertificateId *string `locationName:"deviceCertificateId" min:"64" type:"string"`

	// The version of the policy associated with the resource.
	PolicyVersionIdentifier *PolicyVersionIdentifier `locationName:"policyVersionIdentifier" type:"structure"`
}

// String returns the string representation
func (s ResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceIdentifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceIdentifier"}
	if s.Account != nil && len(*s.Account) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("Account", 12))
	}
	if s.CaCertificateId != nil && len(*s.CaCertificateId) < 64 {
		invalidParams.Add(aws.NewErrParamMinLen("CaCertificateId", 64))
	}
	if s.DeviceCertificateId != nil && len(*s.DeviceCertificateId) < 64 {
		invalidParams.Add(aws.NewErrParamMinLen("DeviceCertificateId", 64))
	}
	if s.PolicyVersionIdentifier != nil {
		if err := s.PolicyVersionIdentifier.Validate(); err != nil {
			invalidParams.AddNested("PolicyVersionIdentifier", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceIdentifier) MarshalFields(e protocol.FieldEncoder) error {
	if s.Account != nil {
		v := *s.Account

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "account", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CaCertificateId != nil {
		v := *s.CaCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "caCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientId != nil {
		v := *s.ClientId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CognitoIdentityPoolId != nil {
		v := *s.CognitoIdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cognitoIdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceCertificateId != nil {
		v := *s.DeviceCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deviceCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyVersionIdentifier != nil {
		v := s.PolicyVersionIdentifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "policyVersionIdentifier", v, metadata)
	}
	return nil
}

// Role alias description.
type RoleAliasDescription struct {
	_ struct{} `type:"structure"`

	// The UNIX timestamp of when the role alias was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The number of seconds for which the credential is valid.
	CredentialDurationSeconds *int64 `locationName:"credentialDurationSeconds" min:"900" type:"integer"`

	// The UNIX timestamp of when the role alias was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// The role alias owner.
	Owner *string `locationName:"owner" min:"12" type:"string"`

	// The role alias.
	RoleAlias *string `locationName:"roleAlias" min:"1" type:"string"`

	// The ARN of the role alias.
	RoleAliasArn *string `locationName:"roleAliasArn" type:"string"`

	// The role ARN.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation
func (s RoleAliasDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RoleAliasDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CredentialDurationSeconds != nil {
		v := *s.CredentialDurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "credentialDurationSeconds", protocol.Int64Value(v), metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastModifiedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleAlias != nil {
		v := *s.RoleAlias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleAlias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleAliasArn != nil {
		v := *s.RoleAliasArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleAliasArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an action to write data to an Amazon S3 bucket.
type S3Action struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// The Amazon S3 canned ACL that controls access to the object identified by
	// the object key. For more information, see S3 canned ACLs (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl).
	CannedAcl CannedAccessControlList `locationName:"cannedAcl" type:"string" enum:"true"`

	// The object key.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`

	// The ARN of the IAM role that grants access.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Action) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Action) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Action"}

	if s.BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketName"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Action) MarshalFields(e protocol.FieldEncoder) error {
	if s.BucketName != nil {
		v := *s.BucketName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucketName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CannedAcl) > 0 {
		v := s.CannedAcl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cannedAcl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the location of updated firmware in S3.
type S3Destination struct {
	_ struct{} `type:"structure"`

	// The S3 bucket that contains the updated firmware.
	Bucket *string `locationName:"bucket" min:"1" type:"string"`

	// The S3 prefix.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Destination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Destination"}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Destination) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The S3 location.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The S3 bucket.
	Bucket *string `locationName:"bucket" min:"1" type:"string"`

	// The S3 key.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The S3 bucket version.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Location"}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Location) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an action to write a message to a Salesforce IoT Cloud Input Stream.
type SalesforceAction struct {
	_ struct{} `type:"structure"`

	// The token used to authenticate access to the Salesforce IoT Cloud Input Stream.
	// The token is available from the Salesforce IoT Cloud platform after creation
	// of the Input Stream.
	//
	// Token is a required field
	Token *string `locationName:"token" min:"40" type:"string" required:"true"`

	// The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available
	// from the Salesforce IoT Cloud platform after creation of the Input Stream.
	//
	// Url is a required field
	Url *string `locationName:"url" type:"string" required:"true"`
}

// String returns the string representation
func (s SalesforceAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SalesforceAction"}

	if s.Token == nil {
		invalidParams.Add(aws.NewErrParamRequired("Token"))
	}
	if s.Token != nil && len(*s.Token) < 40 {
		invalidParams.Add(aws.NewErrParamMinLen("Token", 40))
	}

	if s.Url == nil {
		invalidParams.Add(aws.NewErrParamRequired("Url"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SalesforceAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Token != nil {
		v := *s.Token

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the scheduled audit.
type ScheduledAuditMetadata struct {
	_ struct{} `type:"structure"`

	// The day of the month on which the scheduled audit is run (if the frequency
	// is "MONTHLY"). If days 29-31 are specified, and the month does not have that
	// many days, the audit takes place on the "LAST" day of the month.
	DayOfMonth *string `locationName:"dayOfMonth" type:"string"`

	// The day of the week on which the scheduled audit is run (if the frequency
	// is "WEEKLY" or "BIWEEKLY").
	DayOfWeek DayOfWeek `locationName:"dayOfWeek" type:"string" enum:"true"`

	// How often the scheduled audit takes place.
	Frequency AuditFrequency `locationName:"frequency" type:"string" enum:"true"`

	// The ARN of the scheduled audit.
	ScheduledAuditArn *string `locationName:"scheduledAuditArn" type:"string"`

	// The name of the scheduled audit.
	ScheduledAuditName *string `locationName:"scheduledAuditName" min:"1" type:"string"`
}

// String returns the string representation
func (s ScheduledAuditMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ScheduledAuditMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.DayOfMonth != nil {
		v := *s.DayOfMonth

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dayOfMonth", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DayOfWeek) > 0 {
		v := s.DayOfWeek

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dayOfWeek", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Frequency) > 0 {
		v := s.Frequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "frequency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ScheduledAuditArn != nil {
		v := *s.ScheduledAuditArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scheduledAuditArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScheduledAuditName != nil {
		v := *s.ScheduledAuditName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scheduledAuditName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Identifying information for a Device Defender security profile.
type SecurityProfileIdentifier struct {
	_ struct{} `type:"structure"`

	// The ARN of the security profile.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name you have given to the security profile.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SecurityProfileIdentifier) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SecurityProfileIdentifier) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A target to which an alert is sent when a security profile behavior is violated.
type SecurityProfileTarget struct {
	_ struct{} `type:"structure"`

	// The ARN of the security profile.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation
func (s SecurityProfileTarget) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SecurityProfileTarget) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a security profile and the target associated with it.
type SecurityProfileTargetMapping struct {
	_ struct{} `type:"structure"`

	// Information that identifies the security profile.
	SecurityProfileIdentifier *SecurityProfileIdentifier `locationName:"securityProfileIdentifier" type:"structure"`

	// Information about the target (thing group) associated with the security profile.
	Target *SecurityProfileTarget `locationName:"target" type:"structure"`
}

// String returns the string representation
func (s SecurityProfileTargetMapping) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SecurityProfileTargetMapping) MarshalFields(e protocol.FieldEncoder) error {
	if s.SecurityProfileIdentifier != nil {
		v := s.SecurityProfileIdentifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "securityProfileIdentifier", v, metadata)
	}
	if s.Target != nil {
		v := s.Target

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "target", v, metadata)
	}
	return nil
}

// Describes the code-signing profile.
type SigningProfileParameter struct {
	_ struct{} `type:"structure"`

	// Certificate ARN.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The location of the code-signing certificate on your device.
	CertificatePathOnDevice *string `locationName:"certificatePathOnDevice" type:"string"`

	// The hardware platform of your device.
	Platform *string `locationName:"platform" type:"string"`
}

// String returns the string representation
func (s SigningProfileParameter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SigningProfileParameter) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificatePathOnDevice != nil {
		v := *s.CertificatePathOnDevice

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificatePathOnDevice", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an action to publish to an Amazon SNS topic.
type SnsAction struct {
	_ struct{} `type:"structure"`

	// (Optional) The message format of the message to publish. Accepted values
	// are "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses
	// this setting to determine if the payload should be parsed and relevant platform-specific
	// bits of the payload should be extracted. To read more about SNS message formats,
	// see https://docs.aws.amazon.com/sns/latest/dg/json-formats.html (https://docs.aws.amazon.com/sns/latest/dg/json-formats.html)
	// refer to their official documentation.
	MessageFormat MessageFormat `locationName:"messageFormat" type:"string" enum:"true"`

	// The ARN of the IAM role that grants access.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN of the SNS topic.
	//
	// TargetArn is a required field
	TargetArn *string `locationName:"targetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s SnsAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnsAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SnsAction"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.TargetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SnsAction) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.MessageFormat) > 0 {
		v := s.MessageFormat

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "messageFormat", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TargetArn != nil {
		v := *s.TargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an action to publish data to an Amazon SQS queue.
type SqsAction struct {
	_ struct{} `type:"structure"`

	// The URL of the Amazon SQS queue.
	//
	// QueueUrl is a required field
	QueueUrl *string `locationName:"queueUrl" type:"string" required:"true"`

	// The ARN of the IAM role that grants access.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Specifies whether to use Base64 encoding.
	UseBase64 *bool `locationName:"useBase64" type:"boolean"`
}

// String returns the string representation
func (s SqsAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqsAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SqsAction"}

	if s.QueueUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueueUrl"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SqsAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.QueueUrl != nil {
		v := *s.QueueUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queueUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UseBase64 != nil {
		v := *s.UseBase64

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "useBase64", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Information required to start a signing job.
type StartSigningJobParameter struct {
	_ struct{} `type:"structure"`

	// The location to write the code-signed file.
	Destination *Destination `locationName:"destination" type:"structure"`

	// The code-signing profile name.
	SigningProfileName *string `locationName:"signingProfileName" type:"string"`

	// Describes the code-signing profile.
	SigningProfileParameter *SigningProfileParameter `locationName:"signingProfileParameter" type:"structure"`
}

// String returns the string representation
func (s StartSigningJobParameter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSigningJobParameter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartSigningJobParameter"}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartSigningJobParameter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destination", v, metadata)
	}
	if s.SigningProfileName != nil {
		v := *s.SigningProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "signingProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SigningProfileParameter != nil {
		v := s.SigningProfileParameter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "signingProfileParameter", v, metadata)
	}
	return nil
}

// A statistical ranking (percentile) which indicates a threshold value by which
// a behavior is determined to be in compliance or in violation of the behavior.
type StatisticalThreshold struct {
	_ struct{} `type:"structure"`

	// The percentile which resolves to a threshold value by which compliance with
	// a behavior is determined. Metrics are collected over the specified period
	// (durationSeconds) from all reporting devices in your account and statistical
	// ranks are calculated. Then, the measurements from a device are collected
	// over the same period. If the accumulated measurements from the device fall
	// above or below (comparisonOperator) the value associated with the percentile
	// specified, then the device is considered to be in compliance with the behavior,
	// otherwise a violation occurs.
	Statistic *string `locationName:"statistic" type:"string"`
}

// String returns the string representation
func (s StatisticalThreshold) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StatisticalThreshold) MarshalFields(e protocol.FieldEncoder) error {
	if s.Statistic != nil {
		v := *s.Statistic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statistic", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A map of key-value pairs for all supported statistics. Currently, only count
// is supported.
type Statistics struct {
	_ struct{} `type:"structure"`

	// The count of things that match the query.
	Count *int64 `locationName:"count" type:"integer"`
}

// String returns the string representation
func (s Statistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Statistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Starts execution of a Step Functions state machine.
type StepFunctionsAction struct {
	_ struct{} `type:"structure"`

	// (Optional) A name will be given to the state machine execution consisting
	// of this prefix followed by a UUID. Step Functions automatically creates a
	// unique name for each state machine execution if one is not provided.
	ExecutionNamePrefix *string `locationName:"executionNamePrefix" type:"string"`

	// The ARN of the role that grants IoT permission to start execution of a state
	// machine ("Action":"states:StartExecution").
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the Step Functions state machine whose execution will be started.
	//
	// StateMachineName is a required field
	StateMachineName *string `locationName:"stateMachineName" type:"string" required:"true"`
}

// String returns the string representation
func (s StepFunctionsAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepFunctionsAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StepFunctionsAction"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.StateMachineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StateMachineName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StepFunctionsAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExecutionNamePrefix != nil {
		v := *s.ExecutionNamePrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "executionNamePrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StateMachineName != nil {
		v := *s.StateMachineName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stateMachineName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a group of files that can be streamed.
type Stream struct {
	_ struct{} `type:"structure"`

	// The ID of a file associated with a stream.
	FileId *int64 `locationName:"fileId" type:"integer"`

	// The stream ID.
	StreamId *string `locationName:"streamId" min:"1" type:"string"`
}

// String returns the string representation
func (s Stream) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Stream) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Stream"}
	if s.StreamId != nil && len(*s.StreamId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Stream) MarshalFields(e protocol.FieldEncoder) error {
	if s.FileId != nil {
		v := *s.FileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fileId", protocol.Int64Value(v), metadata)
	}
	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a file to stream.
type StreamFile struct {
	_ struct{} `type:"structure"`

	// The file ID.
	FileId *int64 `locationName:"fileId" type:"integer"`

	// The location of the file in S3.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`
}

// String returns the string representation
func (s StreamFile) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamFile) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StreamFile"}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamFile) MarshalFields(e protocol.FieldEncoder) error {
	if s.FileId != nil {
		v := *s.FileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fileId", protocol.Int64Value(v), metadata)
	}
	if s.S3Location != nil {
		v := s.S3Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3Location", v, metadata)
	}
	return nil
}

// Information about a stream.
type StreamInfo struct {
	_ struct{} `type:"structure"`

	// The date when the stream was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The description of the stream.
	Description *string `locationName:"description" type:"string"`

	// The files to stream.
	Files []StreamFile `locationName:"files" min:"1" type:"list"`

	// The date when the stream was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// An IAM role AWS IoT assumes to access your S3 files.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`

	// The stream ARN.
	StreamArn *string `locationName:"streamArn" type:"string"`

	// The stream ID.
	StreamId *string `locationName:"streamId" min:"1" type:"string"`

	// The stream version.
	StreamVersion *int64 `locationName:"streamVersion" type:"integer"`
}

// String returns the string representation
func (s StreamInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Files) > 0 {
		v := s.Files

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "files", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamArn != nil {
		v := *s.StreamArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamVersion != nil {
		v := *s.StreamVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A summary of a stream.
type StreamSummary struct {
	_ struct{} `type:"structure"`

	// A description of the stream.
	Description *string `locationName:"description" type:"string"`

	// The stream ARN.
	StreamArn *string `locationName:"streamArn" type:"string"`

	// The stream ID.
	StreamId *string `locationName:"streamId" min:"1" type:"string"`

	// The stream version.
	StreamVersion *int64 `locationName:"streamVersion" type:"integer"`
}

// String returns the string representation
func (s StreamSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamArn != nil {
		v := *s.StreamArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamVersion != nil {
		v := *s.StreamVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A set of key/value pairs that are used to manage the resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	Key *string `type:"string"`

	// The tag's value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Statistics for the checks performed during the audit.
type TaskStatistics struct {
	_ struct{} `type:"structure"`

	// The number of checks that did not run because the audit was canceled.
	CanceledChecks *int64 `locationName:"canceledChecks" type:"integer"`

	// The number of checks that found compliant resources.
	CompliantChecks *int64 `locationName:"compliantChecks" type:"integer"`

	// The number of checks
	FailedChecks *int64 `locationName:"failedChecks" type:"integer"`

	// The number of checks in progress.
	InProgressChecks *int64 `locationName:"inProgressChecks" type:"integer"`

	// The number of checks that found non-compliant resources.
	NonCompliantChecks *int64 `locationName:"nonCompliantChecks" type:"integer"`

	// The number of checks in this audit.
	TotalChecks *int64 `locationName:"totalChecks" type:"integer"`

	// The number of checks waiting for data collection.
	WaitingForDataCollectionChecks *int64 `locationName:"waitingForDataCollectionChecks" type:"integer"`
}

// String returns the string representation
func (s TaskStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TaskStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.CanceledChecks != nil {
		v := *s.CanceledChecks

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "canceledChecks", protocol.Int64Value(v), metadata)
	}
	if s.CompliantChecks != nil {
		v := *s.CompliantChecks

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "compliantChecks", protocol.Int64Value(v), metadata)
	}
	if s.FailedChecks != nil {
		v := *s.FailedChecks

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failedChecks", protocol.Int64Value(v), metadata)
	}
	if s.InProgressChecks != nil {
		v := *s.InProgressChecks

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inProgressChecks", protocol.Int64Value(v), metadata)
	}
	if s.NonCompliantChecks != nil {
		v := *s.NonCompliantChecks

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nonCompliantChecks", protocol.Int64Value(v), metadata)
	}
	if s.TotalChecks != nil {
		v := *s.TotalChecks

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "totalChecks", protocol.Int64Value(v), metadata)
	}
	if s.WaitingForDataCollectionChecks != nil {
		v := *s.WaitingForDataCollectionChecks

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "waitingForDataCollectionChecks", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The properties of the thing, including thing name, thing type name, and a
// list of thing attributes.
type ThingAttribute struct {
	_ struct{} `type:"structure"`

	// A list of thing attributes which are name-value pairs.
	Attributes map[string]string `locationName:"attributes" type:"map"`

	// The thing ARN.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The name of the thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`

	// The name of the thing type, if the thing has been associated with a type.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`

	// The version of the thing record in the registry.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s ThingAttribute) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingAttribute) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ThingArn != nil {
		v := *s.ThingArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingTypeName != nil {
		v := *s.ThingTypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingTypeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The connectivity status of the thing.
type ThingConnectivity struct {
	_ struct{} `type:"structure"`

	// True if the thing is connected to the AWS IoT service; false if it is not
	// connected.
	Connected *bool `locationName:"connected" type:"boolean"`

	// The epoch time (in milliseconds) when the thing last connected or disconnected.
	// If the thing has been disconnected for more than a few weeks, the time value
	// might be missing.
	Timestamp *int64 `locationName:"timestamp" type:"long"`
}

// String returns the string representation
func (s ThingConnectivity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingConnectivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Connected != nil {
		v := *s.Connected

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connected", protocol.BoolValue(v), metadata)
	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timestamp", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The thing search index document.
type ThingDocument struct {
	_ struct{} `type:"structure"`

	// The attributes.
	Attributes map[string]string `locationName:"attributes" type:"map"`

	// Indicates whether the thing is connected to the AWS IoT service.
	Connectivity *ThingConnectivity `locationName:"connectivity" type:"structure"`

	// The shadow.
	Shadow *string `locationName:"shadow" type:"string"`

	// Thing group names.
	ThingGroupNames []string `locationName:"thingGroupNames" type:"list"`

	// The thing ID.
	ThingId *string `locationName:"thingId" type:"string"`

	// The thing name.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`

	// The thing type name.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s ThingDocument) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingDocument) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Connectivity != nil {
		v := s.Connectivity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "connectivity", v, metadata)
	}
	if s.Shadow != nil {
		v := *s.Shadow

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shadow", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ThingGroupNames) > 0 {
		v := s.ThingGroupNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "thingGroupNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ThingId != nil {
		v := *s.ThingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingTypeName != nil {
		v := *s.ThingTypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingTypeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The thing group search index document.
type ThingGroupDocument struct {
	_ struct{} `type:"structure"`

	// The thing group attributes.
	Attributes map[string]string `locationName:"attributes" type:"map"`

	// Parent group names.
	ParentGroupNames []string `locationName:"parentGroupNames" type:"list"`

	// The thing group description.
	ThingGroupDescription *string `locationName:"thingGroupDescription" type:"string"`

	// The thing group ID.
	ThingGroupId *string `locationName:"thingGroupId" min:"1" type:"string"`

	// The thing group name.
	ThingGroupName *string `locationName:"thingGroupName" min:"1" type:"string"`
}

// String returns the string representation
func (s ThingGroupDocument) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingGroupDocument) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.ParentGroupNames) > 0 {
		v := s.ParentGroupNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "parentGroupNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ThingGroupDescription != nil {
		v := *s.ThingGroupDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingGroupDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingGroupId != nil {
		v := *s.ThingGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingGroupName != nil {
		v := *s.ThingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Thing group indexing configuration.
type ThingGroupIndexingConfiguration struct {
	_ struct{} `type:"structure"`

	// Thing group indexing mode.
	//
	// ThingGroupIndexingMode is a required field
	ThingGroupIndexingMode ThingGroupIndexingMode `locationName:"thingGroupIndexingMode" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ThingGroupIndexingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ThingGroupIndexingConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ThingGroupIndexingConfiguration"}
	if len(s.ThingGroupIndexingMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ThingGroupIndexingMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingGroupIndexingConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ThingGroupIndexingMode) > 0 {
		v := s.ThingGroupIndexingMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingGroupIndexingMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Thing group metadata.
type ThingGroupMetadata struct {
	_ struct{} `type:"structure"`

	// The UNIX timestamp of when the thing group was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The parent thing group name.
	ParentGroupName *string `locationName:"parentGroupName" min:"1" type:"string"`

	// The root parent thing group.
	RootToParentThingGroups []GroupNameAndArn `locationName:"rootToParentThingGroups" type:"list"`
}

// String returns the string representation
func (s ThingGroupMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingGroupMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.ParentGroupName != nil {
		v := *s.ParentGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "parentGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RootToParentThingGroups) > 0 {
		v := s.RootToParentThingGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "rootToParentThingGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Thing group properties.
type ThingGroupProperties struct {
	_ struct{} `type:"structure"`

	// The thing group attributes in JSON format.
	AttributePayload *AttributePayload `locationName:"attributePayload" type:"structure"`

	// The thing group description.
	ThingGroupDescription *string `locationName:"thingGroupDescription" type:"string"`
}

// String returns the string representation
func (s ThingGroupProperties) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingGroupProperties) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributePayload != nil {
		v := s.AttributePayload

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "attributePayload", v, metadata)
	}
	if s.ThingGroupDescription != nil {
		v := *s.ThingGroupDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingGroupDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The thing indexing configuration. For more information, see Managing Thing
// Indexing (https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html).
type ThingIndexingConfiguration struct {
	_ struct{} `type:"structure"`

	// Thing connectivity indexing mode. Valid values are:
	//
	//    * STATUS – Your thing index contains connectivity status. To enable
	//    thing connectivity indexing, thingIndexMode must not be set to OFF.
	//
	//    * OFF - Thing connectivity status indexing is disabled.
	ThingConnectivityIndexingMode ThingConnectivityIndexingMode `locationName:"thingConnectivityIndexingMode" type:"string" enum:"true"`

	// Thing indexing mode. Valid values are:
	//
	//    * REGISTRY – Your thing index contains registry data only.
	//
	//    * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow
	//    data.
	//
	//    * OFF - Thing indexing is disabled.
	//
	// ThingIndexingMode is a required field
	ThingIndexingMode ThingIndexingMode `locationName:"thingIndexingMode" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ThingIndexingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ThingIndexingConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ThingIndexingConfiguration"}
	if len(s.ThingIndexingMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ThingIndexingMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingIndexingConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ThingConnectivityIndexingMode) > 0 {
		v := s.ThingConnectivityIndexingMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingConnectivityIndexingMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ThingIndexingMode) > 0 {
		v := s.ThingIndexingMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingIndexingMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The definition of the thing type, including thing type name and description.
type ThingTypeDefinition struct {
	_ struct{} `type:"structure"`

	// The thing type ARN.
	ThingTypeArn *string `locationName:"thingTypeArn" type:"string"`

	// The ThingTypeMetadata contains additional information about the thing type
	// including: creation date and time, a value indicating whether the thing type
	// is deprecated, and a date and time when it was deprecated.
	ThingTypeMetadata *ThingTypeMetadata `locationName:"thingTypeMetadata" type:"structure"`

	// The name of the thing type.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`

	// The ThingTypeProperties for the thing type.
	ThingTypeProperties *ThingTypeProperties `locationName:"thingTypeProperties" type:"structure"`
}

// String returns the string representation
func (s ThingTypeDefinition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingTypeDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.ThingTypeArn != nil {
		v := *s.ThingTypeArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingTypeArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingTypeMetadata != nil {
		v := s.ThingTypeMetadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "thingTypeMetadata", v, metadata)
	}
	if s.ThingTypeName != nil {
		v := *s.ThingTypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingTypeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingTypeProperties != nil {
		v := s.ThingTypeProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "thingTypeProperties", v, metadata)
	}
	return nil
}

// The ThingTypeMetadata contains additional information about the thing type
// including: creation date and time, a value indicating whether the thing type
// is deprecated, and a date and time when time was deprecated.
type ThingTypeMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time when the thing type was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// Whether the thing type is deprecated. If true, no new things could be associated
	// with this type.
	Deprecated *bool `locationName:"deprecated" type:"boolean"`

	// The date and time when the thing type was deprecated.
	DeprecationDate *time.Time `locationName:"deprecationDate" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ThingTypeMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingTypeMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Deprecated != nil {
		v := *s.Deprecated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deprecated", protocol.BoolValue(v), metadata)
	}
	if s.DeprecationDate != nil {
		v := *s.DeprecationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deprecationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// The ThingTypeProperties contains information about the thing type including:
// a thing type description, and a list of searchable thing attribute names.
type ThingTypeProperties struct {
	_ struct{} `type:"structure"`

	// A list of searchable thing attribute names.
	SearchableAttributes []string `locationName:"searchableAttributes" type:"list"`

	// The description of the thing type.
	ThingTypeDescription *string `locationName:"thingTypeDescription" type:"string"`
}

// String returns the string representation
func (s ThingTypeProperties) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThingTypeProperties) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.SearchableAttributes) > 0 {
		v := s.SearchableAttributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "searchableAttributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ThingTypeDescription != nil {
		v := *s.ThingTypeDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingTypeDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the amount of time each device has to finish its execution of the
// job. A timer is started when the job execution status is set to IN_PROGRESS.
// If the job execution status is not set to another terminal state before the
// timer expires, it will be automatically set to TIMED_OUT.
type TimeoutConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the amount of time, in minutes, this device has to finish execution
	// of this job. The timeout interval can be anywhere between 1 minute and 7
	// days (1 to 10080 minutes). The in progress timer can't be updated and will
	// apply to all job executions for the job. Whenever a job execution remains
	// in the IN_PROGRESS status for longer than this interval, the job execution
	// will fail and switch to the terminal TIMED_OUT status.
	InProgressTimeoutInMinutes *int64 `locationName:"inProgressTimeoutInMinutes" type:"long"`
}

// String returns the string representation
func (s TimeoutConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TimeoutConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.InProgressTimeoutInMinutes != nil {
		v := *s.InProgressTimeoutInMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inProgressTimeoutInMinutes", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Describes a rule.
type TopicRule struct {
	_ struct{} `type:"structure"`

	// The actions associated with the rule.
	Actions []Action `locationName:"actions" type:"list"`

	// The version of the SQL rules engine to use when evaluating the rule.
	AwsIotSqlVersion *string `locationName:"awsIotSqlVersion" type:"string"`

	// The date and time the rule was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The description of the rule.
	Description *string `locationName:"description" type:"string"`

	// The action to perform when an error occurs.
	ErrorAction *Action `locationName:"errorAction" type:"structure"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `locationName:"ruleDisabled" type:"boolean"`

	// The name of the rule.
	RuleName *string `locationName:"ruleName" min:"1" type:"string"`

	// The SQL statement used to query the topic. When using a SQL query with multiple
	// lines, be sure to escape the newline characters.
	Sql *string `locationName:"sql" type:"string"`
}

// String returns the string representation
func (s TopicRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TopicRule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Actions) > 0 {
		v := s.Actions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "actions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AwsIotSqlVersion != nil {
		v := *s.AwsIotSqlVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsIotSqlVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ErrorAction != nil {
		v := s.ErrorAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "errorAction", v, metadata)
	}
	if s.RuleDisabled != nil {
		v := *s.RuleDisabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ruleDisabled", protocol.BoolValue(v), metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ruleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sql != nil {
		v := *s.Sql

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sql", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a rule.
type TopicRuleListItem struct {
	_ struct{} `type:"structure"`

	// The date and time the rule was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The rule ARN.
	RuleArn *string `locationName:"ruleArn" type:"string"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `locationName:"ruleDisabled" type:"boolean"`

	// The name of the rule.
	RuleName *string `locationName:"ruleName" min:"1" type:"string"`

	// The pattern for the topic names that apply.
	TopicPattern *string `locationName:"topicPattern" type:"string"`
}

// String returns the string representation
func (s TopicRuleListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TopicRuleListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.RuleArn != nil {
		v := *s.RuleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ruleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RuleDisabled != nil {
		v := *s.RuleDisabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ruleDisabled", protocol.BoolValue(v), metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ruleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TopicPattern != nil {
		v := *s.TopicPattern

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "topicPattern", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a rule.
type TopicRulePayload struct {
	_ struct{} `type:"structure"`

	// The actions associated with the rule.
	//
	// Actions is a required field
	Actions []Action `locationName:"actions" type:"list" required:"true"`

	// The version of the SQL rules engine to use when evaluating the rule.
	AwsIotSqlVersion *string `locationName:"awsIotSqlVersion" type:"string"`

	// The description of the rule.
	Description *string `locationName:"description" type:"string"`

	// The action to take when an error occurs.
	ErrorAction *Action `locationName:"errorAction" type:"structure"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `locationName:"ruleDisabled" type:"boolean"`

	// The SQL statement used to query the topic. For more information, see AWS
	// IoT SQL Reference (https://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference)
	// in the AWS IoT Developer Guide.
	//
	// Sql is a required field
	Sql *string `locationName:"sql" type:"string" required:"true"`
}

// String returns the string representation
func (s TopicRulePayload) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicRulePayload) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TopicRulePayload"}

	if s.Actions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Actions"))
	}

	if s.Sql == nil {
		invalidParams.Add(aws.NewErrParamRequired("Sql"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ErrorAction != nil {
		if err := s.ErrorAction.Validate(); err != nil {
			invalidParams.AddNested("ErrorAction", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TopicRulePayload) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Actions) > 0 {
		v := s.Actions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "actions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AwsIotSqlVersion != nil {
		v := *s.AwsIotSqlVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "awsIotSqlVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ErrorAction != nil {
		v := s.ErrorAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "errorAction", v, metadata)
	}
	if s.RuleDisabled != nil {
		v := *s.RuleDisabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ruleDisabled", protocol.BoolValue(v), metadata)
	}
	if s.Sql != nil {
		v := *s.Sql

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sql", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Data used to transfer a certificate to an AWS account.
type TransferData struct {
	_ struct{} `type:"structure"`

	// The date the transfer was accepted.
	AcceptDate *time.Time `locationName:"acceptDate" type:"timestamp" timestampFormat:"unix"`

	// The date the transfer was rejected.
	RejectDate *time.Time `locationName:"rejectDate" type:"timestamp" timestampFormat:"unix"`

	// The reason why the transfer was rejected.
	RejectReason *string `locationName:"rejectReason" type:"string"`

	// The date the transfer took place.
	TransferDate *time.Time `locationName:"transferDate" type:"timestamp" timestampFormat:"unix"`

	// The transfer message.
	TransferMessage *string `locationName:"transferMessage" type:"string"`
}

// String returns the string representation
func (s TransferData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TransferData) MarshalFields(e protocol.FieldEncoder) error {
	if s.AcceptDate != nil {
		v := *s.AcceptDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "acceptDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.RejectDate != nil {
		v := *s.RejectDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rejectDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.RejectReason != nil {
		v := *s.RejectReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rejectReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TransferDate != nil {
		v := *s.TransferDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "transferDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.TransferMessage != nil {
		v := *s.TransferMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "transferMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about an error found in a behavior specification.
type ValidationError struct {
	_ struct{} `type:"structure"`

	// The description of an error found in the behaviors.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation
func (s ValidationError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ValidationError) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a Device Defender security profile behavior violation.
type ViolationEvent struct {
	_ struct{} `type:"structure"`

	// The behavior which was violated.
	Behavior *Behavior `locationName:"behavior" type:"structure"`

	// The value of the metric (the measurement).
	MetricValue *MetricValue `locationName:"metricValue" type:"structure"`

	// The name of the security profile whose behavior was violated.
	SecurityProfileName *string `locationName:"securityProfileName" min:"1" type:"string"`

	// The name of the thing responsible for the violation event.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`

	// The time the violation event occurred.
	ViolationEventTime *time.Time `locationName:"violationEventTime" type:"timestamp" timestampFormat:"unix"`

	// The type of violation event.
	ViolationEventType ViolationEventType `locationName:"violationEventType" type:"string" enum:"true"`

	// The ID of the violation event.
	ViolationId *string `locationName:"violationId" min:"1" type:"string"`
}

// String returns the string representation
func (s ViolationEvent) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ViolationEvent) MarshalFields(e protocol.FieldEncoder) error {
	if s.Behavior != nil {
		v := s.Behavior

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "behavior", v, metadata)
	}
	if s.MetricValue != nil {
		v := s.MetricValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metricValue", v, metadata)
	}
	if s.SecurityProfileName != nil {
		v := *s.SecurityProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "securityProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ViolationEventTime != nil {
		v := *s.ViolationEventTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "violationEventTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.ViolationEventType) > 0 {
		v := s.ViolationEventType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "violationEventType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ViolationId != nil {
		v := *s.ViolationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "violationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
