// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SubscribeToEventRequest
type SubscribeToEventInput struct {
	_ struct{} `type:"structure"`

	// The event for which you want to receive SNS notifications.
	//
	// Event is a required field
	Event InspectorEvent `locationName:"event" type:"string" required:"true" enum:"true"`

	// The ARN of the assessment template that is used during the event for which
	// you want to receive SNS notifications.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The ARN of the SNS topic to which the SNS notifications are sent.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"topicArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SubscribeToEventInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubscribeToEventInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SubscribeToEventInput"}
	if len(s.Event) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Event"))
	}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceArn", 1))
	}

	if s.TopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicArn"))
	}
	if s.TopicArn != nil && len(*s.TopicArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TopicArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SubscribeToEventOutput
type SubscribeToEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SubscribeToEventOutput) String() string {
	return awsutil.Prettify(s)
}

const opSubscribeToEvent = "SubscribeToEvent"

// SubscribeToEventRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Enables the process of sending Amazon Simple Notification Service (SNS) notifications
// about a specified event to a specified SNS topic.
//
//    // Example sending a request using SubscribeToEventRequest.
//    req := client.SubscribeToEventRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SubscribeToEvent
func (c *Client) SubscribeToEventRequest(input *SubscribeToEventInput) SubscribeToEventRequest {
	op := &aws.Operation{
		Name:       opSubscribeToEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubscribeToEventInput{}
	}

	req := c.newRequest(op, input, &SubscribeToEventOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return SubscribeToEventRequest{Request: req, Input: input, Copy: c.SubscribeToEventRequest}
}

// SubscribeToEventRequest is the request type for the
// SubscribeToEvent API operation.
type SubscribeToEventRequest struct {
	*aws.Request
	Input *SubscribeToEventInput
	Copy  func(*SubscribeToEventInput) SubscribeToEventRequest
}

// Send marshals and sends the SubscribeToEvent API request.
func (r SubscribeToEventRequest) Send(ctx context.Context) (*SubscribeToEventResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SubscribeToEventResponse{
		SubscribeToEventOutput: r.Request.Data.(*SubscribeToEventOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SubscribeToEventResponse is the response type for the
// SubscribeToEvent API operation.
type SubscribeToEventResponse struct {
	*SubscribeToEventOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SubscribeToEvent request.
func (r *SubscribeToEventResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
