// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplatesRequest
type ListAssessmentTemplatesInput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the assessment targets whose assessment templates
	// you want to list.
	AssessmentTargetArns []string `locationName:"assessmentTargetArns" type:"list"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AssessmentTemplateFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListAssessmentTemplates action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of NextToken from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentTemplatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAssessmentTemplatesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplatesResponse
type ListAssessmentTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the assessment templates returned by the action.
	//
	// AssessmentTemplateArns is a required field
	AssessmentTemplateArns []string `locationName:"assessmentTemplateArns" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAssessmentTemplates = "ListAssessmentTemplates"

// ListAssessmentTemplatesRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Lists the assessment templates that correspond to the assessment targets
// that are specified by the ARNs of the assessment targets.
//
//    // Example sending a request using ListAssessmentTemplatesRequest.
//    req := client.ListAssessmentTemplatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates
func (c *Client) ListAssessmentTemplatesRequest(input *ListAssessmentTemplatesInput) ListAssessmentTemplatesRequest {
	op := &aws.Operation{
		Name:       opListAssessmentTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentTemplatesInput{}
	}

	req := c.newRequest(op, input, &ListAssessmentTemplatesOutput{})
	return ListAssessmentTemplatesRequest{Request: req, Input: input, Copy: c.ListAssessmentTemplatesRequest}
}

// ListAssessmentTemplatesRequest is the request type for the
// ListAssessmentTemplates API operation.
type ListAssessmentTemplatesRequest struct {
	*aws.Request
	Input *ListAssessmentTemplatesInput
	Copy  func(*ListAssessmentTemplatesInput) ListAssessmentTemplatesRequest
}

// Send marshals and sends the ListAssessmentTemplates API request.
func (r ListAssessmentTemplatesRequest) Send(ctx context.Context) (*ListAssessmentTemplatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAssessmentTemplatesResponse{
		ListAssessmentTemplatesOutput: r.Request.Data.(*ListAssessmentTemplatesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAssessmentTemplatesRequestPaginator returns a paginator for ListAssessmentTemplates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAssessmentTemplatesRequest(input)
//   p := inspector.NewListAssessmentTemplatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAssessmentTemplatesPaginator(req ListAssessmentTemplatesRequest) ListAssessmentTemplatesPaginator {
	return ListAssessmentTemplatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAssessmentTemplatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAssessmentTemplatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAssessmentTemplatesPaginator struct {
	aws.Pager
}

func (p *ListAssessmentTemplatesPaginator) CurrentPage() *ListAssessmentTemplatesOutput {
	return p.Pager.CurrentPage().(*ListAssessmentTemplatesOutput)
}

// ListAssessmentTemplatesResponse is the response type for the
// ListAssessmentTemplates API operation.
type ListAssessmentTemplatesResponse struct {
	*ListAssessmentTemplatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAssessmentTemplates request.
func (r *ListAssessmentTemplatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
