// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeysRequest
type ListSSHPublicKeysInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, the number of items defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true, and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the IAM user to list SSH public keys for. If none is specified,
	// the UserName field is determined implicitly based on the AWS access key used
	// to sign the request.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSSHPublicKeysInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSSHPublicKeysInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSSHPublicKeysInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful ListSSHPublicKeys request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeysResponse
type ListSSHPublicKeysOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `type:"string"`

	// A list of the SSH public keys assigned to IAM user.
	SSHPublicKeys []SSHPublicKeyMetadata `type:"list"`
}

// String returns the string representation
func (s ListSSHPublicKeysOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSSHPublicKeys = "ListSSHPublicKeys"

// ListSSHPublicKeysRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Returns information about the SSH public keys associated with the specified
// IAM user. If none exists, the operation returns an empty list.
//
// The SSH public keys returned by this operation are used only for authenticating
// the IAM user to an AWS CodeCommit repository. For more information about
// using SSH keys to authenticate to an AWS CodeCommit repository, see Set up
// AWS CodeCommit for SSH Connections (https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
//
// Although each user is limited to a small number of keys, you can still paginate
// the results using the MaxItems and Marker parameters.
//
//    // Example sending a request using ListSSHPublicKeysRequest.
//    req := client.ListSSHPublicKeysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys
func (c *Client) ListSSHPublicKeysRequest(input *ListSSHPublicKeysInput) ListSSHPublicKeysRequest {
	op := &aws.Operation{
		Name:       opListSSHPublicKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListSSHPublicKeysInput{}
	}

	req := c.newRequest(op, input, &ListSSHPublicKeysOutput{})
	return ListSSHPublicKeysRequest{Request: req, Input: input, Copy: c.ListSSHPublicKeysRequest}
}

// ListSSHPublicKeysRequest is the request type for the
// ListSSHPublicKeys API operation.
type ListSSHPublicKeysRequest struct {
	*aws.Request
	Input *ListSSHPublicKeysInput
	Copy  func(*ListSSHPublicKeysInput) ListSSHPublicKeysRequest
}

// Send marshals and sends the ListSSHPublicKeys API request.
func (r ListSSHPublicKeysRequest) Send(ctx context.Context) (*ListSSHPublicKeysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSSHPublicKeysResponse{
		ListSSHPublicKeysOutput: r.Request.Data.(*ListSSHPublicKeysOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSSHPublicKeysRequestPaginator returns a paginator for ListSSHPublicKeys.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSSHPublicKeysRequest(input)
//   p := iam.NewListSSHPublicKeysRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSSHPublicKeysPaginator(req ListSSHPublicKeysRequest) ListSSHPublicKeysPaginator {
	return ListSSHPublicKeysPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSSHPublicKeysInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSSHPublicKeysPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSSHPublicKeysPaginator struct {
	aws.Pager
}

func (p *ListSSHPublicKeysPaginator) CurrentPage() *ListSSHPublicKeysOutput {
	return p.Pager.CurrentPage().(*ListSSHPublicKeysOutput)
}

// ListSSHPublicKeysResponse is the response type for the
// ListSSHPublicKeys API operation.
type ListSSHPublicKeysResponse struct {
	*ListSSHPublicKeysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSSHPublicKeys request.
func (r *ListSSHPublicKeysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
