// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package groundstation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetDataflowEndpointGroupRequest
type GetDataflowEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// UUID of a dataflow endpoint group.
	//
	// DataflowEndpointGroupId is a required field
	DataflowEndpointGroupId *string `location:"uri" locationName:"dataflowEndpointGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDataflowEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataflowEndpointGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDataflowEndpointGroupInput"}

	if s.DataflowEndpointGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataflowEndpointGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDataflowEndpointGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.DataflowEndpointGroupId != nil {
		v := *s.DataflowEndpointGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "dataflowEndpointGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetDataflowEndpointGroupResponse
type GetDataflowEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// ARN of a dataflow endpoint group.
	DataflowEndpointGroupArn *string `locationName:"dataflowEndpointGroupArn" type:"string"`

	// UUID of a dataflow endpoint group.
	DataflowEndpointGroupId *string `locationName:"dataflowEndpointGroupId" type:"string"`

	// Details of a dataflow endpoint.
	EndpointsDetails []EndpointDetails `locationName:"endpointsDetails" type:"list"`

	// Tags assigned to a dataflow endpoint group.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetDataflowEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDataflowEndpointGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataflowEndpointGroupArn != nil {
		v := *s.DataflowEndpointGroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowEndpointGroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataflowEndpointGroupId != nil {
		v := *s.DataflowEndpointGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataflowEndpointGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EndpointsDetails) > 0 {
		v := s.EndpointsDetails

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "endpointsDetails", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opGetDataflowEndpointGroup = "GetDataflowEndpointGroup"

// GetDataflowEndpointGroupRequest returns a request value for making API operation for
// AWS Ground Station.
//
// Returns the dataflow endpoint group.
//
//    // Example sending a request using GetDataflowEndpointGroupRequest.
//    req := client.GetDataflowEndpointGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetDataflowEndpointGroup
func (c *Client) GetDataflowEndpointGroupRequest(input *GetDataflowEndpointGroupInput) GetDataflowEndpointGroupRequest {
	op := &aws.Operation{
		Name:       opGetDataflowEndpointGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/dataflowEndpointGroup/{dataflowEndpointGroupId}",
	}

	if input == nil {
		input = &GetDataflowEndpointGroupInput{}
	}

	req := c.newRequest(op, input, &GetDataflowEndpointGroupOutput{})
	return GetDataflowEndpointGroupRequest{Request: req, Input: input, Copy: c.GetDataflowEndpointGroupRequest}
}

// GetDataflowEndpointGroupRequest is the request type for the
// GetDataflowEndpointGroup API operation.
type GetDataflowEndpointGroupRequest struct {
	*aws.Request
	Input *GetDataflowEndpointGroupInput
	Copy  func(*GetDataflowEndpointGroupInput) GetDataflowEndpointGroupRequest
}

// Send marshals and sends the GetDataflowEndpointGroup API request.
func (r GetDataflowEndpointGroupRequest) Send(ctx context.Context) (*GetDataflowEndpointGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDataflowEndpointGroupResponse{
		GetDataflowEndpointGroupOutput: r.Request.Data.(*GetDataflowEndpointGroupOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDataflowEndpointGroupResponse is the response type for the
// GetDataflowEndpointGroup API operation.
type GetDataflowEndpointGroupResponse struct {
	*GetDataflowEndpointGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDataflowEndpointGroup request.
func (r *GetDataflowEndpointGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
