// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package groundstation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteConfigRequest
type DeleteConfigInput struct {
	_ struct{} `type:"structure"`

	// UUID of a Config.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"configId" type:"string" required:"true"`

	// Type of a Config.
	//
	// ConfigType is a required field
	ConfigType ConfigCapabilityType `location:"uri" locationName:"configType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DeleteConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteConfigInput"}

	if s.ConfigId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigId"))
	}
	if len(s.ConfigType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ConfigType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteConfigInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ConfigId != nil {
		v := *s.ConfigId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "configId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ConfigType) > 0 {
		v := s.ConfigType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "configType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ConfigIdResponse
type DeleteConfigOutput struct {
	_ struct{} `type:"structure"`

	// ARN of a Config.
	ConfigArn *string `locationName:"configArn" type:"string"`

	// UUID of a Config.
	ConfigId *string `locationName:"configId" type:"string"`

	// Type of a Config.
	ConfigType ConfigCapabilityType `locationName:"configType" type:"string" enum:"true"`
}

// String returns the string representation
func (s DeleteConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfigArn != nil {
		v := *s.ConfigArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigId != nil {
		v := *s.ConfigId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ConfigType) > 0 {
		v := s.ConfigType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "configType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opDeleteConfig = "DeleteConfig"

// DeleteConfigRequest returns a request value for making API operation for
// AWS Ground Station.
//
// Deletes a Config.
//
//    // Example sending a request using DeleteConfigRequest.
//    req := client.DeleteConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteConfig
func (c *Client) DeleteConfigRequest(input *DeleteConfigInput) DeleteConfigRequest {
	op := &aws.Operation{
		Name:       opDeleteConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/config/{configType}/{configId}",
	}

	if input == nil {
		input = &DeleteConfigInput{}
	}

	req := c.newRequest(op, input, &DeleteConfigOutput{})
	return DeleteConfigRequest{Request: req, Input: input, Copy: c.DeleteConfigRequest}
}

// DeleteConfigRequest is the request type for the
// DeleteConfig API operation.
type DeleteConfigRequest struct {
	*aws.Request
	Input *DeleteConfigInput
	Copy  func(*DeleteConfigInput) DeleteConfigRequest
}

// Send marshals and sends the DeleteConfig API request.
func (r DeleteConfigRequest) Send(ctx context.Context) (*DeleteConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteConfigResponse{
		DeleteConfigOutput: r.Request.Data.(*DeleteConfigOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteConfigResponse is the response type for the
// DeleteConfig API operation.
type DeleteConfigResponse struct {
	*DeleteConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteConfig request.
func (r *DeleteConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
