// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccountRequest
type GetServiceRoleForAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetServiceRoleForAccountInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetServiceRoleForAccountInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccountResponse
type GetServiceRoleForAccountOutput struct {
	_ struct{} `type:"structure"`

	// The time when the service role was associated with the account.
	AssociatedAt *string `type:"string"`

	// The ARN of the role which is associated with the account.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s GetServiceRoleForAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetServiceRoleForAccountOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociatedAt != nil {
		v := *s.AssociatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetServiceRoleForAccount = "GetServiceRoleForAccount"

// GetServiceRoleForAccountRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Retrieves the service role that is attached to your account.
//
//    // Example sending a request using GetServiceRoleForAccountRequest.
//    req := client.GetServiceRoleForAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount
func (c *Client) GetServiceRoleForAccountRequest(input *GetServiceRoleForAccountInput) GetServiceRoleForAccountRequest {
	op := &aws.Operation{
		Name:       opGetServiceRoleForAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &GetServiceRoleForAccountInput{}
	}

	req := c.newRequest(op, input, &GetServiceRoleForAccountOutput{})
	return GetServiceRoleForAccountRequest{Request: req, Input: input, Copy: c.GetServiceRoleForAccountRequest}
}

// GetServiceRoleForAccountRequest is the request type for the
// GetServiceRoleForAccount API operation.
type GetServiceRoleForAccountRequest struct {
	*aws.Request
	Input *GetServiceRoleForAccountInput
	Copy  func(*GetServiceRoleForAccountInput) GetServiceRoleForAccountRequest
}

// Send marshals and sends the GetServiceRoleForAccount API request.
func (r GetServiceRoleForAccountRequest) Send(ctx context.Context) (*GetServiceRoleForAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetServiceRoleForAccountResponse{
		GetServiceRoleForAccountOutput: r.Request.Data.(*GetServiceRoleForAccountOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetServiceRoleForAccountResponse is the response type for the
// GetServiceRoleForAccount API operation.
type GetServiceRoleForAccountResponse struct {
	*GetServiceRoleForAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetServiceRoleForAccount request.
func (r *GetServiceRoleForAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
