// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceFleetInput
type ModifyInstanceFleetInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The unique identifier of the instance fleet.
	//
	// InstanceFleet is a required field
	InstanceFleet *InstanceFleetModifyConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s ModifyInstanceFleetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyInstanceFleetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyInstanceFleetInput"}

	if s.ClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterId"))
	}

	if s.InstanceFleet == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceFleet"))
	}
	if s.InstanceFleet != nil {
		if err := s.InstanceFleet.Validate(); err != nil {
			invalidParams.AddNested("InstanceFleet", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceFleetOutput
type ModifyInstanceFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyInstanceFleetOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyInstanceFleet = "ModifyInstanceFleet"

// ModifyInstanceFleetRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Modifies the target On-Demand and target Spot capacities for the instance
// fleet with the specified InstanceFleetID within the cluster specified using
// ClusterID. The call either succeeds or fails atomically.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
//
//    // Example sending a request using ModifyInstanceFleetRequest.
//    req := client.ModifyInstanceFleetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceFleet
func (c *Client) ModifyInstanceFleetRequest(input *ModifyInstanceFleetInput) ModifyInstanceFleetRequest {
	op := &aws.Operation{
		Name:       opModifyInstanceFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceFleetInput{}
	}

	req := c.newRequest(op, input, &ModifyInstanceFleetOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return ModifyInstanceFleetRequest{Request: req, Input: input, Copy: c.ModifyInstanceFleetRequest}
}

// ModifyInstanceFleetRequest is the request type for the
// ModifyInstanceFleet API operation.
type ModifyInstanceFleetRequest struct {
	*aws.Request
	Input *ModifyInstanceFleetInput
	Copy  func(*ModifyInstanceFleetInput) ModifyInstanceFleetRequest
}

// Send marshals and sends the ModifyInstanceFleet API request.
func (r ModifyInstanceFleetRequest) Send(ctx context.Context) (*ModifyInstanceFleetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyInstanceFleetResponse{
		ModifyInstanceFleetOutput: r.Request.Data.(*ModifyInstanceFleetOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyInstanceFleetResponse is the response type for the
// ModifyInstanceFleet API operation.
type ModifyInstanceFleetResponse struct {
	*ModifyInstanceFleetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyInstanceFleet request.
func (r *ModifyInstanceFleetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
