// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elastictranscoder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The UpdatePipelineStatusRequest structure.
type UpdatePipelineStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pipeline to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The desired status of the pipeline:
	//
	//    * Active: The pipeline is processing jobs.
	//
	//    * Paused: The pipeline is not currently processing jobs.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePipelineStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipelineStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdatePipelineStatusInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.Status == nil {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdatePipelineStatusInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// When you update status for a pipeline, Elastic Transcoder returns the values
// that you specified in the request.
type UpdatePipelineStatusOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the pipeline.
	Pipeline *Pipeline `type:"structure"`
}

// String returns the string representation
func (s UpdatePipelineStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdatePipelineStatusOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Pipeline != nil {
		v := s.Pipeline

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Pipeline", v, metadata)
	}
	return nil
}

const opUpdatePipelineStatus = "UpdatePipelineStatus"

// UpdatePipelineStatusRequest returns a request value for making API operation for
// Amazon Elastic Transcoder.
//
// The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that
// the pipeline stops or restarts the processing of jobs.
//
// Changing the pipeline status is useful if you want to cancel one or more
// jobs. You can't cancel jobs after Elastic Transcoder has started processing
// them; if you pause the pipeline to which you submitted the jobs, you have
// more time to get the job IDs for the jobs that you want to cancel, and to
// send a CancelJob request.
//
//    // Example sending a request using UpdatePipelineStatusRequest.
//    req := client.UpdatePipelineStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdatePipelineStatusRequest(input *UpdatePipelineStatusInput) UpdatePipelineStatusRequest {
	op := &aws.Operation{
		Name:       opUpdatePipelineStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/2012-09-25/pipelines/{Id}/status",
	}

	if input == nil {
		input = &UpdatePipelineStatusInput{}
	}

	req := c.newRequest(op, input, &UpdatePipelineStatusOutput{})
	return UpdatePipelineStatusRequest{Request: req, Input: input, Copy: c.UpdatePipelineStatusRequest}
}

// UpdatePipelineStatusRequest is the request type for the
// UpdatePipelineStatus API operation.
type UpdatePipelineStatusRequest struct {
	*aws.Request
	Input *UpdatePipelineStatusInput
	Copy  func(*UpdatePipelineStatusInput) UpdatePipelineStatusRequest
}

// Send marshals and sends the UpdatePipelineStatus API request.
func (r UpdatePipelineStatusRequest) Send(ctx context.Context) (*UpdatePipelineStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdatePipelineStatusResponse{
		UpdatePipelineStatusOutput: r.Request.Data.(*UpdatePipelineStatusOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdatePipelineStatusResponse is the response type for the
// UpdatePipelineStatus API operation.
type UpdatePipelineStatusResponse struct {
	*UpdatePipelineStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdatePipelineStatus request.
func (r *UpdatePipelineStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
