// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateLoadBalancerInput
type CreateLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// [Application Load Balancers] The type of IP addresses used by the subnets
	// for your load balancer. The possible values are ipv4 (for IPv4 addresses)
	// and dualstack (for IPv4 and IPv6 addresses). Internal load balancers must
	// use ipv4.
	IpAddressType IpAddressType `type:"string" enum:"true"`

	// The name of the load balancer.
	//
	// This name must be unique per region per account, can have a maximum of 32
	// characters, must contain only alphanumeric characters or hyphens, must not
	// begin or end with a hyphen, and must not begin with "internal-".
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The nodes of an Internet-facing load balancer have public IP addresses. The
	// DNS name of an Internet-facing load balancer is publicly resolvable to the
	// public IP addresses of the nodes. Therefore, Internet-facing load balancers
	// can route requests from clients over the internet.
	//
	// The nodes of an internal load balancer have only private IP addresses. The
	// DNS name of an internal load balancer is publicly resolvable to the private
	// IP addresses of the nodes. Therefore, internal load balancers can only route
	// requests from clients with access to the VPC for the load balancer.
	//
	// The default is an Internet-facing load balancer.
	Scheme LoadBalancerSchemeEnum `type:"string" enum:"true"`

	// [Application Load Balancers] The IDs of the security groups for the load
	// balancer.
	SecurityGroups []string `type:"list"`

	// The IDs of the public subnets. You can specify only one subnet per Availability
	// Zone. You must specify either subnets or subnet mappings.
	//
	// [Application Load Balancers] You must specify subnets from at least two Availability
	// Zones. You cannot specify Elastic IP addresses for your subnets.
	//
	// [Network Load Balancers] You can specify subnets from one or more Availability
	// Zones. You can specify one Elastic IP address per subnet.
	SubnetMappings []SubnetMapping `type:"list"`

	// The IDs of the public subnets. You can specify only one subnet per Availability
	// Zone. You must specify either subnets or subnet mappings.
	//
	// [Application Load Balancers] You must specify subnets from at least two Availability
	// Zones.
	//
	// [Network Load Balancers] You can specify subnets from one or more Availability
	// Zones.
	Subnets []string `type:"list"`

	// One or more tags to assign to the load balancer.
	Tags []Tag `min:"1" type:"list"`

	// The type of load balancer. The default is application.
	Type LoadBalancerTypeEnum `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoadBalancerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLoadBalancerInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateLoadBalancerOutput
type CreateLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// Information about the load balancer.
	LoadBalancers []LoadBalancer `type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateLoadBalancer = "CreateLoadBalancer"

// CreateLoadBalancerRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Creates an Application Load Balancer or a Network Load Balancer.
//
// When you create a load balancer, you can specify security groups, public
// subnets, IP address type, and tags. Otherwise, you could do so later using
// SetSecurityGroups, SetSubnets, SetIpAddressType, and AddTags.
//
// To create listeners for your load balancer, use CreateListener. To describe
// your current load balancers, see DescribeLoadBalancers. When you are finished
// with a load balancer, you can delete it using DeleteLoadBalancer.
//
// For limit information, see Limits for Your Application Load Balancer (https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html)
// in the Application Load Balancers Guide and Limits for Your Network Load
// Balancer (https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html)
// in the Network Load Balancers Guide.
//
// This operation is idempotent, which means that it completes at most one time.
// If you attempt to create multiple load balancers with the same settings,
// each call succeeds.
//
// For more information, see Application Load Balancers (https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html)
// in the Application Load Balancers Guide and Network Load Balancers (https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html)
// in the Network Load Balancers Guide.
//
//    // Example sending a request using CreateLoadBalancerRequest.
//    req := client.CreateLoadBalancerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateLoadBalancer
func (c *Client) CreateLoadBalancerRequest(input *CreateLoadBalancerInput) CreateLoadBalancerRequest {
	op := &aws.Operation{
		Name:       opCreateLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerInput{}
	}

	req := c.newRequest(op, input, &CreateLoadBalancerOutput{})
	return CreateLoadBalancerRequest{Request: req, Input: input, Copy: c.CreateLoadBalancerRequest}
}

// CreateLoadBalancerRequest is the request type for the
// CreateLoadBalancer API operation.
type CreateLoadBalancerRequest struct {
	*aws.Request
	Input *CreateLoadBalancerInput
	Copy  func(*CreateLoadBalancerInput) CreateLoadBalancerRequest
}

// Send marshals and sends the CreateLoadBalancer API request.
func (r CreateLoadBalancerRequest) Send(ctx context.Context) (*CreateLoadBalancerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateLoadBalancerResponse{
		CreateLoadBalancerOutput: r.Request.Data.(*CreateLoadBalancerOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateLoadBalancerResponse is the response type for the
// CreateLoadBalancer API operation.
type CreateLoadBalancerResponse struct {
	*CreateLoadBalancerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateLoadBalancer request.
func (r *CreateLoadBalancerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
