// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateTagsForResourceMessage
type UpdateTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resouce to be updated.
	//
	// Must be the ARN of an Elastic Beanstalk environment.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// A list of tags to add or update.
	//
	// If a key of an existing tag is added, the tag's value is updated.
	TagsToAdd []Tag `type:"list"`

	// A list of tag keys to remove.
	//
	// If a tag key doesn't exist, it is silently ignored.
	TagsToRemove []string `type:"list"`
}

// String returns the string representation
func (s UpdateTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTagsForResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateTagsForResourceInput"}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}
	if s.TagsToAdd != nil {
		for i, v := range s.TagsToAdd {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsToAdd", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateTagsForResourceOutput
type UpdateTagsForResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateTagsForResource = "UpdateTagsForResource"

// UpdateTagsForResourceRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Update the list of tags applied to an AWS Elastic Beanstalk resource. Two
// lists can be passed: TagsToAdd for tags to add or update, and TagsToRemove.
//
// Currently, Elastic Beanstalk only supports tagging of Elastic Beanstalk environments.
// For details about environment tagging, see Tagging Resources in Your Elastic
// Beanstalk Environment (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/using-features.tagging.html).
//
// If you create a custom IAM user policy to control permission to this operation,
// specify one of the following two virtual actions (or both) instead of the
// API operation name:
//
// elasticbeanstalk:AddTags
//
// Controls permission to call UpdateTagsForResource and pass a list of tags
// to add in the TagsToAdd parameter.
//
// elasticbeanstalk:RemoveTags
//
// Controls permission to call UpdateTagsForResource and pass a list of tag
// keys to remove in the TagsToRemove parameter.
//
// For details about creating a custom user policy, see Creating a Custom User
// Policy (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies).
//
//    // Example sending a request using UpdateTagsForResourceRequest.
//    req := client.UpdateTagsForResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateTagsForResource
func (c *Client) UpdateTagsForResourceRequest(input *UpdateTagsForResourceInput) UpdateTagsForResourceRequest {
	op := &aws.Operation{
		Name:       opUpdateTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTagsForResourceInput{}
	}

	req := c.newRequest(op, input, &UpdateTagsForResourceOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateTagsForResourceRequest{Request: req, Input: input, Copy: c.UpdateTagsForResourceRequest}
}

// UpdateTagsForResourceRequest is the request type for the
// UpdateTagsForResource API operation.
type UpdateTagsForResourceRequest struct {
	*aws.Request
	Input *UpdateTagsForResourceInput
	Copy  func(*UpdateTagsForResourceInput) UpdateTagsForResourceRequest
}

// Send marshals and sends the UpdateTagsForResource API request.
func (r UpdateTagsForResourceRequest) Send(ctx context.Context) (*UpdateTagsForResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateTagsForResourceResponse{
		UpdateTagsForResourceOutput: r.Request.Data.(*UpdateTagsForResourceOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateTagsForResourceResponse is the response type for the
// UpdateTagsForResource API operation.
type UpdateTagsForResourceResponse struct {
	*UpdateTagsForResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateTagsForResource request.
func (r *UpdateTagsForResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
