// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request to describe the resources in an environment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentResourcesMessage
type DescribeEnvironmentResourcesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to retrieve AWS resource usage data.
	//
	// Condition: You must specify either this or an EnvironmentName, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to retrieve AWS resource usage data.
	//
	// Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`
}

// String returns the string representation
func (s DescribeEnvironmentResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEnvironmentResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeEnvironmentResourcesInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Result message containing a list of environment resource descriptions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/EnvironmentResourceDescriptionsMessage
type DescribeEnvironmentResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of EnvironmentResourceDescription.
	EnvironmentResources *EnvironmentResourceDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeEnvironmentResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEnvironmentResources = "DescribeEnvironmentResources"

// DescribeEnvironmentResourcesRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Returns AWS resources for this environment.
//
//    // Example sending a request using DescribeEnvironmentResourcesRequest.
//    req := client.DescribeEnvironmentResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentResources
func (c *Client) DescribeEnvironmentResourcesRequest(input *DescribeEnvironmentResourcesInput) DescribeEnvironmentResourcesRequest {
	op := &aws.Operation{
		Name:       opDescribeEnvironmentResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentResourcesInput{}
	}

	req := c.newRequest(op, input, &DescribeEnvironmentResourcesOutput{})
	return DescribeEnvironmentResourcesRequest{Request: req, Input: input, Copy: c.DescribeEnvironmentResourcesRequest}
}

// DescribeEnvironmentResourcesRequest is the request type for the
// DescribeEnvironmentResources API operation.
type DescribeEnvironmentResourcesRequest struct {
	*aws.Request
	Input *DescribeEnvironmentResourcesInput
	Copy  func(*DescribeEnvironmentResourcesInput) DescribeEnvironmentResourcesRequest
}

// Send marshals and sends the DescribeEnvironmentResources API request.
func (r DescribeEnvironmentResourcesRequest) Send(ctx context.Context) (*DescribeEnvironmentResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEnvironmentResourcesResponse{
		DescribeEnvironmentResourcesOutput: r.Request.Data.(*DescribeEnvironmentResourcesOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeEnvironmentResourcesResponse is the response type for the
// DescribeEnvironmentResources API operation.
type DescribeEnvironmentResourcesResponse struct {
	*DescribeEnvironmentResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEnvironmentResources request.
func (r *DescribeEnvironmentResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
