// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Result message containing a list of application version descriptions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationOptionsMessage
type DescribeConfigurationOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with the configuration template or
	// environment. Only needed if you want to describe the configuration options
	// associated with either the configuration template or environment.
	ApplicationName *string `min:"1" type:"string"`

	// The name of the environment whose configuration options you want to describe.
	EnvironmentName *string `min:"4" type:"string"`

	// If specified, restricts the descriptions to only the specified options.
	Options []OptionSpecification `type:"list"`

	// The ARN of the custom platform.
	PlatformArn *string `type:"string"`

	// The name of the solution stack whose configuration options you want to describe.
	SolutionStackName *string `type:"string"`

	// The name of the configuration template whose configuration options you want
	// to describe.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationOptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeConfigurationOptionsInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}
	if s.Options != nil {
		for i, v := range s.Options {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Options", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the settings for a specified configuration set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ConfigurationOptionsDescription
type DescribeConfigurationOptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ConfigurationOptionDescription.
	Options []ConfigurationOptionDescription `type:"list"`

	// The ARN of the platform.
	PlatformArn *string `type:"string"`

	// The name of the solution stack these configuration options belong to.
	SolutionStackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConfigurationOptions = "DescribeConfigurationOptions"

// DescribeConfigurationOptionsRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Describes the configuration options that are used in a particular configuration
// template or environment, or that a specified solution stack defines. The
// description includes the values the options, their default values, and an
// indication of the required action on a running environment if an option value
// is changed.
//
//    // Example sending a request using DescribeConfigurationOptionsRequest.
//    req := client.DescribeConfigurationOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationOptions
func (c *Client) DescribeConfigurationOptionsRequest(input *DescribeConfigurationOptionsInput) DescribeConfigurationOptionsRequest {
	op := &aws.Operation{
		Name:       opDescribeConfigurationOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationOptionsInput{}
	}

	req := c.newRequest(op, input, &DescribeConfigurationOptionsOutput{})
	return DescribeConfigurationOptionsRequest{Request: req, Input: input, Copy: c.DescribeConfigurationOptionsRequest}
}

// DescribeConfigurationOptionsRequest is the request type for the
// DescribeConfigurationOptions API operation.
type DescribeConfigurationOptionsRequest struct {
	*aws.Request
	Input *DescribeConfigurationOptionsInput
	Copy  func(*DescribeConfigurationOptionsInput) DescribeConfigurationOptionsRequest
}

// Send marshals and sends the DescribeConfigurationOptions API request.
func (r DescribeConfigurationOptionsRequest) Send(ctx context.Context) (*DescribeConfigurationOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConfigurationOptionsResponse{
		DescribeConfigurationOptionsOutput: r.Request.Data.(*DescribeConfigurationOptionsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConfigurationOptionsResponse is the response type for the
// DescribeConfigurationOptions API operation.
type DescribeConfigurationOptionsResponse struct {
	*DescribeConfigurationOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConfigurationOptions request.
func (r *DescribeConfigurationOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
