// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Request to delete a configuration template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteConfigurationTemplateMessage
type DeleteConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to delete the configuration template from.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the configuration template to delete.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteConfigurationTemplateInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteConfigurationTemplateOutput
type DeleteConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteConfigurationTemplate = "DeleteConfigurationTemplate"

// DeleteConfigurationTemplateRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Deletes the specified configuration template.
//
// When you launch an environment using a configuration template, the environment
// gets a copy of the template. You can delete or modify the environment's copy
// of the template without affecting the running environment.
//
//    // Example sending a request using DeleteConfigurationTemplateRequest.
//    req := client.DeleteConfigurationTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteConfigurationTemplate
func (c *Client) DeleteConfigurationTemplateRequest(input *DeleteConfigurationTemplateInput) DeleteConfigurationTemplateRequest {
	op := &aws.Operation{
		Name:       opDeleteConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationTemplateInput{}
	}

	req := c.newRequest(op, input, &DeleteConfigurationTemplateOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteConfigurationTemplateRequest{Request: req, Input: input, Copy: c.DeleteConfigurationTemplateRequest}
}

// DeleteConfigurationTemplateRequest is the request type for the
// DeleteConfigurationTemplate API operation.
type DeleteConfigurationTemplateRequest struct {
	*aws.Request
	Input *DeleteConfigurationTemplateInput
	Copy  func(*DeleteConfigurationTemplateInput) DeleteConfigurationTemplateRequest
}

// Send marshals and sends the DeleteConfigurationTemplate API request.
func (r DeleteConfigurationTemplateRequest) Send(ctx context.Context) (*DeleteConfigurationTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteConfigurationTemplateResponse{
		DeleteConfigurationTemplateOutput: r.Request.Data.(*DeleteConfigurationTemplateOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteConfigurationTemplateResponse is the response type for the
// DeleteConfigurationTemplate API operation.
type DeleteConfigurationTemplateResponse struct {
	*DeleteConfigurationTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteConfigurationTemplate request.
func (r *DeleteConfigurationTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
