// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a DescribeCacheClusters operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClustersMessage
type DescribeCacheClustersInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied cluster identifier. If this parameter is specified, only
	// information about that specific cluster is returned. This parameter isn't
	// case sensitive.
	CacheClusterId *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// An optional flag that can be included in the DescribeCacheCluster request
	// to show only nodes (API/CLI: clusters) that are not members of a replication
	// group. In practice, this mean Memcached and single node Redis clusters.
	ShowCacheClustersNotInReplicationGroups *bool `type:"boolean"`

	// An optional flag that can be included in the DescribeCacheCluster request
	// to retrieve information about the individual cache nodes.
	ShowCacheNodeInfo *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeCacheClustersInput) String() string {
	return awsutil.Prettify(s)
}

// Represents the output of a DescribeCacheClusters operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CacheClusterMessage
type DescribeCacheClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of clusters. Each item in the list contains detailed information about
	// one cluster.
	CacheClusters []CacheCluster `locationNameList:"CacheCluster" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCacheClustersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeCacheClusters = "DescribeCacheClusters"

// DescribeCacheClustersRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Returns information about all provisioned clusters if no cluster identifier
// is specified, or about a specific cache cluster if a cluster identifier is
// supplied.
//
// By default, abbreviated information about the clusters is returned. You can
// use the optional ShowCacheNodeInfo flag to retrieve detailed information
// about the cache nodes associated with the clusters. These details include
// the DNS address and port for the cache node endpoint.
//
// If the cluster is in the creating state, only cluster-level information is
// displayed until all of the nodes are successfully provisioned.
//
// If the cluster is in the deleting state, only cluster-level information is
// displayed.
//
// If cache nodes are currently being added to the cluster, node endpoint information
// and creation time for the additional nodes are not displayed until they are
// completely provisioned. When the cluster state is available, the cluster
// is ready for use.
//
// If cache nodes are currently being removed from the cluster, no endpoint
// information for the removed nodes is displayed.
//
//    // Example sending a request using DescribeCacheClustersRequest.
//    req := client.DescribeCacheClustersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters
func (c *Client) DescribeCacheClustersRequest(input *DescribeCacheClustersInput) DescribeCacheClustersRequest {
	op := &aws.Operation{
		Name:       opDescribeCacheClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheClustersInput{}
	}

	req := c.newRequest(op, input, &DescribeCacheClustersOutput{})
	return DescribeCacheClustersRequest{Request: req, Input: input, Copy: c.DescribeCacheClustersRequest}
}

// DescribeCacheClustersRequest is the request type for the
// DescribeCacheClusters API operation.
type DescribeCacheClustersRequest struct {
	*aws.Request
	Input *DescribeCacheClustersInput
	Copy  func(*DescribeCacheClustersInput) DescribeCacheClustersRequest
}

// Send marshals and sends the DescribeCacheClusters API request.
func (r DescribeCacheClustersRequest) Send(ctx context.Context) (*DescribeCacheClustersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCacheClustersResponse{
		DescribeCacheClustersOutput: r.Request.Data.(*DescribeCacheClustersOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeCacheClustersRequestPaginator returns a paginator for DescribeCacheClusters.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeCacheClustersRequest(input)
//   p := elasticache.NewDescribeCacheClustersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeCacheClustersPaginator(req DescribeCacheClustersRequest) DescribeCacheClustersPaginator {
	return DescribeCacheClustersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeCacheClustersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeCacheClustersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeCacheClustersPaginator struct {
	aws.Pager
}

func (p *DescribeCacheClustersPaginator) CurrentPage() *DescribeCacheClustersOutput {
	return p.Pager.CurrentPage().(*DescribeCacheClustersOutput)
}

// DescribeCacheClustersResponse is the response type for the
// DescribeCacheClusters API operation.
type DescribeCacheClustersResponse struct {
	*DescribeCacheClustersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCacheClusters request.
func (r *DescribeCacheClustersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
