// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeLifecycleConfigurationRequest
type DescribeLifecycleConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the file system whose LifecycleConfiguration object you want to
	// retrieve (String).
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLifecycleConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLifecycleConfigurationInput"}

	if s.FileSystemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileSystemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeLifecycleConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FileSystemId != nil {
		v := *s.FileSystemId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FileSystemId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/LifecycleConfigurationDescription
type DescribeLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An array of lifecycle management policies. Currently, EFS supports a maximum
	// of one policy per file system.
	LifecyclePolicies []LifecyclePolicy `type:"list"`
}

// String returns the string representation
func (s DescribeLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeLifecycleConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LifecyclePolicies) > 0 {
		v := s.LifecyclePolicies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "LifecyclePolicies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDescribeLifecycleConfiguration = "DescribeLifecycleConfiguration"

// DescribeLifecycleConfigurationRequest returns a request value for making API operation for
// Amazon Elastic File System.
//
// Returns the current LifecycleConfiguration object for the specified Amazon
// EFS file system. EFS lifecycle management uses the LifecycleConfiguration
// object to identify which files to move to the EFS Infrequent Access (IA)
// storage class. For a file system without a LifecycleConfiguration object,
// the call returns an empty array in the response.
//
// This operation requires permissions for the elasticfilesystem:DescribeLifecycleConfiguration
// operation.
//
//    // Example sending a request using DescribeLifecycleConfigurationRequest.
//    req := client.DescribeLifecycleConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeLifecycleConfiguration
func (c *Client) DescribeLifecycleConfigurationRequest(input *DescribeLifecycleConfigurationInput) DescribeLifecycleConfigurationRequest {
	op := &aws.Operation{
		Name:       opDescribeLifecycleConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}/lifecycle-configuration",
	}

	if input == nil {
		input = &DescribeLifecycleConfigurationInput{}
	}

	req := c.newRequest(op, input, &DescribeLifecycleConfigurationOutput{})
	return DescribeLifecycleConfigurationRequest{Request: req, Input: input, Copy: c.DescribeLifecycleConfigurationRequest}
}

// DescribeLifecycleConfigurationRequest is the request type for the
// DescribeLifecycleConfiguration API operation.
type DescribeLifecycleConfigurationRequest struct {
	*aws.Request
	Input *DescribeLifecycleConfigurationInput
	Copy  func(*DescribeLifecycleConfigurationInput) DescribeLifecycleConfigurationRequest
}

// Send marshals and sends the DescribeLifecycleConfiguration API request.
func (r DescribeLifecycleConfigurationRequest) Send(ctx context.Context) (*DescribeLifecycleConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLifecycleConfigurationResponse{
		DescribeLifecycleConfigurationOutput: r.Request.Data.(*DescribeLifecycleConfigurationOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLifecycleConfigurationResponse is the response type for the
// DescribeLifecycleConfiguration API operation.
type DescribeLifecycleConfigurationResponse struct {
	*DescribeLifecycleConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLifecycleConfiguration request.
func (r *DescribeLifecycleConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
