// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterTaskDefinitionRequest
type RegisterTaskDefinitionInput struct {
	_ struct{} `type:"structure"`

	// A list of container definitions in JSON format that describe the different
	// containers that make up your task.
	//
	// ContainerDefinitions is a required field
	ContainerDefinitions []ContainerDefinition `locationName:"containerDefinitions" type:"list" required:"true"`

	// The number of CPU units used by the task. It can be expressed as an integer
	// using CPU units, for example 1024, or as a string using vCPUs, for example
	// 1 vCPU or 1 vcpu, in a task definition. String values are converted to an
	// integer indicating the CPU units when the task definition is registered.
	//
	// Task-level CPU and memory parameters are ignored for Windows containers.
	// We recommend specifying container-level resources for Windows containers.
	//
	// If you are using the EC2 launch type, this field is optional. Supported values
	// are between 128 CPU units (0.125 vCPUs) and 10240 CPU units (10 vCPUs).
	//
	// If you are using the Fargate launch type, this field is required and you
	// must use one of the following values, which determines your range of supported
	// values for the memory parameter:
	//
	//    * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB),
	//    2048 (2 GB)
	//
	//    * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072
	//    (3 GB), 4096 (4 GB)
	//
	//    * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096
	//    (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
	//
	//    * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384
	//    (16 GB) in increments of 1024 (1 GB)
	//
	//    * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720
	//    (30 GB) in increments of 1024 (1 GB)
	Cpu *string `locationName:"cpu" type:"string"`

	// The Amazon Resource Name (ARN) of the task execution role that the Amazon
	// ECS container agent and the Docker daemon can assume.
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string"`

	// You must specify a family for a task definition, which allows you to track
	// multiple versions of the same task definition. The family is used as a name
	// for your task definition. Up to 255 letters (uppercase and lowercase), numbers,
	// hyphens, and underscores are allowed.
	//
	// Family is a required field
	Family *string `locationName:"family" type:"string" required:"true"`

	// The IPC resource namespace to use for the containers in the task. The valid
	// values are host, task, or none. If host is specified, then all containers
	// within the tasks that specified the host IPC mode on the same container instance
	// share the same IPC resources with the host Amazon EC2 instance. If task is
	// specified, all containers within the specified task share the same IPC resources.
	// If none is specified, then IPC resources within the containers of a task
	// are private and not shared with other containers in a task or on the container
	// instance. If no value is specified, then the IPC resource namespace sharing
	// depends on the Docker daemon setting on the container instance. For more
	// information, see IPC settings (https://docs.docker.com/engine/reference/run/#ipc-settings---ipc)
	// in the Docker run reference.
	//
	// If the host IPC mode is used, be aware that there is a heightened risk of
	// undesired IPC namespace expose. For more information, see Docker security
	// (https://docs.docker.com/engine/security/security/).
	//
	// If you are setting namespaced kernel parameters using systemControls for
	// the containers in the task, the following will apply to your IPC resource
	// namespace. For more information, see System Controls (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	//    * For tasks that use the host IPC mode, IPC namespace related systemControls
	//    are not supported.
	//
	//    * For tasks that use the task IPC mode, IPC namespace related systemControls
	//    will apply to all containers within a task.
	//
	// This parameter is not supported for Windows containers or tasks using the
	// Fargate launch type.
	IpcMode IpcMode `locationName:"ipcMode" type:"string" enum:"true"`

	// The amount of memory (in MiB) used by the task. It can be expressed as an
	// integer using MiB, for example 1024, or as a string using GB, for example
	// 1GB or 1 GB, in a task definition. String values are converted to an integer
	// indicating the MiB when the task definition is registered.
	//
	// Task-level CPU and memory parameters are ignored for Windows containers.
	// We recommend specifying container-level resources for Windows containers.
	//
	// If using the EC2 launch type, this field is optional.
	//
	// If using the Fargate launch type, this field is required and you must use
	// one of the following values, which determines your range of supported values
	// for the cpu parameter:
	//
	//    * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25
	//    vCPU)
	//
	//    * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values:
	//    512 (.5 vCPU)
	//
	//    * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168
	//    (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
	//
	//    * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 2048 (2 vCPU)
	//
	//    * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) -
	//    Available cpu values: 4096 (4 vCPU)
	Memory *string `locationName:"memory" type:"string"`

	// The Docker networking mode to use for the containers in the task. The valid
	// values are none, bridge, awsvpc, and host. The default Docker network mode
	// is bridge. If you are using the Fargate launch type, the awsvpc network mode
	// is required. If you are using the EC2 launch type, any network mode can be
	// used. If the network mode is set to none, you cannot specify port mappings
	// in your container definitions, and the tasks containers do not have external
	// connectivity. The host and awsvpc network modes offer the highest networking
	// performance for containers because they use the EC2 network stack instead
	// of the virtualized network stack provided by the bridge mode.
	//
	// With the host and awsvpc network modes, exposed container ports are mapped
	// directly to the corresponding host port (for the host network mode) or the
	// attached elastic network interface port (for the awsvpc network mode), so
	// you cannot take advantage of dynamic host port mappings.
	//
	// If the network mode is awsvpc, the task is allocated an elastic network interface,
	// and you must specify a NetworkConfiguration value when you create a service
	// or run a task with the task definition. For more information, see Task Networking
	// (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with
	// the ecs-init package, or AWS Fargate infrastructure support the awsvpc network
	// mode.
	//
	// If the network mode is host, you cannot run multiple instantiations of the
	// same task on a single container instance when port mappings are used.
	//
	// Docker for Windows uses different network modes than Docker for Linux. When
	// you register a task definition with Windows containers, you must not specify
	// a network mode. If you use the console to register a task definition with
	// Windows containers, you must choose the <default> network mode object.
	//
	// For more information, see Network settings (https://docs.docker.com/engine/reference/run/#network-settings)
	// in the Docker run reference.
	NetworkMode NetworkMode `locationName:"networkMode" type:"string" enum:"true"`

	// The process namespace to use for the containers in the task. The valid values
	// are host or task. If host is specified, then all containers within the tasks
	// that specified the host PID mode on the same container instance share the
	// same IPC resources with the host Amazon EC2 instance. If task is specified,
	// all containers within the specified task share the same process namespace.
	// If no value is specified, the default is a private namespace. For more information,
	// see PID settings (https://docs.docker.com/engine/reference/run/#pid-settings---pid)
	// in the Docker run reference.
	//
	// If the host PID mode is used, be aware that there is a heightened risk of
	// undesired process namespace expose. For more information, see Docker security
	// (https://docs.docker.com/engine/security/security/).
	//
	// This parameter is not supported for Windows containers or tasks using the
	// Fargate launch type.
	PidMode PidMode `locationName:"pidMode" type:"string" enum:"true"`

	// An array of placement constraint objects to use for the task. You can specify
	// a maximum of 10 constraints per task (this limit includes constraints in
	// the task definition and those specified at runtime).
	PlacementConstraints []TaskDefinitionPlacementConstraint `locationName:"placementConstraints" type:"list"`

	// The configuration details for the App Mesh proxy.
	//
	// For tasks using the EC2 launch type, the container instances require at least
	// version 1.26.0 of the container agent and at least version 1.26.0-1 of the
	// ecs-init package to enable a proxy configuration. If your container instances
	// are launched from the Amazon ECS-optimized AMI version 20190301 or later,
	// then they contain the required versions of the container agent and ecs-init.
	// For more information, see Amazon ECS-optimized Linux AMI (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// This parameter is available for tasks using the Fargate launch type in the
	// Ohio (us-east-2) region only and the task or service requires platform version
	// 1.3.0 or later.
	ProxyConfiguration *ProxyConfiguration `locationName:"proxyConfiguration" type:"structure"`

	// The launch type required by the task. If no value is specified, it defaults
	// to EC2.
	RequiresCompatibilities []Compatibility `locationName:"requiresCompatibilities" type:"list"`

	// The metadata that you apply to the task definition to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both
	// of which you define. Tag keys can have a maximum character length of 128
	// characters, and tag values can have a maximum length of 256 characters.
	Tags []Tag `locationName:"tags" type:"list"`

	// The short name or full Amazon Resource Name (ARN) of the IAM role that containers
	// in this task can assume. All containers in this task are granted the permissions
	// that are specified in this role. For more information, see IAM Roles for
	// Tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	TaskRoleArn *string `locationName:"taskRoleArn" type:"string"`

	// A list of volume definitions in JSON format that containers in your task
	// may use.
	Volumes []Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation
func (s RegisterTaskDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterTaskDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterTaskDefinitionInput"}

	if s.ContainerDefinitions == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerDefinitions"))
	}

	if s.Family == nil {
		invalidParams.Add(aws.NewErrParamRequired("Family"))
	}
	if s.ContainerDefinitions != nil {
		for i, v := range s.ContainerDefinitions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContainerDefinitions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ProxyConfiguration != nil {
		if err := s.ProxyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProxyConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterTaskDefinitionResponse
type RegisterTaskDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags associated with the task definition.
	Tags []Tag `locationName:"tags" type:"list"`

	// The full description of the registered task definition.
	TaskDefinition *TaskDefinition `locationName:"taskDefinition" type:"structure"`
}

// String returns the string representation
func (s RegisterTaskDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterTaskDefinition = "RegisterTaskDefinition"

// RegisterTaskDefinitionRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Registers a new task definition from the supplied family and containerDefinitions.
// Optionally, you can add data volumes to your containers with the volumes
// parameter. For more information about task definition parameters and defaults,
// see Amazon ECS Task Definitions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// You can specify an IAM role for your task with the taskRoleArn parameter.
// When you specify an IAM role for a task, its containers can then use the
// latest versions of the AWS CLI or SDKs to make API requests to the AWS services
// that are specified in the IAM policy associated with the role. For more information,
// see IAM Roles for Tasks (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// You can specify a Docker networking mode for the containers in your task
// definition with the networkMode parameter. The available network modes correspond
// to those described in Network settings (https://docs.docker.com/engine/reference/run/#/network-settings)
// in the Docker run reference. If you specify the awsvpc network mode, the
// task is allocated an elastic network interface, and you must specify a NetworkConfiguration
// when you create a service or run a task with the task definition. For more
// information, see Task Networking (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
// in the Amazon Elastic Container Service Developer Guide.
//
//    // Example sending a request using RegisterTaskDefinitionRequest.
//    req := client.RegisterTaskDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/RegisterTaskDefinition
func (c *Client) RegisterTaskDefinitionRequest(input *RegisterTaskDefinitionInput) RegisterTaskDefinitionRequest {
	op := &aws.Operation{
		Name:       opRegisterTaskDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTaskDefinitionInput{}
	}

	req := c.newRequest(op, input, &RegisterTaskDefinitionOutput{})
	return RegisterTaskDefinitionRequest{Request: req, Input: input, Copy: c.RegisterTaskDefinitionRequest}
}

// RegisterTaskDefinitionRequest is the request type for the
// RegisterTaskDefinition API operation.
type RegisterTaskDefinitionRequest struct {
	*aws.Request
	Input *RegisterTaskDefinitionInput
	Copy  func(*RegisterTaskDefinitionInput) RegisterTaskDefinitionRequest
}

// Send marshals and sends the RegisterTaskDefinition API request.
func (r RegisterTaskDefinitionRequest) Send(ctx context.Context) (*RegisterTaskDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterTaskDefinitionResponse{
		RegisterTaskDefinitionOutput: r.Request.Data.(*RegisterTaskDefinitionOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterTaskDefinitionResponse is the response type for the
// RegisterTaskDefinition API operation.
type RegisterTaskDefinitionResponse struct {
	*RegisterTaskDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterTaskDefinition request.
func (r *RegisterTaskDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
