// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTasksRequest
type DescribeTasksInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the task to describe. If you do not specify a cluster, the default cluster
	// is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// Specifies whether you want to see the resource tags for the task. If TAGS
	// is specified, the tags are included in the response. If this field is omitted,
	// tags are not included in the response.
	Include []TaskField `locationName:"include" type:"list"`

	// A list of up to 100 task IDs or full ARN entries.
	//
	// Tasks is a required field
	Tasks []string `locationName:"tasks" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTasksInput"}

	if s.Tasks == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tasks"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTasksResponse
type DescribeTasksOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []Failure `locationName:"failures" type:"list"`

	// The list of tasks.
	Tasks []Task `locationName:"tasks" type:"list"`
}

// String returns the string representation
func (s DescribeTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTasks = "DescribeTasks"

// DescribeTasksRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Describes a specified task or tasks.
//
//    // Example sending a request using DescribeTasksRequest.
//    req := client.DescribeTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeTasks
func (c *Client) DescribeTasksRequest(input *DescribeTasksInput) DescribeTasksRequest {
	op := &aws.Operation{
		Name:       opDescribeTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTasksInput{}
	}

	req := c.newRequest(op, input, &DescribeTasksOutput{})
	return DescribeTasksRequest{Request: req, Input: input, Copy: c.DescribeTasksRequest}
}

// DescribeTasksRequest is the request type for the
// DescribeTasks API operation.
type DescribeTasksRequest struct {
	*aws.Request
	Input *DescribeTasksInput
	Copy  func(*DescribeTasksInput) DescribeTasksRequest
}

// Send marshals and sends the DescribeTasks API request.
func (r DescribeTasksRequest) Send(ctx context.Context) (*DescribeTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTasksResponse{
		DescribeTasksOutput: r.Request.Data.(*DescribeTasksOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTasksResponse is the response type for the
// DescribeTasks API operation.
type DescribeTasksResponse struct {
	*DescribeTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTasks request.
func (r *DescribeTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
