// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceNetworkAclAssociationRequest
type ReplaceNetworkAclAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the current association between the original network ACL and the
	// subnet.
	//
	// AssociationId is a required field
	AssociationId *string `locationName:"associationId" type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the new network ACL to associate with the subnet.
	//
	// NetworkAclId is a required field
	NetworkAclId *string `locationName:"networkAclId" type:"string" required:"true"`
}

// String returns the string representation
func (s ReplaceNetworkAclAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplaceNetworkAclAssociationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplaceNetworkAclAssociationInput"}

	if s.AssociationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssociationId"))
	}

	if s.NetworkAclId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NetworkAclId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceNetworkAclAssociationResult
type ReplaceNetworkAclAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new association.
	NewAssociationId *string `locationName:"newAssociationId" type:"string"`
}

// String returns the string representation
func (s ReplaceNetworkAclAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

const opReplaceNetworkAclAssociation = "ReplaceNetworkAclAssociation"

// ReplaceNetworkAclAssociationRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Changes which network ACL a subnet is associated with. By default when you
// create a subnet, it's automatically associated with the default network ACL.
// For more information, see Network ACLs (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// This is an idempotent operation.
//
//    // Example sending a request using ReplaceNetworkAclAssociationRequest.
//    req := client.ReplaceNetworkAclAssociationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceNetworkAclAssociation
func (c *Client) ReplaceNetworkAclAssociationRequest(input *ReplaceNetworkAclAssociationInput) ReplaceNetworkAclAssociationRequest {
	op := &aws.Operation{
		Name:       opReplaceNetworkAclAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplaceNetworkAclAssociationInput{}
	}

	req := c.newRequest(op, input, &ReplaceNetworkAclAssociationOutput{})
	return ReplaceNetworkAclAssociationRequest{Request: req, Input: input, Copy: c.ReplaceNetworkAclAssociationRequest}
}

// ReplaceNetworkAclAssociationRequest is the request type for the
// ReplaceNetworkAclAssociation API operation.
type ReplaceNetworkAclAssociationRequest struct {
	*aws.Request
	Input *ReplaceNetworkAclAssociationInput
	Copy  func(*ReplaceNetworkAclAssociationInput) ReplaceNetworkAclAssociationRequest
}

// Send marshals and sends the ReplaceNetworkAclAssociation API request.
func (r ReplaceNetworkAclAssociationRequest) Send(ctx context.Context) (*ReplaceNetworkAclAssociationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ReplaceNetworkAclAssociationResponse{
		ReplaceNetworkAclAssociationOutput: r.Request.Data.(*ReplaceNetworkAclAssociationOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ReplaceNetworkAclAssociationResponse is the response type for the
// ReplaceNetworkAclAssociation API operation.
type ReplaceNetworkAclAssociationResponse struct {
	*ReplaceNetworkAclAssociationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ReplaceNetworkAclAssociation request.
func (r *ReplaceNetworkAclAssociationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
