// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodbstreams

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a ListStreams operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/ListStreamsInput
type ListStreamsInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the first item that this operation will
	// evaluate. Use the value that was returned for LastEvaluatedStreamArn in the
	// previous operation.
	ExclusiveStartStreamArn *string `min:"37" type:"string"`

	// The maximum number of streams to return. The upper limit is 100.
	Limit *int64 `min:"1" type:"integer"`

	// If this parameter is provided, then only the streams associated with this
	// table name are returned.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s ListStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListStreamsInput"}
	if s.ExclusiveStartStreamArn != nil && len(*s.ExclusiveStartStreamArn) < 37 {
		invalidParams.Add(aws.NewErrParamMinLen("ExclusiveStartStreamArn", 37))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a ListStreams operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/ListStreamsOutput
type ListStreamsOutput struct {
	_ struct{} `type:"structure"`

	// The stream ARN of the item where the operation stopped, inclusive of the
	// previous result set. Use this value to start a new operation, excluding this
	// value in the new request.
	//
	// If LastEvaluatedStreamArn is empty, then the "last page" of results has been
	// processed and there is no more data to be retrieved.
	//
	// If LastEvaluatedStreamArn is not empty, it does not necessarily mean that
	// there is more data in the result set. The only way to know when you have
	// reached the end of the result set is when LastEvaluatedStreamArn is empty.
	LastEvaluatedStreamArn *string `min:"37" type:"string"`

	// A list of stream descriptors associated with the current account and endpoint.
	Streams []Stream `type:"list"`
}

// String returns the string representation
func (s ListStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListStreams = "ListStreams"

// ListStreamsRequest returns a request value for making API operation for
// Amazon DynamoDB Streams.
//
// Returns an array of stream ARNs associated with the current account and endpoint.
// If the TableName parameter is present, then ListStreams will return only
// the streams ARNs for that table.
//
// You can call ListStreams at a maximum rate of 5 times per second.
//
//    // Example sending a request using ListStreamsRequest.
//    req := client.ListStreamsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/streams-dynamodb-2012-08-10/ListStreams
func (c *Client) ListStreamsRequest(input *ListStreamsInput) ListStreamsRequest {
	op := &aws.Operation{
		Name:       opListStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStreamsInput{}
	}

	req := c.newRequest(op, input, &ListStreamsOutput{})
	return ListStreamsRequest{Request: req, Input: input, Copy: c.ListStreamsRequest}
}

// ListStreamsRequest is the request type for the
// ListStreams API operation.
type ListStreamsRequest struct {
	*aws.Request
	Input *ListStreamsInput
	Copy  func(*ListStreamsInput) ListStreamsRequest
}

// Send marshals and sends the ListStreams API request.
func (r ListStreamsRequest) Send(ctx context.Context) (*ListStreamsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListStreamsResponse{
		ListStreamsOutput: r.Request.Data.(*ListStreamsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListStreamsResponse is the response type for the
// ListStreams API operation.
type ListStreamsResponse struct {
	*ListStreamsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListStreams request.
func (r *ListStreamsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
