// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Describes the trust relationships for a particular AWS Managed Microsoft
// AD directory. If no input parameters are are provided, such as directory
// ID or trust ID, this request describes all the trust relationships.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrustsRequest
type DescribeTrustsInput struct {
	_ struct{} `type:"structure"`

	// The Directory ID of the AWS directory that is a part of the requested trust
	// relationship.
	DirectoryId *string `type:"string"`

	// The maximum number of objects to return.
	Limit *int64 `type:"integer"`

	// The DescribeTrustsResult.NextToken value from a previous call to DescribeTrusts.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`

	// A list of identifiers of the trust relationships for which to obtain the
	// information. If this member is null, all trust relationships that belong
	// to the current account are returned.
	//
	// An empty list results in an InvalidParameterException being thrown.
	TrustIds []string `type:"list"`
}

// String returns the string representation
func (s DescribeTrustsInput) String() string {
	return awsutil.Prettify(s)
}

// The result of a DescribeTrust request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrustsResult
type DescribeTrustsOutput struct {
	_ struct{} `type:"structure"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to DescribeTrusts to retrieve the next set
	// of items.
	NextToken *string `type:"string"`

	// The list of Trust objects that were retrieved.
	//
	// It is possible that this list contains less than the number of items specified
	// in the Limit member of the request. This occurs if there are less than the
	// requested number of items left to retrieve, or if the limitations of the
	// operation have been exceeded.
	Trusts []Trust `type:"list"`
}

// String returns the string representation
func (s DescribeTrustsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTrusts = "DescribeTrusts"

// DescribeTrustsRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Obtains information about the trust relationships for this account.
//
// If no input parameters are provided, such as DirectoryId or TrustIds, this
// request describes all the trust relationships belonging to the account.
//
//    // Example sending a request using DescribeTrustsRequest.
//    req := client.DescribeTrustsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts
func (c *Client) DescribeTrustsRequest(input *DescribeTrustsInput) DescribeTrustsRequest {
	op := &aws.Operation{
		Name:       opDescribeTrusts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustsInput{}
	}

	req := c.newRequest(op, input, &DescribeTrustsOutput{})
	return DescribeTrustsRequest{Request: req, Input: input, Copy: c.DescribeTrustsRequest}
}

// DescribeTrustsRequest is the request type for the
// DescribeTrusts API operation.
type DescribeTrustsRequest struct {
	*aws.Request
	Input *DescribeTrustsInput
	Copy  func(*DescribeTrustsInput) DescribeTrustsRequest
}

// Send marshals and sends the DescribeTrusts API request.
func (r DescribeTrustsRequest) Send(ctx context.Context) (*DescribeTrustsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTrustsResponse{
		DescribeTrustsOutput: r.Request.Data.(*DescribeTrustsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTrustsResponse is the response type for the
// DescribeTrusts API operation.
type DescribeTrustsResponse struct {
	*DescribeTrustsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTrusts request.
func (r *DescribeTrustsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
