// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateInstanceProfileRequest
type UpdateInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// The updated description for your instance profile.
	Description *string `locationName:"description" type:"string"`

	// An array of strings specifying the list of app packages that should not be
	// cleaned up from the device after a test run is over.
	//
	// The list of packages is only considered if you set packageCleanup to true.
	ExcludeAppPackagesFromCleanup []string `locationName:"excludeAppPackagesFromCleanup" type:"list"`

	// The updated name for your instance profile.
	Name *string `locationName:"name" type:"string"`

	// The updated choice for whether you want to specify package cleanup. The default
	// value is false for private devices.
	PackageCleanup *bool `locationName:"packageCleanup" type:"boolean"`

	// The updated choice for whether you want to reboot the device after use. The
	// default value is true.
	RebootAfterUse *bool `locationName:"rebootAfterUse" type:"boolean"`
}

// String returns the string representation
func (s UpdateInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInstanceProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateInstanceProfileInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateInstanceProfileResult
type UpdateInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about your instance profile.
	InstanceProfile *InstanceProfile `locationName:"instanceProfile" type:"structure"`
}

// String returns the string representation
func (s UpdateInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateInstanceProfile = "UpdateInstanceProfile"

// UpdateInstanceProfileRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Updates information about an existing private device instance profile.
//
//    // Example sending a request using UpdateInstanceProfileRequest.
//    req := client.UpdateInstanceProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateInstanceProfile
func (c *Client) UpdateInstanceProfileRequest(input *UpdateInstanceProfileInput) UpdateInstanceProfileRequest {
	op := &aws.Operation{
		Name:       opUpdateInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceProfileInput{}
	}

	req := c.newRequest(op, input, &UpdateInstanceProfileOutput{})
	return UpdateInstanceProfileRequest{Request: req, Input: input, Copy: c.UpdateInstanceProfileRequest}
}

// UpdateInstanceProfileRequest is the request type for the
// UpdateInstanceProfile API operation.
type UpdateInstanceProfileRequest struct {
	*aws.Request
	Input *UpdateInstanceProfileInput
	Copy  func(*UpdateInstanceProfileInput) UpdateInstanceProfileRequest
}

// Send marshals and sends the UpdateInstanceProfile API request.
func (r UpdateInstanceProfileRequest) Send(ctx context.Context) (*UpdateInstanceProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateInstanceProfileResponse{
		UpdateInstanceProfileOutput: r.Request.Data.(*UpdateInstanceProfileOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateInstanceProfileResponse is the response type for the
// UpdateInstanceProfile API operation.
type UpdateInstanceProfileResponse struct {
	*UpdateInstanceProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateInstanceProfile request.
func (r *UpdateInstanceProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
