// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dax

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateParameterGroupRequest
type CreateParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the parameter group.
	Description *string `type:"string"`

	// The name of the parameter group to apply to all of the clusters in this replication
	// group.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParameterGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateParameterGroupInput"}

	if s.ParameterGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateParameterGroupResponse
type CreateParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of a CreateParameterGroup action.
	ParameterGroup *ParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateParameterGroup = "CreateParameterGroup"

// CreateParameterGroupRequest returns a request value for making API operation for
// Amazon DynamoDB Accelerator (DAX).
//
// Creates a new parameter group. A parameter group is a collection of parameters
// that you apply to all of the nodes in a DAX cluster.
//
//    // Example sending a request using CreateParameterGroupRequest.
//    req := client.CreateParameterGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateParameterGroup
func (c *Client) CreateParameterGroupRequest(input *CreateParameterGroupInput) CreateParameterGroupRequest {
	op := &aws.Operation{
		Name:       opCreateParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateParameterGroupInput{}
	}

	req := c.newRequest(op, input, &CreateParameterGroupOutput{})
	return CreateParameterGroupRequest{Request: req, Input: input, Copy: c.CreateParameterGroupRequest}
}

// CreateParameterGroupRequest is the request type for the
// CreateParameterGroup API operation.
type CreateParameterGroupRequest struct {
	*aws.Request
	Input *CreateParameterGroupInput
	Copy  func(*CreateParameterGroupInput) CreateParameterGroupRequest
}

// Send marshals and sends the CreateParameterGroup API request.
func (r CreateParameterGroupRequest) Send(ctx context.Context) (*CreateParameterGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateParameterGroupResponse{
		CreateParameterGroupOutput: r.Request.Data.(*CreateParameterGroupOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateParameterGroupResponse is the response type for the
// CreateParameterGroup API operation.
type CreateParameterGroupResponse struct {
	*CreateParameterGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateParameterGroup request.
func (r *CreateParameterGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
