// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// DescribeTaskRequest
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTaskRequest
type DescribeTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task to describe.
	//
	// TaskArn is a required field
	TaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTaskInput"}

	if s.TaskArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DescribeTaskResponse
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTaskResponse
type DescribeTaskOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was
	// used to monitor and log events in the task.
	//
	// For more information on these groups, see "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html"
	// (Working with Log Groups and Log Streams) in the Amazon CloudWatch UserGuide.
	CloudWatchLogGroupArn *string `type:"string"`

	// The time that the task was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the task execution that is syncing files.
	CurrentTaskExecutionArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS storage resource's location.
	DestinationLocationArn *string `type:"string"`

	// Errors that AWS DataSync encountered during execution of the task. You can
	// use this error code to help troubleshoot issues.
	ErrorCode *string `type:"string"`

	// Detailed description of an error that was encountered during the task execution.
	// You can use this information to help troubleshoot issues.
	ErrorDetail *string `type:"string"`

	// Specifies that the task excludes files in the transfer based on the specified
	// pattern in the filter. Transfers all files in the task’s subdirectory,
	// except files that match the filter that is set.
	Excludes []FilterRule `type:"list"`

	// The name of the task that was described.
	Name *string `min:"1" type:"string"`

	// The set of configuration options that control the behavior of a single execution
	// of the task that occurs when you call StartTaskExecution. You can configure
	// these options to preserve metadata such as user ID (UID) and group (GID),
	// file permissions, data integrity verification, and so on.
	//
	// For each individual task execution, you can override these options by specifying
	// the overriding OverrideOptions value to operation.
	Options *Options `type:"structure"`

	// The Amazon Resource Name (ARN) of the source file system's location.
	SourceLocationArn *string `type:"string"`

	// The status of the task that was described.
	//
	// For detailed information about task execution statuses, see "https://docs.aws.amazon.com/datasync/latest/userguide/working-with-tasks.html#understand-task-creation-statuses"
	// (Understanding Task Statuses).
	Status TaskStatus `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the task that was described.
	TaskArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTask = "DescribeTask"

// DescribeTaskRequest returns a request value for making API operation for
// AWS DataSync.
//
// Returns metadata about a task.
//
//    // Example sending a request using DescribeTaskRequest.
//    req := client.DescribeTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTask
func (c *Client) DescribeTaskRequest(input *DescribeTaskInput) DescribeTaskRequest {
	op := &aws.Operation{
		Name:       opDescribeTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTaskInput{}
	}

	req := c.newRequest(op, input, &DescribeTaskOutput{})
	return DescribeTaskRequest{Request: req, Input: input, Copy: c.DescribeTaskRequest}
}

// DescribeTaskRequest is the request type for the
// DescribeTask API operation.
type DescribeTaskRequest struct {
	*aws.Request
	Input *DescribeTaskInput
	Copy  func(*DescribeTaskInput) DescribeTaskRequest
}

// Send marshals and sends the DescribeTask API request.
func (r DescribeTaskRequest) Send(ctx context.Context) (*DescribeTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTaskResponse{
		DescribeTaskOutput: r.Request.Data.(*DescribeTaskOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTaskResponse is the response type for the
// DescribeTask API operation.
type DescribeTaskResponse struct {
	*DescribeTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTask request.
func (r *DescribeTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
