// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datapipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for ListPipelines.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ListPipelinesInput
type ListPipelinesInput struct {
	_ struct{} `type:"structure"`

	// The starting point for the results to be returned. For the first call, this
	// value should be empty. As long as there are more results, continue to call
	// ListPipelines with the marker value from the previous call to retrieve the
	// next set of results.
	Marker *string `locationName:"marker" type:"string"`
}

// String returns the string representation
func (s ListPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output of ListPipelines.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ListPipelinesOutput
type ListPipelinesOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are more results that can be obtained by a subsequent
	// call.
	HasMoreResults *bool `locationName:"hasMoreResults" type:"boolean"`

	// The starting point for the next page of results. To view the next page of
	// results, call ListPipelinesOutput again with this marker value. If the value
	// is null, there are no more results.
	Marker *string `locationName:"marker" type:"string"`

	// The pipeline identifiers. If you require additional information about the
	// pipelines, you can use these identifiers to call DescribePipelines and GetPipelineDefinition.
	//
	// PipelineIdList is a required field
	PipelineIdList []PipelineIdName `locationName:"pipelineIdList" type:"list" required:"true"`
}

// String returns the string representation
func (s ListPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest returns a request value for making API operation for
// AWS Data Pipeline.
//
// Lists the pipeline identifiers for all active pipelines that you have permission
// to access.
//
//    // Example sending a request using ListPipelinesRequest.
//    req := client.ListPipelinesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/ListPipelines
func (c *Client) ListPipelinesRequest(input *ListPipelinesInput) ListPipelinesRequest {
	op := &aws.Operation{
		Name:       opListPipelines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"marker"},
			LimitToken:      "",
			TruncationToken: "hasMoreResults",
		},
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	req := c.newRequest(op, input, &ListPipelinesOutput{})
	return ListPipelinesRequest{Request: req, Input: input, Copy: c.ListPipelinesRequest}
}

// ListPipelinesRequest is the request type for the
// ListPipelines API operation.
type ListPipelinesRequest struct {
	*aws.Request
	Input *ListPipelinesInput
	Copy  func(*ListPipelinesInput) ListPipelinesRequest
}

// Send marshals and sends the ListPipelines API request.
func (r ListPipelinesRequest) Send(ctx context.Context) (*ListPipelinesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPipelinesResponse{
		ListPipelinesOutput: r.Request.Data.(*ListPipelinesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPipelinesRequestPaginator returns a paginator for ListPipelines.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPipelinesRequest(input)
//   p := datapipeline.NewListPipelinesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPipelinesPaginator(req ListPipelinesRequest) ListPipelinesPaginator {
	return ListPipelinesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPipelinesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPipelinesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPipelinesPaginator struct {
	aws.Pager
}

func (p *ListPipelinesPaginator) CurrentPage() *ListPipelinesOutput {
	return p.Pager.CurrentPage().(*ListPipelinesOutput)
}

// ListPipelinesResponse is the response type for the
// ListPipelines API operation.
type ListPipelinesResponse struct {
	*ListPipelinesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPipelines request.
func (r *ListPipelinesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
