// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costandusagereportservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Requests a list of AWS Cost and Usage reports owned by the account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitionsRequest
type DescribeReportDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that AWS returns for the operation.
	MaxResults *int64 `min:"5" type:"integer"`

	// A generic string.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeReportDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReportDefinitionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeReportDefinitionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// If the action is successful, the service sends back an HTTP 200 response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitionsResponse
type DescribeReportDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// A generic string.
	NextToken *string `type:"string"`

	// A list of AWS Cost and Usage reports owned by the account.
	ReportDefinitions []ReportDefinition `type:"list"`
}

// String returns the string representation
func (s DescribeReportDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeReportDefinitions = "DescribeReportDefinitions"

// DescribeReportDefinitionsRequest returns a request value for making API operation for
// AWS Cost and Usage Report Service.
//
// Lists the AWS Cost and Usage reports available to this account.
//
//    // Example sending a request using DescribeReportDefinitionsRequest.
//    req := client.DescribeReportDefinitionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions
func (c *Client) DescribeReportDefinitionsRequest(input *DescribeReportDefinitionsInput) DescribeReportDefinitionsRequest {
	op := &aws.Operation{
		Name:       opDescribeReportDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReportDefinitionsInput{}
	}

	req := c.newRequest(op, input, &DescribeReportDefinitionsOutput{})
	return DescribeReportDefinitionsRequest{Request: req, Input: input, Copy: c.DescribeReportDefinitionsRequest}
}

// DescribeReportDefinitionsRequest is the request type for the
// DescribeReportDefinitions API operation.
type DescribeReportDefinitionsRequest struct {
	*aws.Request
	Input *DescribeReportDefinitionsInput
	Copy  func(*DescribeReportDefinitionsInput) DescribeReportDefinitionsRequest
}

// Send marshals and sends the DescribeReportDefinitions API request.
func (r DescribeReportDefinitionsRequest) Send(ctx context.Context) (*DescribeReportDefinitionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeReportDefinitionsResponse{
		DescribeReportDefinitionsOutput: r.Request.Data.(*DescribeReportDefinitionsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeReportDefinitionsRequestPaginator returns a paginator for DescribeReportDefinitions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeReportDefinitionsRequest(input)
//   p := costandusagereportservice.NewDescribeReportDefinitionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeReportDefinitionsPaginator(req DescribeReportDefinitionsRequest) DescribeReportDefinitionsPaginator {
	return DescribeReportDefinitionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeReportDefinitionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeReportDefinitionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeReportDefinitionsPaginator struct {
	aws.Pager
}

func (p *DescribeReportDefinitionsPaginator) CurrentPage() *DescribeReportDefinitionsOutput {
	return p.Pager.CurrentPage().(*DescribeReportDefinitionsOutput)
}

// DescribeReportDefinitionsResponse is the response type for the
// DescribeReportDefinitions API operation.
type DescribeReportDefinitionsResponse struct {
	*DescribeReportDefinitionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeReportDefinitions request.
func (r *DescribeReportDefinitionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
