// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The input for the GetResourceConfigHistory action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistoryRequest
type GetResourceConfigHistoryInput struct {
	_ struct{} `type:"structure"`

	// The chronological order for configuration items listed. By default, the results
	// are listed in reverse chronological order.
	ChronologicalOrder ChronologicalOrder `locationName:"chronologicalOrder" type:"string" enum:"true"`

	// The time stamp that indicates an earlier time. If not specified, the action
	// returns paginated results that contain configuration items that start when
	// the first configuration item was recorded.
	EarlierTime *time.Time `locationName:"earlierTime" type:"timestamp" timestampFormat:"unix"`

	// The time stamp that indicates a later time. If not specified, current time
	// is taken.
	LaterTime *time.Time `locationName:"laterTime" type:"timestamp" timestampFormat:"unix"`

	// The maximum number of configuration items returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType ResourceType `locationName:"resourceType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GetResourceConfigHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceConfigHistoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetResourceConfigHistoryInput"}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}
	if len(s.ResourceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the GetResourceConfigHistory action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistoryResponse
type GetResourceConfigHistoryOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the configuration history of one or more resources.
	ConfigurationItems []ConfigurationItem `locationName:"configurationItems" type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetResourceConfigHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetResourceConfigHistory = "GetResourceConfigHistory"

// GetResourceConfigHistoryRequest returns a request value for making API operation for
// AWS Config.
//
// Returns a list of configuration items for the specified resource. The list
// contains details about each state of the resource during the specified time
// interval. If you specified a retention period to retain your ConfigurationItems
// between a minimum of 30 days and a maximum of 7 years (2557 days), AWS Config
// returns the ConfigurationItems for the specified retention period.
//
// The response is paginated. By default, AWS Config returns a limit of 10 configuration
// items per page. You can customize this number with the limit parameter. The
// response includes a nextToken string. To get the next page of results, run
// the request again and specify the string for the nextToken parameter.
//
// Each call to the API is limited to span a duration of seven days. It is likely
// that the number of records returned is smaller than the specified limit.
// In such cases, you can make another call, using the nextToken.
//
//    // Example sending a request using GetResourceConfigHistoryRequest.
//    req := client.GetResourceConfigHistoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory
func (c *Client) GetResourceConfigHistoryRequest(input *GetResourceConfigHistoryInput) GetResourceConfigHistoryRequest {
	op := &aws.Operation{
		Name:       opGetResourceConfigHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceConfigHistoryInput{}
	}

	req := c.newRequest(op, input, &GetResourceConfigHistoryOutput{})
	return GetResourceConfigHistoryRequest{Request: req, Input: input, Copy: c.GetResourceConfigHistoryRequest}
}

// GetResourceConfigHistoryRequest is the request type for the
// GetResourceConfigHistory API operation.
type GetResourceConfigHistoryRequest struct {
	*aws.Request
	Input *GetResourceConfigHistoryInput
	Copy  func(*GetResourceConfigHistoryInput) GetResourceConfigHistoryRequest
}

// Send marshals and sends the GetResourceConfigHistory API request.
func (r GetResourceConfigHistoryRequest) Send(ctx context.Context) (*GetResourceConfigHistoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetResourceConfigHistoryResponse{
		GetResourceConfigHistoryOutput: r.Request.Data.(*GetResourceConfigHistoryOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetResourceConfigHistoryRequestPaginator returns a paginator for GetResourceConfigHistory.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetResourceConfigHistoryRequest(input)
//   p := configservice.NewGetResourceConfigHistoryRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetResourceConfigHistoryPaginator(req GetResourceConfigHistoryRequest) GetResourceConfigHistoryPaginator {
	return GetResourceConfigHistoryPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetResourceConfigHistoryInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetResourceConfigHistoryPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetResourceConfigHistoryPaginator struct {
	aws.Pager
}

func (p *GetResourceConfigHistoryPaginator) CurrentPage() *GetResourceConfigHistoryOutput {
	return p.Pager.CurrentPage().(*GetResourceConfigHistoryOutput)
}

// GetResourceConfigHistoryResponse is the response type for the
// GetResourceConfigHistory API operation.
type GetResourceConfigHistoryResponse struct {
	*GetResourceConfigHistoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetResourceConfigHistory request.
func (r *GetResourceConfigHistoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
