// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizationsRequest
type DescribeAggregationAuthorizationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of AggregationAuthorizations returned on each page. The
	// default is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregationAuthorizationsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizationsResponse
type DescribeAggregationAuthorizationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of authorizations granted to various aggregator accounts and
	// regions.
	AggregationAuthorizations []AggregationAuthorization `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregationAuthorizationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAggregationAuthorizations = "DescribeAggregationAuthorizations"

// DescribeAggregationAuthorizationsRequest returns a request value for making API operation for
// AWS Config.
//
// Returns a list of authorizations granted to various aggregator accounts and
// regions.
//
//    // Example sending a request using DescribeAggregationAuthorizationsRequest.
//    req := client.DescribeAggregationAuthorizationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations
func (c *Client) DescribeAggregationAuthorizationsRequest(input *DescribeAggregationAuthorizationsInput) DescribeAggregationAuthorizationsRequest {
	op := &aws.Operation{
		Name:       opDescribeAggregationAuthorizations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAggregationAuthorizationsInput{}
	}

	req := c.newRequest(op, input, &DescribeAggregationAuthorizationsOutput{})
	return DescribeAggregationAuthorizationsRequest{Request: req, Input: input, Copy: c.DescribeAggregationAuthorizationsRequest}
}

// DescribeAggregationAuthorizationsRequest is the request type for the
// DescribeAggregationAuthorizations API operation.
type DescribeAggregationAuthorizationsRequest struct {
	*aws.Request
	Input *DescribeAggregationAuthorizationsInput
	Copy  func(*DescribeAggregationAuthorizationsInput) DescribeAggregationAuthorizationsRequest
}

// Send marshals and sends the DescribeAggregationAuthorizations API request.
func (r DescribeAggregationAuthorizationsRequest) Send(ctx context.Context) (*DescribeAggregationAuthorizationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAggregationAuthorizationsResponse{
		DescribeAggregationAuthorizationsOutput: r.Request.Data.(*DescribeAggregationAuthorizationsOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAggregationAuthorizationsResponse is the response type for the
// DescribeAggregationAuthorizations API operation.
type DescribeAggregationAuthorizationsResponse struct {
	*DescribeAggregationAuthorizationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAggregationAuthorizations request.
func (r *DescribeAggregationAuthorizationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
