// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package comprehendiface provides an interface to enable mocking the Amazon Comprehend service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package comprehendiface

import (
	"github.com/aws/aws-sdk-go-v2/service/comprehend"
)

// ClientAPI provides an interface to enable mocking the
// comprehend.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Comprehend.
//    func myFunc(svc comprehendiface.ClientAPI) bool {
//        // Make svc.BatchDetectDominantLanguage request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := comprehend.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        comprehendiface.ClientPI
//    }
//    func (m *mockClientClient) BatchDetectDominantLanguage(input *comprehend.BatchDetectDominantLanguageInput) (*comprehend.BatchDetectDominantLanguageOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	BatchDetectDominantLanguageRequest(*comprehend.BatchDetectDominantLanguageInput) comprehend.BatchDetectDominantLanguageRequest

	BatchDetectEntitiesRequest(*comprehend.BatchDetectEntitiesInput) comprehend.BatchDetectEntitiesRequest

	BatchDetectKeyPhrasesRequest(*comprehend.BatchDetectKeyPhrasesInput) comprehend.BatchDetectKeyPhrasesRequest

	BatchDetectSentimentRequest(*comprehend.BatchDetectSentimentInput) comprehend.BatchDetectSentimentRequest

	BatchDetectSyntaxRequest(*comprehend.BatchDetectSyntaxInput) comprehend.BatchDetectSyntaxRequest

	CreateDocumentClassifierRequest(*comprehend.CreateDocumentClassifierInput) comprehend.CreateDocumentClassifierRequest

	CreateEntityRecognizerRequest(*comprehend.CreateEntityRecognizerInput) comprehend.CreateEntityRecognizerRequest

	DeleteDocumentClassifierRequest(*comprehend.DeleteDocumentClassifierInput) comprehend.DeleteDocumentClassifierRequest

	DeleteEntityRecognizerRequest(*comprehend.DeleteEntityRecognizerInput) comprehend.DeleteEntityRecognizerRequest

	DescribeDocumentClassificationJobRequest(*comprehend.DescribeDocumentClassificationJobInput) comprehend.DescribeDocumentClassificationJobRequest

	DescribeDocumentClassifierRequest(*comprehend.DescribeDocumentClassifierInput) comprehend.DescribeDocumentClassifierRequest

	DescribeDominantLanguageDetectionJobRequest(*comprehend.DescribeDominantLanguageDetectionJobInput) comprehend.DescribeDominantLanguageDetectionJobRequest

	DescribeEntitiesDetectionJobRequest(*comprehend.DescribeEntitiesDetectionJobInput) comprehend.DescribeEntitiesDetectionJobRequest

	DescribeEntityRecognizerRequest(*comprehend.DescribeEntityRecognizerInput) comprehend.DescribeEntityRecognizerRequest

	DescribeKeyPhrasesDetectionJobRequest(*comprehend.DescribeKeyPhrasesDetectionJobInput) comprehend.DescribeKeyPhrasesDetectionJobRequest

	DescribeSentimentDetectionJobRequest(*comprehend.DescribeSentimentDetectionJobInput) comprehend.DescribeSentimentDetectionJobRequest

	DescribeTopicsDetectionJobRequest(*comprehend.DescribeTopicsDetectionJobInput) comprehend.DescribeTopicsDetectionJobRequest

	DetectDominantLanguageRequest(*comprehend.DetectDominantLanguageInput) comprehend.DetectDominantLanguageRequest

	DetectEntitiesRequest(*comprehend.DetectEntitiesInput) comprehend.DetectEntitiesRequest

	DetectKeyPhrasesRequest(*comprehend.DetectKeyPhrasesInput) comprehend.DetectKeyPhrasesRequest

	DetectSentimentRequest(*comprehend.DetectSentimentInput) comprehend.DetectSentimentRequest

	DetectSyntaxRequest(*comprehend.DetectSyntaxInput) comprehend.DetectSyntaxRequest

	ListDocumentClassificationJobsRequest(*comprehend.ListDocumentClassificationJobsInput) comprehend.ListDocumentClassificationJobsRequest

	ListDocumentClassifiersRequest(*comprehend.ListDocumentClassifiersInput) comprehend.ListDocumentClassifiersRequest

	ListDominantLanguageDetectionJobsRequest(*comprehend.ListDominantLanguageDetectionJobsInput) comprehend.ListDominantLanguageDetectionJobsRequest

	ListEntitiesDetectionJobsRequest(*comprehend.ListEntitiesDetectionJobsInput) comprehend.ListEntitiesDetectionJobsRequest

	ListEntityRecognizersRequest(*comprehend.ListEntityRecognizersInput) comprehend.ListEntityRecognizersRequest

	ListKeyPhrasesDetectionJobsRequest(*comprehend.ListKeyPhrasesDetectionJobsInput) comprehend.ListKeyPhrasesDetectionJobsRequest

	ListSentimentDetectionJobsRequest(*comprehend.ListSentimentDetectionJobsInput) comprehend.ListSentimentDetectionJobsRequest

	ListTagsForResourceRequest(*comprehend.ListTagsForResourceInput) comprehend.ListTagsForResourceRequest

	ListTopicsDetectionJobsRequest(*comprehend.ListTopicsDetectionJobsInput) comprehend.ListTopicsDetectionJobsRequest

	StartDocumentClassificationJobRequest(*comprehend.StartDocumentClassificationJobInput) comprehend.StartDocumentClassificationJobRequest

	StartDominantLanguageDetectionJobRequest(*comprehend.StartDominantLanguageDetectionJobInput) comprehend.StartDominantLanguageDetectionJobRequest

	StartEntitiesDetectionJobRequest(*comprehend.StartEntitiesDetectionJobInput) comprehend.StartEntitiesDetectionJobRequest

	StartKeyPhrasesDetectionJobRequest(*comprehend.StartKeyPhrasesDetectionJobInput) comprehend.StartKeyPhrasesDetectionJobRequest

	StartSentimentDetectionJobRequest(*comprehend.StartSentimentDetectionJobInput) comprehend.StartSentimentDetectionJobRequest

	StartTopicsDetectionJobRequest(*comprehend.StartTopicsDetectionJobInput) comprehend.StartTopicsDetectionJobRequest

	StopDominantLanguageDetectionJobRequest(*comprehend.StopDominantLanguageDetectionJobInput) comprehend.StopDominantLanguageDetectionJobRequest

	StopEntitiesDetectionJobRequest(*comprehend.StopEntitiesDetectionJobInput) comprehend.StopEntitiesDetectionJobRequest

	StopKeyPhrasesDetectionJobRequest(*comprehend.StopKeyPhrasesDetectionJobInput) comprehend.StopKeyPhrasesDetectionJobRequest

	StopSentimentDetectionJobRequest(*comprehend.StopSentimentDetectionJobInput) comprehend.StopSentimentDetectionJobRequest

	StopTrainingDocumentClassifierRequest(*comprehend.StopTrainingDocumentClassifierInput) comprehend.StopTrainingDocumentClassifierRequest

	StopTrainingEntityRecognizerRequest(*comprehend.StopTrainingEntityRecognizerInput) comprehend.StopTrainingEntityRecognizerRequest

	TagResourceRequest(*comprehend.TagResourceInput) comprehend.TagResourceRequest

	UntagResourceRequest(*comprehend.UntagResourceInput) comprehend.UntagResourceRequest
}

var _ ClientAPI = (*comprehend.Client)(nil)
