// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobsRequest
type ListSentimentDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *SentimentDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSentimentDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSentimentDetectionJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSentimentDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobsResponse
type ListSentimentDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	SentimentDetectionJobPropertiesList []SentimentDetectionJobProperties `type:"list"`
}

// String returns the string representation
func (s ListSentimentDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSentimentDetectionJobs = "ListSentimentDetectionJobs"

// ListSentimentDetectionJobsRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Gets a list of sentiment detection jobs that you have submitted.
//
//    // Example sending a request using ListSentimentDetectionJobsRequest.
//    req := client.ListSentimentDetectionJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs
func (c *Client) ListSentimentDetectionJobsRequest(input *ListSentimentDetectionJobsInput) ListSentimentDetectionJobsRequest {
	op := &aws.Operation{
		Name:       opListSentimentDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSentimentDetectionJobsInput{}
	}

	req := c.newRequest(op, input, &ListSentimentDetectionJobsOutput{})
	return ListSentimentDetectionJobsRequest{Request: req, Input: input, Copy: c.ListSentimentDetectionJobsRequest}
}

// ListSentimentDetectionJobsRequest is the request type for the
// ListSentimentDetectionJobs API operation.
type ListSentimentDetectionJobsRequest struct {
	*aws.Request
	Input *ListSentimentDetectionJobsInput
	Copy  func(*ListSentimentDetectionJobsInput) ListSentimentDetectionJobsRequest
}

// Send marshals and sends the ListSentimentDetectionJobs API request.
func (r ListSentimentDetectionJobsRequest) Send(ctx context.Context) (*ListSentimentDetectionJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSentimentDetectionJobsResponse{
		ListSentimentDetectionJobsOutput: r.Request.Data.(*ListSentimentDetectionJobsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSentimentDetectionJobsRequestPaginator returns a paginator for ListSentimentDetectionJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSentimentDetectionJobsRequest(input)
//   p := comprehend.NewListSentimentDetectionJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSentimentDetectionJobsPaginator(req ListSentimentDetectionJobsRequest) ListSentimentDetectionJobsPaginator {
	return ListSentimentDetectionJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSentimentDetectionJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSentimentDetectionJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSentimentDetectionJobsPaginator struct {
	aws.Pager
}

func (p *ListSentimentDetectionJobsPaginator) CurrentPage() *ListSentimentDetectionJobsOutput {
	return p.Pager.CurrentPage().(*ListSentimentDetectionJobsOutput)
}

// ListSentimentDetectionJobsResponse is the response type for the
// ListSentimentDetectionJobs API operation.
type ListSentimentDetectionJobsResponse struct {
	*ListSentimentDetectionJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSentimentDetectionJobs request.
func (r *ListSentimentDetectionJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
