// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfigurationRequest
type SetRiskConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The account takeover risk configuration.
	AccountTakeoverRiskConfiguration *AccountTakeoverRiskConfigurationType `type:"structure"`

	// The app client ID. If ClientId is null, then the risk configuration is mapped
	// to userPoolId. When the client ID is null, the same risk configuration is
	// applied to all the clients in the userPool.
	//
	// Otherwise, ClientId is mapped to the client. When the client ID is not null,
	// the user pool configuration is overridden and the risk configuration for
	// the client is used instead.
	ClientId *string `min:"1" type:"string"`

	// The compromised credentials risk configuration.
	CompromisedCredentialsRiskConfiguration *CompromisedCredentialsRiskConfigurationType `type:"structure"`

	// The configuration to override the risk decision.
	RiskExceptionConfiguration *RiskExceptionConfigurationType `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetRiskConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetRiskConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetRiskConfigurationInput"}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientId", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.AccountTakeoverRiskConfiguration != nil {
		if err := s.AccountTakeoverRiskConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AccountTakeoverRiskConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.CompromisedCredentialsRiskConfiguration != nil {
		if err := s.CompromisedCredentialsRiskConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CompromisedCredentialsRiskConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfigurationResponse
type SetRiskConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The risk configuration.
	//
	// RiskConfiguration is a required field
	RiskConfiguration *RiskConfigurationType `type:"structure" required:"true"`
}

// String returns the string representation
func (s SetRiskConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetRiskConfiguration = "SetRiskConfiguration"

// SetRiskConfigurationRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Configures actions on detected risks. To delete the risk configuration for
// UserPoolId or ClientId, pass null values for all four configuration types.
//
// To enable Amazon Cognito advanced security features, update the user pool
// to include the UserPoolAddOns keyAdvancedSecurityMode.
//
// See .
//
//    // Example sending a request using SetRiskConfigurationRequest.
//    req := client.SetRiskConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration
func (c *Client) SetRiskConfigurationRequest(input *SetRiskConfigurationInput) SetRiskConfigurationRequest {
	op := &aws.Operation{
		Name:       opSetRiskConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetRiskConfigurationInput{}
	}

	req := c.newRequest(op, input, &SetRiskConfigurationOutput{})
	return SetRiskConfigurationRequest{Request: req, Input: input, Copy: c.SetRiskConfigurationRequest}
}

// SetRiskConfigurationRequest is the request type for the
// SetRiskConfiguration API operation.
type SetRiskConfigurationRequest struct {
	*aws.Request
	Input *SetRiskConfigurationInput
	Copy  func(*SetRiskConfigurationInput) SetRiskConfigurationRequest
}

// Send marshals and sends the SetRiskConfiguration API request.
func (r SetRiskConfigurationRequest) Send(ctx context.Context) (*SetRiskConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetRiskConfigurationResponse{
		SetRiskConfigurationOutput: r.Request.Data.(*SetRiskConfigurationOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetRiskConfigurationResponse is the response type for the
// SetRiskConfiguration API operation.
type SetRiskConfigurationResponse struct {
	*SetRiskConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetRiskConfiguration request.
func (r *SetRiskConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
