// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to disable any user as an administrator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUserRequest
type AdminDisableUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to disable the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you wish to disable.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminDisableUserInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDisableUserInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdminDisableUserInput"}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response received from the server to disable the user as an
// administrator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUserResponse
type AdminDisableUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminDisableUserOutput) String() string {
	return awsutil.Prettify(s)
}

const opAdminDisableUser = "AdminDisableUser"

// AdminDisableUserRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Disables the specified user as an administrator. Works on any user.
//
// Requires developer credentials.
//
//    // Example sending a request using AdminDisableUserRequest.
//    req := client.AdminDisableUserRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser
func (c *Client) AdminDisableUserRequest(input *AdminDisableUserInput) AdminDisableUserRequest {
	op := &aws.Operation{
		Name:       opAdminDisableUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDisableUserInput{}
	}

	req := c.newRequest(op, input, &AdminDisableUserOutput{})
	return AdminDisableUserRequest{Request: req, Input: input, Copy: c.AdminDisableUserRequest}
}

// AdminDisableUserRequest is the request type for the
// AdminDisableUser API operation.
type AdminDisableUserRequest struct {
	*aws.Request
	Input *AdminDisableUserInput
	Copy  func(*AdminDisableUserInput) AdminDisableUserRequest
}

// Send marshals and sends the AdminDisableUser API request.
func (r AdminDisableUserRequest) Send(ctx context.Context) (*AdminDisableUserResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AdminDisableUserResponse{
		AdminDisableUserOutput: r.Request.Data.(*AdminDisableUserOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AdminDisableUserResponse is the response type for the
// AdminDisableUser API operation.
type AdminDisableUserResponse struct {
	*AdminDisableUserOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AdminDisableUser request.
func (r *AdminDisableUserResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
