// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to confirm user registration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUpRequest
type AdminConfirmSignUpInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for which you want to confirm user registration.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name for which you want to confirm user registration.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminConfirmSignUpInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminConfirmSignUpInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdminConfirmSignUpInput"}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server for the request to confirm registration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUpResponse
type AdminConfirmSignUpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminConfirmSignUpOutput) String() string {
	return awsutil.Prettify(s)
}

const opAdminConfirmSignUp = "AdminConfirmSignUp"

// AdminConfirmSignUpRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Confirms user registration as an admin without using a confirmation code.
// Works on any user.
//
// Requires developer credentials.
//
//    // Example sending a request using AdminConfirmSignUpRequest.
//    req := client.AdminConfirmSignUpRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp
func (c *Client) AdminConfirmSignUpRequest(input *AdminConfirmSignUpInput) AdminConfirmSignUpRequest {
	op := &aws.Operation{
		Name:       opAdminConfirmSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminConfirmSignUpInput{}
	}

	req := c.newRequest(op, input, &AdminConfirmSignUpOutput{})
	return AdminConfirmSignUpRequest{Request: req, Input: input, Copy: c.AdminConfirmSignUpRequest}
}

// AdminConfirmSignUpRequest is the request type for the
// AdminConfirmSignUp API operation.
type AdminConfirmSignUpRequest struct {
	*aws.Request
	Input *AdminConfirmSignUpInput
	Copy  func(*AdminConfirmSignUpInput) AdminConfirmSignUpRequest
}

// Send marshals and sends the AdminConfirmSignUp API request.
func (r AdminConfirmSignUpRequest) Send(ctx context.Context) (*AdminConfirmSignUpResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AdminConfirmSignUpResponse{
		AdminConfirmSignUpOutput: r.Request.Data.(*AdminConfirmSignUpOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AdminConfirmSignUpResponse is the response type for the
// AdminConfirmSignUp API operation.
type AdminConfirmSignUpResponse struct {
	*AdminConfirmSignUpOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AdminConfirmSignUp request.
func (r *AdminConfirmSignUpResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
