// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a ListDeployments operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentsInput
type ListDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the IAM user or
	// AWS account.
	//
	// If applicationName is specified, then deploymentGroupName must be specified.
	// If it is not specified, then deploymentGroupName must not be specified.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// A time range (start and end) for returning a subset of the list of deployments.
	CreateTimeRange *TimeRange `locationName:"createTimeRange" type:"structure"`

	// The name of a deployment group for the specified application.
	//
	// If deploymentGroupName is specified, then applicationName must be specified.
	// If it is not specified, then applicationName must not be specified.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// A subset of deployments to list by status:
	//
	//    * Created: Include created deployments in the resulting list.
	//
	//    * Queued: Include queued deployments in the resulting list.
	//
	//    * In Progress: Include in-progress deployments in the resulting list.
	//
	//    * Succeeded: Include successful deployments in the resulting list.
	//
	//    * Failed: Include failed deployments in the resulting list.
	//
	//    * Stopped: Include stopped deployments in the resulting list.
	IncludeOnlyStatuses []DeploymentStatus `locationName:"includeOnlyStatuses" type:"list"`

	// An identifier returned from the previous list deployments call. It can be
	// used to return the next set of deployments in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDeploymentsInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a ListDeployments operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentsOutput
type ListDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of deployment IDs.
	Deployments []string `locationName:"deployments" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list deployments call to return the next set
	// of deployments in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Lists the deployments in a deployment group for an application registered
// with the IAM user or AWS account.
//
//    // Example sending a request using ListDeploymentsRequest.
//    req := client.ListDeploymentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments
func (c *Client) ListDeploymentsRequest(input *ListDeploymentsInput) ListDeploymentsRequest {
	op := &aws.Operation{
		Name:       opListDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	req := c.newRequest(op, input, &ListDeploymentsOutput{})
	return ListDeploymentsRequest{Request: req, Input: input, Copy: c.ListDeploymentsRequest}
}

// ListDeploymentsRequest is the request type for the
// ListDeployments API operation.
type ListDeploymentsRequest struct {
	*aws.Request
	Input *ListDeploymentsInput
	Copy  func(*ListDeploymentsInput) ListDeploymentsRequest
}

// Send marshals and sends the ListDeployments API request.
func (r ListDeploymentsRequest) Send(ctx context.Context) (*ListDeploymentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDeploymentsResponse{
		ListDeploymentsOutput: r.Request.Data.(*ListDeploymentsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDeploymentsRequestPaginator returns a paginator for ListDeployments.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDeploymentsRequest(input)
//   p := codedeploy.NewListDeploymentsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDeploymentsPaginator(req ListDeploymentsRequest) ListDeploymentsPaginator {
	return ListDeploymentsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDeploymentsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDeploymentsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDeploymentsPaginator struct {
	aws.Pager
}

func (p *ListDeploymentsPaginator) CurrentPage() *ListDeploymentsOutput {
	return p.Pager.CurrentPage().(*ListDeploymentsOutput)
}

// ListDeploymentsResponse is the response type for the
// ListDeployments API operation.
type ListDeploymentsResponse struct {
	*ListDeploymentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDeployments request.
func (r *ListDeploymentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
