// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteSubscriptionFilterRequest
type DeleteSubscriptionFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the subscription filter.
	//
	// FilterName is a required field
	FilterName *string `locationName:"filterName" min:"1" type:"string" required:"true"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSubscriptionFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriptionFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSubscriptionFilterInput"}

	if s.FilterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterName"))
	}
	if s.FilterName != nil && len(*s.FilterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterName", 1))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteSubscriptionFilterOutput
type DeleteSubscriptionFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSubscriptionFilterOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSubscriptionFilter = "DeleteSubscriptionFilter"

// DeleteSubscriptionFilterRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Deletes the specified subscription filter.
//
//    // Example sending a request using DeleteSubscriptionFilterRequest.
//    req := client.DeleteSubscriptionFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteSubscriptionFilter
func (c *Client) DeleteSubscriptionFilterRequest(input *DeleteSubscriptionFilterInput) DeleteSubscriptionFilterRequest {
	op := &aws.Operation{
		Name:       opDeleteSubscriptionFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubscriptionFilterInput{}
	}

	req := c.newRequest(op, input, &DeleteSubscriptionFilterOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteSubscriptionFilterRequest{Request: req, Input: input, Copy: c.DeleteSubscriptionFilterRequest}
}

// DeleteSubscriptionFilterRequest is the request type for the
// DeleteSubscriptionFilter API operation.
type DeleteSubscriptionFilterRequest struct {
	*aws.Request
	Input *DeleteSubscriptionFilterInput
	Copy  func(*DeleteSubscriptionFilterInput) DeleteSubscriptionFilterRequest
}

// Send marshals and sends the DeleteSubscriptionFilter API request.
func (r DeleteSubscriptionFilterRequest) Send(ctx context.Context) (*DeleteSubscriptionFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSubscriptionFilterResponse{
		DeleteSubscriptionFilterOutput: r.Request.Data.(*DeleteSubscriptionFilterOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSubscriptionFilterResponse is the response type for the
// DeleteSubscriptionFilter API operation.
type DeleteSubscriptionFilterResponse struct {
	*DeleteSubscriptionFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSubscriptionFilter request.
func (r *DeleteSubscriptionFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
