// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudtrail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request that specifies the name of a trail to delete.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrailRequest
type DeleteTrailInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail to be deleted. The
	// format of a trail ARN is: arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrailInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrailInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTrailInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrailResponse
type DeleteTrailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTrailOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTrail = "DeleteTrail"

// DeleteTrailRequest returns a request value for making API operation for
// AWS CloudTrail.
//
// Deletes a trail. This operation must be called from the region in which the
// trail was created. DeleteTrail cannot be called on the shadow trails (replicated
// trails in other regions) of a trail that is enabled in all regions.
//
//    // Example sending a request using DeleteTrailRequest.
//    req := client.DeleteTrailRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail
func (c *Client) DeleteTrailRequest(input *DeleteTrailInput) DeleteTrailRequest {
	op := &aws.Operation{
		Name:       opDeleteTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrailInput{}
	}

	req := c.newRequest(op, input, &DeleteTrailOutput{})
	return DeleteTrailRequest{Request: req, Input: input, Copy: c.DeleteTrailRequest}
}

// DeleteTrailRequest is the request type for the
// DeleteTrail API operation.
type DeleteTrailRequest struct {
	*aws.Request
	Input *DeleteTrailInput
	Copy  func(*DeleteTrailInput) DeleteTrailRequest
}

// Send marshals and sends the DeleteTrail API request.
func (r DeleteTrailRequest) Send(ctx context.Context) (*DeleteTrailResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTrailResponse{
		DeleteTrailOutput: r.Request.Data.(*DeleteTrailOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTrailResponse is the response type for the
// DeleteTrail API operation.
type DeleteTrailResponse struct {
	*DeleteTrailOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTrail request.
func (r *DeleteTrailResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
