// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberOrderRequest
type GetPhoneNumberOrderInput struct {
	_ struct{} `type:"structure"`

	// The ID for the phone number order.
	//
	// PhoneNumberOrderId is a required field
	PhoneNumberOrderId *string `location:"uri" locationName:"phoneNumberOrderId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPhoneNumberOrderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPhoneNumberOrderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPhoneNumberOrderInput"}

	if s.PhoneNumberOrderId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PhoneNumberOrderId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPhoneNumberOrderInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.PhoneNumberOrderId != nil {
		v := *s.PhoneNumberOrderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "phoneNumberOrderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberOrderResponse
type GetPhoneNumberOrderOutput struct {
	_ struct{} `type:"structure"`

	// The phone number order details.
	PhoneNumberOrder *PhoneNumberOrder `type:"structure"`
}

// String returns the string representation
func (s GetPhoneNumberOrderOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPhoneNumberOrderOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PhoneNumberOrder != nil {
		v := s.PhoneNumberOrder

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PhoneNumberOrder", v, metadata)
	}
	return nil
}

const opGetPhoneNumberOrder = "GetPhoneNumberOrder"

// GetPhoneNumberOrderRequest returns a request value for making API operation for
// Amazon Chime.
//
// Retrieves details for the specified phone number order, such as order creation
// timestamp, phone numbers in E.164 format, product type, and order status.
//
//    // Example sending a request using GetPhoneNumberOrderRequest.
//    req := client.GetPhoneNumberOrderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberOrder
func (c *Client) GetPhoneNumberOrderRequest(input *GetPhoneNumberOrderInput) GetPhoneNumberOrderRequest {
	op := &aws.Operation{
		Name:       opGetPhoneNumberOrder,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number-orders/{phoneNumberOrderId}",
	}

	if input == nil {
		input = &GetPhoneNumberOrderInput{}
	}

	req := c.newRequest(op, input, &GetPhoneNumberOrderOutput{})
	return GetPhoneNumberOrderRequest{Request: req, Input: input, Copy: c.GetPhoneNumberOrderRequest}
}

// GetPhoneNumberOrderRequest is the request type for the
// GetPhoneNumberOrder API operation.
type GetPhoneNumberOrderRequest struct {
	*aws.Request
	Input *GetPhoneNumberOrderInput
	Copy  func(*GetPhoneNumberOrderInput) GetPhoneNumberOrderRequest
}

// Send marshals and sends the GetPhoneNumberOrder API request.
func (r GetPhoneNumberOrderRequest) Send(ctx context.Context) (*GetPhoneNumberOrderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPhoneNumberOrderResponse{
		GetPhoneNumberOrderOutput: r.Request.Data.(*GetPhoneNumberOrderOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPhoneNumberOrderResponse is the response type for the
// GetPhoneNumberOrder API operation.
type GetPhoneNumberOrderResponse struct {
	*GetPhoneNumberOrderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPhoneNumberOrder request.
func (r *GetPhoneNumberOrderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
