// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package batch

import (
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// An object representing an AWS Batch array job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ArrayProperties
type ArrayProperties struct {
	_ struct{} `type:"structure"`

	// The size of the array job.
	Size *int64 `locationName:"size" type:"integer"`
}

// String returns the string representation
func (s ArrayProperties) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ArrayProperties) MarshalFields(e protocol.FieldEncoder) error {
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "size", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing the array properties of a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ArrayPropertiesDetail
type ArrayPropertiesDetail struct {
	_ struct{} `type:"structure"`

	// The job index within the array that is associated with this job. This parameter
	// is returned for array job children.
	Index *int64 `locationName:"index" type:"integer"`

	// The size of the array job. This parameter is returned for parent array jobs.
	Size *int64 `locationName:"size" type:"integer"`

	// A summary of the number of array job children in each available job status.
	// This parameter is returned for parent array jobs.
	StatusSummary map[string]int64 `locationName:"statusSummary" type:"map"`
}

// String returns the string representation
func (s ArrayPropertiesDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ArrayPropertiesDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.Index != nil {
		v := *s.Index

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "index", protocol.Int64Value(v), metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "size", protocol.Int64Value(v), metadata)
	}
	if len(s.StatusSummary) > 0 {
		v := s.StatusSummary

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "statusSummary", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Int64Value(v1))
		}
		ms0.End()

	}
	return nil
}

// An object representing the array properties of a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ArrayPropertiesSummary
type ArrayPropertiesSummary struct {
	_ struct{} `type:"structure"`

	// The job index within the array that is associated with this job. This parameter
	// is returned for children of array jobs.
	Index *int64 `locationName:"index" type:"integer"`

	// The size of the array job. This parameter is returned for parent array jobs.
	Size *int64 `locationName:"size" type:"integer"`
}

// String returns the string representation
func (s ArrayPropertiesSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ArrayPropertiesSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Index != nil {
		v := *s.Index

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "index", protocol.Int64Value(v), metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "size", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing the details of a container that is part of a job attempt.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/AttemptContainerDetail
type AttemptContainerDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon ECS container instance that
	// hosts the job attempt.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The exit code for the job attempt. A non-zero exit code is considered a failure.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The name of the CloudWatch Logs log stream associated with the container.
	// The log group for AWS Batch jobs is /aws/batch/job. Each container attempt
	// receives a log stream name when they reach the RUNNING status.
	LogStreamName *string `locationName:"logStreamName" type:"string"`

	// The network interfaces associated with the job attempt.
	NetworkInterfaces []NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// A short (255 max characters) human-readable string to provide additional
	// details about a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon ECS task that is associated
	// with the job attempt. Each container attempt receives a task ARN when they
	// reach the STARTING status.
	TaskArn *string `locationName:"taskArn" type:"string"`
}

// String returns the string representation
func (s AttemptContainerDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttemptContainerDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContainerInstanceArn != nil {
		v := *s.ContainerInstanceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "containerInstanceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExitCode != nil {
		v := *s.ExitCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "exitCode", protocol.Int64Value(v), metadata)
	}
	if s.LogStreamName != nil {
		v := *s.LogStreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "logStreamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.NetworkInterfaces) > 0 {
		v := s.NetworkInterfaces

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "networkInterfaces", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Reason != nil {
		v := *s.Reason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TaskArn != nil {
		v := *s.TaskArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing a job attempt.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/AttemptDetail
type AttemptDetail struct {
	_ struct{} `type:"structure"`

	// Details about the container in this job attempt.
	Container *AttemptContainerDetail `locationName:"container" type:"structure"`

	// The Unix timestamp (in seconds and milliseconds) for when the attempt was
	// started (when the attempt transitioned from the STARTING state to the RUNNING
	// state).
	StartedAt *int64 `locationName:"startedAt" type:"long"`

	// A short, human-readable string to provide additional details about the current
	// status of the job attempt.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The Unix timestamp (in seconds and milliseconds) for when the attempt was
	// stopped (when the attempt transitioned from the RUNNING state to a terminal
	// state, such as SUCCEEDED or FAILED).
	StoppedAt *int64 `locationName:"stoppedAt" type:"long"`
}

// String returns the string representation
func (s AttemptDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttemptDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.Container != nil {
		v := s.Container

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "container", v, metadata)
	}
	if s.StartedAt != nil {
		v := *s.StartedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startedAt", protocol.Int64Value(v), metadata)
	}
	if s.StatusReason != nil {
		v := *s.StatusReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StoppedAt != nil {
		v := *s.StoppedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stoppedAt", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing an AWS Batch compute environment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ComputeEnvironmentDetail
type ComputeEnvironmentDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	//
	// ComputeEnvironmentArn is a required field
	ComputeEnvironmentArn *string `locationName:"computeEnvironmentArn" type:"string" required:"true"`

	// The name of the compute environment.
	//
	// ComputeEnvironmentName is a required field
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string" required:"true"`

	// The compute resources defined for the compute environment.
	ComputeResources *ComputeResource `locationName:"computeResources" type:"structure"`

	// The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used
	// by the compute environment.
	//
	// EcsClusterArn is a required field
	EcsClusterArn *string `locationName:"ecsClusterArn" type:"string" required:"true"`

	// The service role associated with the compute environment that allows AWS
	// Batch to make calls to AWS API operations on your behalf.
	ServiceRole *string `locationName:"serviceRole" type:"string"`

	// The state of the compute environment. The valid values are ENABLED or DISABLED.
	//
	// If the state is ENABLED, then the AWS Batch scheduler can attempt to place
	// jobs from an associated job queue on the compute resources within the environment.
	// If the compute environment is managed, then it can scale its instances out
	// or in automatically, based on the job queue demand.
	//
	// If the state is DISABLED, then the AWS Batch scheduler does not attempt to
	// place jobs within the environment. Jobs in a STARTING or RUNNING state continue
	// to progress normally. Managed compute environments in the DISABLED state
	// do not scale out. However, they scale in to minvCpus value after instances
	// become idle.
	State CEState `locationName:"state" type:"string" enum:"true"`

	// The current status of the compute environment (for example, CREATING or VALID).
	Status CEStatus `locationName:"status" type:"string" enum:"true"`

	// A short, human-readable string to provide additional details about the current
	// status of the compute environment.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The type of the compute environment.
	Type CEType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ComputeEnvironmentDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ComputeEnvironmentDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComputeEnvironmentArn != nil {
		v := *s.ComputeEnvironmentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeEnvironmentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ComputeEnvironmentName != nil {
		v := *s.ComputeEnvironmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeEnvironmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ComputeResources != nil {
		v := s.ComputeResources

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "computeResources", v, metadata)
	}
	if s.EcsClusterArn != nil {
		v := *s.EcsClusterArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ecsClusterArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceRole != nil {
		v := *s.ServiceRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusReason != nil {
		v := *s.StatusReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The order in which compute environments are tried for job placement within
// a queue. Compute environments are tried in ascending order. For example,
// if two compute environments are associated with a job queue, the compute
// environment with a lower order integer value is tried for job placement first.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ComputeEnvironmentOrder
type ComputeEnvironmentOrder struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	//
	// ComputeEnvironment is a required field
	ComputeEnvironment *string `locationName:"computeEnvironment" type:"string" required:"true"`

	// The order of the compute environment.
	//
	// Order is a required field
	Order *int64 `locationName:"order" type:"integer" required:"true"`
}

// String returns the string representation
func (s ComputeEnvironmentOrder) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeEnvironmentOrder) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ComputeEnvironmentOrder"}

	if s.ComputeEnvironment == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComputeEnvironment"))
	}

	if s.Order == nil {
		invalidParams.Add(aws.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ComputeEnvironmentOrder) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComputeEnvironment != nil {
		v := *s.ComputeEnvironment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeEnvironment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Order != nil {
		v := *s.Order

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "order", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing an AWS Batch compute resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ComputeResource
type ComputeResource struct {
	_ struct{} `type:"structure"`

	// The maximum percentage that a Spot Instance price can be when compared with
	// the On-Demand price for that instance type before instances are launched.
	// For example, if your maximum percentage is 20%, then the Spot price must
	// be below 20% of the current On-Demand price for that EC2 instance. You always
	// pay the lowest (market) price and never more than your maximum percentage.
	// If you leave this field empty, the default value is 100% of the On-Demand
	// price.
	BidPercentage *int64 `locationName:"bidPercentage" type:"integer"`

	// The desired number of EC2 vCPUS in the compute environment.
	DesiredvCpus *int64 `locationName:"desiredvCpus" type:"integer"`

	// The EC2 key pair that is used for instances launched in the compute environment.
	Ec2KeyPair *string `locationName:"ec2KeyPair" type:"string"`

	// The Amazon Machine Image (AMI) ID used for instances launched in the compute
	// environment.
	ImageId *string `locationName:"imageId" type:"string"`

	// The Amazon ECS instance profile applied to Amazon EC2 instances in a compute
	// environment. You can specify the short name or full Amazon Resource Name
	// (ARN) of an instance profile. For example, ecsInstanceRole or arn:aws:iam::<aws_account_id>:instance-profile/ecsInstanceRole
	// . For more information, see Amazon ECS Instance Role (https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html)
	// in the AWS Batch User Guide.
	//
	// InstanceRole is a required field
	InstanceRole *string `locationName:"instanceRole" type:"string" required:"true"`

	// The instances types that may be launched. You can specify instance families
	// to launch any instance type within those families (for example, c4 or p3),
	// or you can specify specific sizes within a family (such as c4.8xlarge). You
	// can also choose optimal to pick instance types (from the C, M, and R instance
	// families) on the fly that match the demand of your job queues.
	//
	// InstanceTypes is a required field
	InstanceTypes []string `locationName:"instanceTypes" type:"list" required:"true"`

	// The launch template to use for your compute resources. Any other compute
	// resource parameters that you specify in a CreateComputeEnvironment API operation
	// override the same parameters in the launch template. You must specify either
	// the launch template ID or launch template name in the request, but not both.
	// For more information, see Launch Template Support (https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html)
	// in the AWS Batch User Guide.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The maximum number of EC2 vCPUs that an environment can reach.
	//
	// MaxvCpus is a required field
	MaxvCpus *int64 `locationName:"maxvCpus" type:"integer" required:"true"`

	// The minimum number of EC2 vCPUs that an environment should maintain (even
	// if the compute environment is DISABLED).
	//
	// MinvCpus is a required field
	MinvCpus *int64 `locationName:"minvCpus" type:"integer" required:"true"`

	// The Amazon EC2 placement group to associate with your compute resources.
	// If you intend to submit multi-node parallel jobs to your compute environment,
	// you should consider creating a cluster placement group and associate it with
	// your compute resources. This keeps your multi-node parallel job on a logical
	// grouping of instances within a single Availability Zone with high network
	// flow potential. For more information, see Placement Groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	PlacementGroup *string `locationName:"placementGroup" type:"string"`

	// The EC2 security group that is associated with instances launched in the
	// compute environment.
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied
	// to a SPOT compute environment. For more information, see Amazon EC2 Spot
	// Fleet Role (https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html)
	// in the AWS Batch User Guide.
	SpotIamFleetRole *string `locationName:"spotIamFleetRole" type:"string"`

	// The VPC subnets into which the compute resources are launched.
	//
	// Subnets is a required field
	Subnets []string `locationName:"subnets" type:"list" required:"true"`

	// Key-value pair tags to be applied to resources that are launched in the compute
	// environment. For AWS Batch, these take the form of "String1": "String2",
	// where String1 is the tag key and String2 is the tag value—for example,
	// { "Name": "AWS Batch Instance - C4OnDemand" }.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The type of compute environment: EC2 or SPOT.
	//
	// Type is a required field
	Type CRType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ComputeResource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeResource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ComputeResource"}

	if s.InstanceRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceRole"))
	}

	if s.InstanceTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceTypes"))
	}

	if s.MaxvCpus == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxvCpus"))
	}

	if s.MinvCpus == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinvCpus"))
	}

	if s.Subnets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subnets"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ComputeResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.BidPercentage != nil {
		v := *s.BidPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bidPercentage", protocol.Int64Value(v), metadata)
	}
	if s.DesiredvCpus != nil {
		v := *s.DesiredvCpus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "desiredvCpus", protocol.Int64Value(v), metadata)
	}
	if s.Ec2KeyPair != nil {
		v := *s.Ec2KeyPair

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ec2KeyPair", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageId != nil {
		v := *s.ImageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceRole != nil {
		v := *s.InstanceRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.InstanceTypes) > 0 {
		v := s.InstanceTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "instanceTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.LaunchTemplate != nil {
		v := s.LaunchTemplate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "launchTemplate", v, metadata)
	}
	if s.MaxvCpus != nil {
		v := *s.MaxvCpus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxvCpus", protocol.Int64Value(v), metadata)
	}
	if s.MinvCpus != nil {
		v := *s.MinvCpus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minvCpus", protocol.Int64Value(v), metadata)
	}
	if s.PlacementGroup != nil {
		v := *s.PlacementGroup

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "placementGroup", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SecurityGroupIds) > 0 {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SpotIamFleetRole != nil {
		v := *s.SpotIamFleetRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "spotIamFleetRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Subnets) > 0 {
		v := s.Subnets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object representing the attributes of a compute environment that can be
// updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ComputeResourceUpdate
type ComputeResourceUpdate struct {
	_ struct{} `type:"structure"`

	// The desired number of EC2 vCPUS in the compute environment.
	DesiredvCpus *int64 `locationName:"desiredvCpus" type:"integer"`

	// The maximum number of EC2 vCPUs that an environment can reach.
	MaxvCpus *int64 `locationName:"maxvCpus" type:"integer"`

	// The minimum number of EC2 vCPUs that an environment should maintain.
	MinvCpus *int64 `locationName:"minvCpus" type:"integer"`
}

// String returns the string representation
func (s ComputeResourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ComputeResourceUpdate) MarshalFields(e protocol.FieldEncoder) error {
	if s.DesiredvCpus != nil {
		v := *s.DesiredvCpus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "desiredvCpus", protocol.Int64Value(v), metadata)
	}
	if s.MaxvCpus != nil {
		v := *s.MaxvCpus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxvCpus", protocol.Int64Value(v), metadata)
	}
	if s.MinvCpus != nil {
		v := *s.MinvCpus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minvCpus", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing the details of a container that is part of a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ContainerDetail
type ContainerDetail struct {
	_ struct{} `type:"structure"`

	// The command that is passed to the container.
	Command []string `locationName:"command" type:"list"`

	// The Amazon Resource Name (ARN) of the container instance on which the container
	// is running.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The environment variables to pass to a container.
	//
	// Environment variables must not start with AWS_BATCH; this naming convention
	// is reserved for variables that are set by the AWS Batch service.
	Environment []KeyValuePair `locationName:"environment" type:"list"`

	// The exit code to return upon completion.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The image used to start the container.
	Image *string `locationName:"image" type:"string"`

	// The instance type of the underlying host infrastructure of a multi-node parallel
	// job.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The Amazon Resource Name (ARN) associated with the job upon execution.
	JobRoleArn *string `locationName:"jobRoleArn" type:"string"`

	// The name of the CloudWatch Logs log stream associated with the container.
	// The log group for AWS Batch jobs is /aws/batch/job. Each container attempt
	// receives a log stream name when they reach the RUNNING status.
	LogStreamName *string `locationName:"logStreamName" type:"string"`

	// The number of MiB of memory reserved for the job.
	Memory *int64 `locationName:"memory" type:"integer"`

	// The mount points for data volumes in your container.
	MountPoints []MountPoint `locationName:"mountPoints" type:"list"`

	// The network interfaces associated with the job.
	NetworkInterfaces []NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// When this parameter is true, the container is given elevated privileges on
	// the host container instance (similar to the root user).
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system.
	ReadonlyRootFilesystem *bool `locationName:"readonlyRootFilesystem" type:"boolean"`

	// A short (255 max characters) human-readable string to provide additional
	// details about a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`

	// The type and amount of a resource to assign to a container. Currently, the
	// only supported resource is GPU.
	ResourceRequirements []ResourceRequirement `locationName:"resourceRequirements" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon ECS task that is associated
	// with the container job. Each container attempt receives a task ARN when they
	// reach the STARTING status.
	TaskArn *string `locationName:"taskArn" type:"string"`

	// A list of ulimit values to set in the container.
	Ulimits []Ulimit `locationName:"ulimits" type:"list"`

	// The user name to use inside the container.
	User *string `locationName:"user" type:"string"`

	// The number of VCPUs allocated for the job.
	Vcpus *int64 `locationName:"vcpus" type:"integer"`

	// A list of volumes associated with the job.
	Volumes []Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation
func (s ContainerDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContainerDetail) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Command) > 0 {
		v := s.Command

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "command", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ContainerInstanceArn != nil {
		v := *s.ContainerInstanceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "containerInstanceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Environment) > 0 {
		v := s.Environment

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "environment", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ExitCode != nil {
		v := *s.ExitCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "exitCode", protocol.Int64Value(v), metadata)
	}
	if s.Image != nil {
		v := *s.Image

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "image", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceType != nil {
		v := *s.InstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobRoleArn != nil {
		v := *s.JobRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LogStreamName != nil {
		v := *s.LogStreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "logStreamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Memory != nil {
		v := *s.Memory

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "memory", protocol.Int64Value(v), metadata)
	}
	if len(s.MountPoints) > 0 {
		v := s.MountPoints

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "mountPoints", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkInterfaces) > 0 {
		v := s.NetworkInterfaces

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "networkInterfaces", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Privileged != nil {
		v := *s.Privileged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privileged", protocol.BoolValue(v), metadata)
	}
	if s.ReadonlyRootFilesystem != nil {
		v := *s.ReadonlyRootFilesystem

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "readonlyRootFilesystem", protocol.BoolValue(v), metadata)
	}
	if s.Reason != nil {
		v := *s.Reason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceRequirements) > 0 {
		v := s.ResourceRequirements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resourceRequirements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TaskArn != nil {
		v := *s.TaskArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Ulimits) > 0 {
		v := s.Ulimits

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ulimits", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.User != nil {
		v := *s.User

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "user", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Vcpus != nil {
		v := *s.Vcpus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vcpus", protocol.Int64Value(v), metadata)
	}
	if len(s.Volumes) > 0 {
		v := s.Volumes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "volumes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The overrides that should be sent to a container.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ContainerOverrides
type ContainerOverrides struct {
	_ struct{} `type:"structure"`

	// The command to send to the container that overrides the default command from
	// the Docker image or the job definition.
	Command []string `locationName:"command" type:"list"`

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override
	// the existing environment variables from the Docker image or the job definition.
	//
	// Environment variables must not start with AWS_BATCH; this naming convention
	// is reserved for variables that are set by the AWS Batch service.
	Environment []KeyValuePair `locationName:"environment" type:"list"`

	// The instance type to use for a multi-node parallel job. This parameter is
	// not valid for single-node container jobs.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The number of MiB of memory reserved for the job. This value overrides the
	// value set in the job definition.
	Memory *int64 `locationName:"memory" type:"integer"`

	// The type and amount of a resource to assign to a container. This value overrides
	// the value set in the job definition. Currently, the only supported resource
	// is GPU.
	ResourceRequirements []ResourceRequirement `locationName:"resourceRequirements" type:"list"`

	// The number of vCPUs to reserve for the container. This value overrides the
	// value set in the job definition.
	Vcpus *int64 `locationName:"vcpus" type:"integer"`
}

// String returns the string representation
func (s ContainerOverrides) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerOverrides) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContainerOverrides"}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContainerOverrides) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Command) > 0 {
		v := s.Command

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "command", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Environment) > 0 {
		v := s.Environment

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "environment", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.InstanceType != nil {
		v := *s.InstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Memory != nil {
		v := *s.Memory

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "memory", protocol.Int64Value(v), metadata)
	}
	if len(s.ResourceRequirements) > 0 {
		v := s.ResourceRequirements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resourceRequirements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Vcpus != nil {
		v := *s.Vcpus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vcpus", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Container properties are used in job definitions to describe the container
// that is launched as part of a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ContainerProperties
type ContainerProperties struct {
	_ struct{} `type:"structure"`

	// The command that is passed to the container. This parameter maps to Cmd in
	// the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the COMMAND parameter to docker run (https://docs.docker.com/engine/reference/run/).
	// For more information, see https://docs.docker.com/engine/reference/builder/#cmd
	// (https://docs.docker.com/engine/reference/builder/#cmd).
	Command []string `locationName:"command" type:"list"`

	// The environment variables to pass to a container. This parameter maps to
	// Env in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --env option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// We do not recommend using plaintext environment variables for sensitive information,
	// such as credential data.
	//
	// Environment variables must not start with AWS_BATCH; this naming convention
	// is reserved for variables that are set by the AWS Batch service.
	Environment []KeyValuePair `locationName:"environment" type:"list"`

	// The image used to start a container. This string is passed directly to the
	// Docker daemon. Images in the Docker Hub registry are available by default.
	// Other repositories are specified with repository-url/image:tag . Up to 255
	// letters (uppercase and lowercase), numbers, hyphens, underscores, colons,
	// periods, forward slashes, and number signs are allowed. This parameter maps
	// to Image in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the IMAGE parameter of docker run (https://docs.docker.com/engine/reference/run/).
	//
	//    * Images in Amazon ECR repositories use the full registry and repository
	//    URI (for example, 012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>).
	//
	//    * Images in official repositories on Docker Hub use a single name (for
	//    example, ubuntu or mongo).
	//
	//    * Images in other repositories on Docker Hub are qualified with an organization
	//    name (for example, amazon/amazon-ecs-agent).
	//
	//    * Images in other online repositories are qualified further by a domain
	//    name (for example, quay.io/assemblyline/ubuntu).
	Image *string `locationName:"image" type:"string"`

	// The instance type to use for a multi-node parallel job. Currently all node
	// groups in a multi-node parallel job must use the same instance type. This
	// parameter is not valid for single-node container jobs.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that the container can assume
	// for AWS permissions.
	JobRoleArn *string `locationName:"jobRoleArn" type:"string"`

	// The hard limit (in MiB) of memory to present to the container. If your container
	// attempts to exceed the memory specified here, the container is killed. This
	// parameter maps to Memory in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --memory option to docker run (https://docs.docker.com/engine/reference/run/).
	// You must specify at least 4 MiB of memory for a job.
	//
	// If you are trying to maximize your resource utilization by providing your
	// jobs as much memory as possible for a particular instance type, see Memory
	// Management (https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html)
	// in the AWS Batch User Guide.
	Memory *int64 `locationName:"memory" type:"integer"`

	// The mount points for data volumes in your container. This parameter maps
	// to Volumes in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --volume option to docker run (https://docs.docker.com/engine/reference/run/).
	MountPoints []MountPoint `locationName:"mountPoints" type:"list"`

	// When this parameter is true, the container is given elevated privileges on
	// the host container instance (similar to the root user). This parameter maps
	// to Privileged in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --privileged option to docker run (https://docs.docker.com/engine/reference/run/).
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the Create a container
	// (https://docs.docker.com/engine/api/v1.23/#create-a-container) section of
	// the Docker Remote API (https://docs.docker.com/engine/api/v1.23/) and the
	// --read-only option to docker run.
	ReadonlyRootFilesystem *bool `locationName:"readonlyRootFilesystem" type:"boolean"`

	// The type and amount of a resource to assign to a container. Currently, the
	// only supported resource is GPU.
	ResourceRequirements []ResourceRequirement `locationName:"resourceRequirements" type:"list"`

	// A list of ulimits to set in the container. This parameter maps to Ulimits
	// in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --ulimit option to docker run (https://docs.docker.com/engine/reference/run/).
	Ulimits []Ulimit `locationName:"ulimits" type:"list"`

	// The user name to use inside the container. This parameter maps to User in
	// the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --user option to docker run (https://docs.docker.com/engine/reference/run/).
	User *string `locationName:"user" type:"string"`

	// The number of vCPUs reserved for the container. This parameter maps to CpuShares
	// in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --cpu-shares option to docker run (https://docs.docker.com/engine/reference/run/).
	// Each vCPU is equivalent to 1,024 CPU shares. You must specify at least one
	// vCPU.
	Vcpus *int64 `locationName:"vcpus" type:"integer"`

	// A list of data volumes used in a job.
	Volumes []Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation
func (s ContainerProperties) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerProperties) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContainerProperties"}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Ulimits != nil {
		for i, v := range s.Ulimits {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ulimits", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContainerProperties) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Command) > 0 {
		v := s.Command

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "command", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Environment) > 0 {
		v := s.Environment

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "environment", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Image != nil {
		v := *s.Image

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "image", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceType != nil {
		v := *s.InstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobRoleArn != nil {
		v := *s.JobRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Memory != nil {
		v := *s.Memory

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "memory", protocol.Int64Value(v), metadata)
	}
	if len(s.MountPoints) > 0 {
		v := s.MountPoints

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "mountPoints", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Privileged != nil {
		v := *s.Privileged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privileged", protocol.BoolValue(v), metadata)
	}
	if s.ReadonlyRootFilesystem != nil {
		v := *s.ReadonlyRootFilesystem

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "readonlyRootFilesystem", protocol.BoolValue(v), metadata)
	}
	if len(s.ResourceRequirements) > 0 {
		v := s.ResourceRequirements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resourceRequirements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Ulimits) > 0 {
		v := s.Ulimits

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ulimits", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.User != nil {
		v := *s.User

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "user", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Vcpus != nil {
		v := *s.Vcpus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vcpus", protocol.Int64Value(v), metadata)
	}
	if len(s.Volumes) > 0 {
		v := s.Volumes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "volumes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object representing summary details of a container within a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ContainerSummary
type ContainerSummary struct {
	_ struct{} `type:"structure"`

	// The exit code to return upon completion.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// A short (255 max characters) human-readable string to provide additional
	// details about a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s ContainerSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContainerSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExitCode != nil {
		v := *s.ExitCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "exitCode", protocol.Int64Value(v), metadata)
	}
	if s.Reason != nil {
		v := *s.Reason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Determine whether your data volume persists on the host container instance
// and where it is stored. If this parameter is empty, then the Docker daemon
// assigns a host path for your data volume, but the data is not guaranteed
// to persist after the containers associated with it stop running.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/Host
type Host struct {
	_ struct{} `type:"structure"`

	// The path on the host container instance that is presented to the container.
	// If this parameter is empty, then the Docker daemon has assigned a host path
	// for you. If this parameter contains a file location, then the data volume
	// persists at the specified location on the host container instance until you
	// delete it manually. If the source path location does not exist on the host
	// container instance, the Docker daemon creates it. If the location does exist,
	// the contents of the source path folder are exported.
	SourcePath *string `locationName:"sourcePath" type:"string"`
}

// String returns the string representation
func (s Host) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Host) MarshalFields(e protocol.FieldEncoder) error {
	if s.SourcePath != nil {
		v := *s.SourcePath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourcePath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing an AWS Batch job definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobDefinition
type JobDefinition struct {
	_ struct{} `type:"structure"`

	// An object with various properties specific to container-based jobs.
	ContainerProperties *ContainerProperties `locationName:"containerProperties" type:"structure"`

	// The Amazon Resource Name (ARN) for the job definition.
	//
	// JobDefinitionArn is a required field
	JobDefinitionArn *string `locationName:"jobDefinitionArn" type:"string" required:"true"`

	// The name of the job definition.
	//
	// JobDefinitionName is a required field
	JobDefinitionName *string `locationName:"jobDefinitionName" type:"string" required:"true"`

	// An object with various properties specific to multi-node parallel jobs.
	NodeProperties *NodeProperties `locationName:"nodeProperties" type:"structure"`

	// Default parameters or parameter substitution placeholders that are set in
	// the job definition. Parameters are specified as a key-value pair mapping.
	// Parameters in a SubmitJob request override any corresponding parameter defaults
	// from the job definition. For more information about specifying parameters,
	// see Job Definition Parameters (https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html)
	// in the AWS Batch User Guide.
	Parameters map[string]string `locationName:"parameters" type:"map"`

	// The retry strategy to use for failed jobs that are submitted with this job
	// definition.
	RetryStrategy *RetryStrategy `locationName:"retryStrategy" type:"structure"`

	// The revision of the job definition.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" type:"integer" required:"true"`

	// The status of the job definition.
	Status *string `locationName:"status" type:"string"`

	// The timeout configuration for jobs that are submitted with this job definition.
	// You can specify a timeout duration after which AWS Batch terminates your
	// jobs if they have not finished.
	Timeout *JobTimeout `locationName:"timeout" type:"structure"`

	// The type of job definition.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation
func (s JobDefinition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContainerProperties != nil {
		v := s.ContainerProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "containerProperties", v, metadata)
	}
	if s.JobDefinitionArn != nil {
		v := *s.JobDefinitionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobDefinitionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobDefinitionName != nil {
		v := *s.JobDefinitionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobDefinitionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NodeProperties != nil {
		v := s.NodeProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "nodeProperties", v, metadata)
	}
	if len(s.Parameters) > 0 {
		v := s.Parameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "parameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RetryStrategy != nil {
		v := s.RetryStrategy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "retryStrategy", v, metadata)
	}
	if s.Revision != nil {
		v := *s.Revision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "revision", protocol.Int64Value(v), metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timeout != nil {
		v := s.Timeout

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "timeout", v, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing an AWS Batch job dependency.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobDependency
type JobDependency struct {
	_ struct{} `type:"structure"`

	// The job ID of the AWS Batch job associated with this dependency.
	JobId *string `locationName:"jobId" type:"string"`

	// The type of the job dependency.
	Type ArrayJobDependency `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s JobDependency) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobDependency) MarshalFields(e protocol.FieldEncoder) error {
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object representing an AWS Batch job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobDetail
type JobDetail struct {
	_ struct{} `type:"structure"`

	// The array properties of the job, if it is an array job.
	ArrayProperties *ArrayPropertiesDetail `locationName:"arrayProperties" type:"structure"`

	// A list of job attempts associated with this job.
	Attempts []AttemptDetail `locationName:"attempts" type:"list"`

	// An object representing the details of the container that is associated with
	// the job.
	Container *ContainerDetail `locationName:"container" type:"structure"`

	// The Unix timestamp (in seconds and milliseconds) for when the job was created.
	// For non-array jobs and parent array jobs, this is when the job entered the
	// SUBMITTED state (at the time SubmitJob was called). For array child jobs,
	// this is when the child job was spawned by its parent and entered the PENDING
	// state.
	CreatedAt *int64 `locationName:"createdAt" type:"long"`

	// A list of job names or IDs on which this job depends.
	DependsOn []JobDependency `locationName:"dependsOn" type:"list"`

	// The job definition that is used by this job.
	//
	// JobDefinition is a required field
	JobDefinition *string `locationName:"jobDefinition" type:"string" required:"true"`

	// The ID for the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The name of the job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the job queue with which the job is associated.
	//
	// JobQueue is a required field
	JobQueue *string `locationName:"jobQueue" type:"string" required:"true"`

	// An object representing the details of a node that is associated with a multi-node
	// parallel job.
	NodeDetails *NodeDetails `locationName:"nodeDetails" type:"structure"`

	// An object representing the node properties of a multi-node parallel job.
	NodeProperties *NodeProperties `locationName:"nodeProperties" type:"structure"`

	// Additional parameters passed to the job that replace parameter substitution
	// placeholders or override any corresponding parameter defaults from the job
	// definition.
	Parameters map[string]string `locationName:"parameters" type:"map"`

	// The retry strategy to use for this job if an attempt fails.
	RetryStrategy *RetryStrategy `locationName:"retryStrategy" type:"structure"`

	// The Unix timestamp (in seconds and milliseconds) for when the job was started
	// (when the job transitioned from the STARTING state to the RUNNING state).
	//
	// StartedAt is a required field
	StartedAt *int64 `locationName:"startedAt" type:"long" required:"true"`

	// The current status for the job.
	//
	// If your jobs do not progress to STARTING, see Jobs Stuck in RUNNABLE Status
	// (https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable)
	// in the troubleshooting section of the AWS Batch User Guide.
	//
	// Status is a required field
	Status JobStatus `locationName:"status" type:"string" required:"true" enum:"true"`

	// A short, human-readable string to provide additional details about the current
	// status of the job.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The Unix timestamp (in seconds and milliseconds) for when the job was stopped
	// (when the job transitioned from the RUNNING state to a terminal state, such
	// as SUCCEEDED or FAILED).
	StoppedAt *int64 `locationName:"stoppedAt" type:"long"`

	// The timeout configuration for the job.
	Timeout *JobTimeout `locationName:"timeout" type:"structure"`
}

// String returns the string representation
func (s JobDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArrayProperties != nil {
		v := s.ArrayProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "arrayProperties", v, metadata)
	}
	if len(s.Attempts) > 0 {
		v := s.Attempts

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "attempts", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Container != nil {
		v := s.Container

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "container", v, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.Int64Value(v), metadata)
	}
	if len(s.DependsOn) > 0 {
		v := s.DependsOn

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "dependsOn", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.JobDefinition != nil {
		v := *s.JobDefinition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobDefinition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobName != nil {
		v := *s.JobName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobQueue != nil {
		v := *s.JobQueue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobQueue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NodeDetails != nil {
		v := s.NodeDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "nodeDetails", v, metadata)
	}
	if s.NodeProperties != nil {
		v := s.NodeProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "nodeProperties", v, metadata)
	}
	if len(s.Parameters) > 0 {
		v := s.Parameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "parameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RetryStrategy != nil {
		v := s.RetryStrategy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "retryStrategy", v, metadata)
	}
	if s.StartedAt != nil {
		v := *s.StartedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startedAt", protocol.Int64Value(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusReason != nil {
		v := *s.StatusReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StoppedAt != nil {
		v := *s.StoppedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stoppedAt", protocol.Int64Value(v), metadata)
	}
	if s.Timeout != nil {
		v := s.Timeout

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "timeout", v, metadata)
	}
	return nil
}

// An object representing the details of an AWS Batch job queue.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobQueueDetail
type JobQueueDetail struct {
	_ struct{} `type:"structure"`

	// The compute environments that are attached to the job queue and the order
	// in which job placement is preferred. Compute environments are selected for
	// job placement in ascending order.
	//
	// ComputeEnvironmentOrder is a required field
	ComputeEnvironmentOrder []ComputeEnvironmentOrder `locationName:"computeEnvironmentOrder" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the job queue.
	//
	// JobQueueArn is a required field
	JobQueueArn *string `locationName:"jobQueueArn" type:"string" required:"true"`

	// The name of the job queue.
	//
	// JobQueueName is a required field
	JobQueueName *string `locationName:"jobQueueName" type:"string" required:"true"`

	// The priority of the job queue.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// Describes the ability of the queue to accept new jobs.
	//
	// State is a required field
	State JQState `locationName:"state" type:"string" required:"true" enum:"true"`

	// The status of the job queue (for example, CREATING or VALID).
	Status JQStatus `locationName:"status" type:"string" enum:"true"`

	// A short, human-readable string to provide additional details about the current
	// status of the job queue.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation
func (s JobQueueDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobQueueDetail) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ComputeEnvironmentOrder) > 0 {
		v := s.ComputeEnvironmentOrder

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "computeEnvironmentOrder", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.JobQueueArn != nil {
		v := *s.JobQueueArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobQueueArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobQueueName != nil {
		v := *s.JobQueueName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobQueueName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "priority", protocol.Int64Value(v), metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusReason != nil {
		v := *s.StatusReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing summary details of a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobSummary
type JobSummary struct {
	_ struct{} `type:"structure"`

	// The array properties of the job, if it is an array job.
	ArrayProperties *ArrayPropertiesSummary `locationName:"arrayProperties" type:"structure"`

	// An object representing the details of the container that is associated with
	// the job.
	Container *ContainerSummary `locationName:"container" type:"structure"`

	// The Unix timestamp for when the job was created. For non-array jobs and parent
	// array jobs, this is when the job entered the SUBMITTED state (at the time
	// SubmitJob was called). For array child jobs, this is when the child job was
	// spawned by its parent and entered the PENDING state.
	CreatedAt *int64 `locationName:"createdAt" type:"long"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The name of the job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" type:"string" required:"true"`

	// The node properties for a single node in a job summary list.
	NodeProperties *NodePropertiesSummary `locationName:"nodeProperties" type:"structure"`

	// The Unix timestamp for when the job was started (when the job transitioned
	// from the STARTING state to the RUNNING state).
	StartedAt *int64 `locationName:"startedAt" type:"long"`

	// The current status for the job.
	Status JobStatus `locationName:"status" type:"string" enum:"true"`

	// A short, human-readable string to provide additional details about the current
	// status of the job.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The Unix timestamp for when the job was stopped (when the job transitioned
	// from the RUNNING state to a terminal state, such as SUCCEEDED or FAILED).
	StoppedAt *int64 `locationName:"stoppedAt" type:"long"`
}

// String returns the string representation
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArrayProperties != nil {
		v := s.ArrayProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "arrayProperties", v, metadata)
	}
	if s.Container != nil {
		v := s.Container

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "container", v, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.Int64Value(v), metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobName != nil {
		v := *s.JobName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NodeProperties != nil {
		v := s.NodeProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "nodeProperties", v, metadata)
	}
	if s.StartedAt != nil {
		v := *s.StartedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startedAt", protocol.Int64Value(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusReason != nil {
		v := *s.StatusReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StoppedAt != nil {
		v := *s.StoppedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stoppedAt", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing a job timeout configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobTimeout
type JobTimeout struct {
	_ struct{} `type:"structure"`

	// The time duration in seconds (measured from the job attempt's startedAt timestamp)
	// after which AWS Batch terminates your jobs if they have not finished.
	AttemptDurationSeconds *int64 `locationName:"attemptDurationSeconds" type:"integer"`
}

// String returns the string representation
func (s JobTimeout) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobTimeout) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttemptDurationSeconds != nil {
		v := *s.AttemptDurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attemptDurationSeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A key-value pair object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/KeyValuePair
type KeyValuePair struct {
	_ struct{} `type:"structure"`

	// The name of the key-value pair. For environment variables, this is the name
	// of the environment variable.
	Name *string `locationName:"name" type:"string"`

	// The value of the key-value pair. For environment variables, this is the value
	// of the environment variable.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s KeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s KeyValuePair) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing a launch template associated with a compute resource.
// You must specify either the launch template ID or launch template name in
// the request, but not both.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/LaunchTemplateSpecification
type LaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	LaunchTemplateId *string `locationName:"launchTemplateId" type:"string"`

	// The name of the launch template.
	LaunchTemplateName *string `locationName:"launchTemplateName" type:"string"`

	// The version number of the launch template.
	//
	// Default: The default version of the launch template.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LaunchTemplateSpecification) MarshalFields(e protocol.FieldEncoder) error {
	if s.LaunchTemplateId != nil {
		v := *s.LaunchTemplateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "launchTemplateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchTemplateName != nil {
		v := *s.LaunchTemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "launchTemplateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details on a Docker volume mount point that is used in a job's container
// properties. This parameter maps to Volumes in the Create a container (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.19/#create-a-container)
// section of the Docker Remote API and the --volume option to docker run.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/MountPoint
type MountPoint struct {
	_ struct{} `type:"structure"`

	// The path on the container at which to mount the host volume.
	ContainerPath *string `locationName:"containerPath" type:"string"`

	// If this value is true, the container has read-only access to the volume;
	// otherwise, the container can write to the volume. The default value is false.
	ReadOnly *bool `locationName:"readOnly" type:"boolean"`

	// The name of the volume to mount.
	SourceVolume *string `locationName:"sourceVolume" type:"string"`
}

// String returns the string representation
func (s MountPoint) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MountPoint) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContainerPath != nil {
		v := *s.ContainerPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "containerPath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReadOnly != nil {
		v := *s.ReadOnly

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "readOnly", protocol.BoolValue(v), metadata)
	}
	if s.SourceVolume != nil {
		v := *s.SourceVolume

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceVolume", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the elastic network interface for a multi-node parallel
// job node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/NetworkInterface
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The attachment ID for the network interface.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// The private IPv6 address for the network interface.
	Ipv6Address *string `locationName:"ipv6Address" type:"string"`

	// The private IPv4 address for the network interface.
	PrivateIpv4Address *string `locationName:"privateIpv4Address" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkInterface) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttachmentId != nil {
		v := *s.AttachmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attachmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Ipv6Address != nil {
		v := *s.Ipv6Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ipv6Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrivateIpv4Address != nil {
		v := *s.PrivateIpv4Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privateIpv4Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the details of a multi-node parallel job node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/NodeDetails
type NodeDetails struct {
	_ struct{} `type:"structure"`

	// Specifies whether the current node is the main node for a multi-node parallel
	// job.
	IsMainNode *bool `locationName:"isMainNode" type:"boolean"`

	// The node index for the node. Node index numbering begins at zero. This index
	// is also available on the node with the AWS_BATCH_JOB_NODE_INDEX environment
	// variable.
	NodeIndex *int64 `locationName:"nodeIndex" type:"integer"`
}

// String returns the string representation
func (s NodeDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodeDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsMainNode != nil {
		v := *s.IsMainNode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isMainNode", protocol.BoolValue(v), metadata)
	}
	if s.NodeIndex != nil {
		v := *s.NodeIndex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nodeIndex", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Object representing any node overrides to a job definition that is used in
// a SubmitJob API operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/NodeOverrides
type NodeOverrides struct {
	_ struct{} `type:"structure"`

	// The node property overrides for the job.
	NodePropertyOverrides []NodePropertyOverride `locationName:"nodePropertyOverrides" type:"list"`

	// The number of nodes to use with a multi-node parallel job. This value overrides
	// the number of nodes that are specified in the job definition. To use this
	// override:
	//
	//    * There must be at least one node range in your job definition that has
	//    an open upper boundary (such as : or n:).
	//
	//    * The lower boundary of the node range specified in the job definition
	//    must be fewer than the number of nodes specified in the override.
	//
	//    * The main node index specified in the job definition must be fewer than
	//    the number of nodes specified in the override.
	NumNodes *int64 `locationName:"numNodes" type:"integer"`
}

// String returns the string representation
func (s NodeOverrides) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeOverrides) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NodeOverrides"}
	if s.NodePropertyOverrides != nil {
		for i, v := range s.NodePropertyOverrides {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NodePropertyOverrides", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodeOverrides) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.NodePropertyOverrides) > 0 {
		v := s.NodePropertyOverrides

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "nodePropertyOverrides", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NumNodes != nil {
		v := *s.NumNodes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numNodes", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing the node properties of a multi-node parallel job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/NodeProperties
type NodeProperties struct {
	_ struct{} `type:"structure"`

	// Specifies the node index for the main node of a multi-node parallel job.
	// This node index value must be fewer than the number of nodes.
	//
	// MainNode is a required field
	MainNode *int64 `locationName:"mainNode" type:"integer" required:"true"`

	// A list of node ranges and their properties associated with a multi-node parallel
	// job.
	//
	// NodeRangeProperties is a required field
	NodeRangeProperties []NodeRangeProperty `locationName:"nodeRangeProperties" type:"list" required:"true"`

	// The number of nodes associated with a multi-node parallel job.
	//
	// NumNodes is a required field
	NumNodes *int64 `locationName:"numNodes" type:"integer" required:"true"`
}

// String returns the string representation
func (s NodeProperties) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeProperties) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NodeProperties"}

	if s.MainNode == nil {
		invalidParams.Add(aws.NewErrParamRequired("MainNode"))
	}

	if s.NodeRangeProperties == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodeRangeProperties"))
	}

	if s.NumNodes == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumNodes"))
	}
	if s.NodeRangeProperties != nil {
		for i, v := range s.NodeRangeProperties {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NodeRangeProperties", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodeProperties) MarshalFields(e protocol.FieldEncoder) error {
	if s.MainNode != nil {
		v := *s.MainNode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mainNode", protocol.Int64Value(v), metadata)
	}
	if len(s.NodeRangeProperties) > 0 {
		v := s.NodeRangeProperties

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "nodeRangeProperties", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NumNodes != nil {
		v := *s.NumNodes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numNodes", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object representing the properties of a node that is associated with a
// multi-node parallel job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/NodePropertiesSummary
type NodePropertiesSummary struct {
	_ struct{} `type:"structure"`

	// Specifies whether the current node is the main node for a multi-node parallel
	// job.
	IsMainNode *bool `locationName:"isMainNode" type:"boolean"`

	// The node index for the node. Node index numbering begins at zero. This index
	// is also available on the node with the AWS_BATCH_JOB_NODE_INDEX environment
	// variable.
	NodeIndex *int64 `locationName:"nodeIndex" type:"integer"`

	// The number of nodes associated with a multi-node parallel job.
	NumNodes *int64 `locationName:"numNodes" type:"integer"`
}

// String returns the string representation
func (s NodePropertiesSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodePropertiesSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsMainNode != nil {
		v := *s.IsMainNode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isMainNode", protocol.BoolValue(v), metadata)
	}
	if s.NodeIndex != nil {
		v := *s.NodeIndex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nodeIndex", protocol.Int64Value(v), metadata)
	}
	if s.NumNodes != nil {
		v := *s.NumNodes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numNodes", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Object representing any node overrides to a job definition that is used in
// a SubmitJob API operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/NodePropertyOverride
type NodePropertyOverride struct {
	_ struct{} `type:"structure"`

	// The overrides that should be sent to a node range.
	ContainerOverrides *ContainerOverrides `locationName:"containerOverrides" type:"structure"`

	// The range of nodes, using node index values, with which to override. A range
	// of 0:3 indicates nodes with index values of 0 through 3. If the starting
	// range value is omitted (:n), then 0 is used to start the range. If the ending
	// range value is omitted (n:), then the highest possible node index is used
	// to end the range.
	//
	// TargetNodes is a required field
	TargetNodes *string `locationName:"targetNodes" type:"string" required:"true"`
}

// String returns the string representation
func (s NodePropertyOverride) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodePropertyOverride) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NodePropertyOverride"}

	if s.TargetNodes == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetNodes"))
	}
	if s.ContainerOverrides != nil {
		if err := s.ContainerOverrides.Validate(); err != nil {
			invalidParams.AddNested("ContainerOverrides", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodePropertyOverride) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContainerOverrides != nil {
		v := s.ContainerOverrides

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "containerOverrides", v, metadata)
	}
	if s.TargetNodes != nil {
		v := *s.TargetNodes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetNodes", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object representing the properties of the node range for a multi-node
// parallel job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/NodeRangeProperty
type NodeRangeProperty struct {
	_ struct{} `type:"structure"`

	// The container details for the node range.
	Container *ContainerProperties `locationName:"container" type:"structure"`

	// The range of nodes, using node index values. A range of 0:3 indicates nodes
	// with index values of 0 through 3. If the starting range value is omitted
	// (:n), then 0 is used to start the range. If the ending range value is omitted
	// (n:), then the highest possible node index is used to end the range. Your
	// accumulative node ranges must account for all nodes (0:n). You may nest node
	// ranges, for example 0:10 and 4:5, in which case the 4:5 range properties
	// override the 0:10 properties.
	//
	// TargetNodes is a required field
	TargetNodes *string `locationName:"targetNodes" type:"string" required:"true"`
}

// String returns the string representation
func (s NodeRangeProperty) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeRangeProperty) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NodeRangeProperty"}

	if s.TargetNodes == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetNodes"))
	}
	if s.Container != nil {
		if err := s.Container.Validate(); err != nil {
			invalidParams.AddNested("Container", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodeRangeProperty) MarshalFields(e protocol.FieldEncoder) error {
	if s.Container != nil {
		v := s.Container

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "container", v, metadata)
	}
	if s.TargetNodes != nil {
		v := *s.TargetNodes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetNodes", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The type and amount of a resource to assign to a container. Currently, the
// only supported resource type is GPU.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ResourceRequirement
type ResourceRequirement struct {
	_ struct{} `type:"structure"`

	// The type of resource to assign to a container. Currently, the only supported
	// resource type is GPU.
	//
	// Type is a required field
	Type ResourceType `locationName:"type" type:"string" required:"true" enum:"true"`

	// The number of physical GPUs to reserve for the container. The number of GPUs
	// reserved for all containers in a job should not exceed the number of available
	// GPUs on the compute resource that the job is launched on.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceRequirement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceRequirement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceRequirement"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceRequirement) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The retry strategy associated with a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/RetryStrategy
type RetryStrategy struct {
	_ struct{} `type:"structure"`

	// The number of times to move a job to the RUNNABLE status. You may specify
	// between 1 and 10 attempts. If the value of attempts is greater than one,
	// the job is retried on failure the same number of attempts as the value.
	Attempts *int64 `locationName:"attempts" type:"integer"`
}

// String returns the string representation
func (s RetryStrategy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RetryStrategy) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attempts != nil {
		v := *s.Attempts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attempts", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The ulimit settings to pass to the container.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/Ulimit
type Ulimit struct {
	_ struct{} `type:"structure"`

	// The hard limit for the ulimit type.
	//
	// HardLimit is a required field
	HardLimit *int64 `locationName:"hardLimit" type:"integer" required:"true"`

	// The type of the ulimit.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The soft limit for the ulimit type.
	//
	// SoftLimit is a required field
	SoftLimit *int64 `locationName:"softLimit" type:"integer" required:"true"`
}

// String returns the string representation
func (s Ulimit) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ulimit) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Ulimit"}

	if s.HardLimit == nil {
		invalidParams.Add(aws.NewErrParamRequired("HardLimit"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.SoftLimit == nil {
		invalidParams.Add(aws.NewErrParamRequired("SoftLimit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Ulimit) MarshalFields(e protocol.FieldEncoder) error {
	if s.HardLimit != nil {
		v := *s.HardLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "hardLimit", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SoftLimit != nil {
		v := *s.SoftLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "softLimit", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A data volume used in a job's container properties.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/Volume
type Volume struct {
	_ struct{} `type:"structure"`

	// The contents of the host parameter determine whether your data volume persists
	// on the host container instance and where it is stored. If the host parameter
	// is empty, then the Docker daemon assigns a host path for your data volume.
	// However, the data is not guaranteed to persist after the containers associated
	// with it stop running.
	Host *Host `locationName:"host" type:"structure"`

	// The name of the volume. Up to 255 letters (uppercase and lowercase), numbers,
	// hyphens, and underscores are allowed. This name is referenced in the sourceVolume
	// parameter of container definition mountPoints.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Volume) MarshalFields(e protocol.FieldEncoder) error {
	if s.Host != nil {
		v := s.Host

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "host", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
