// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package batch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironmentRequest
type UpdateComputeEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name or full Amazon Resource Name (ARN) of the compute environment to
	// update.
	//
	// ComputeEnvironment is a required field
	ComputeEnvironment *string `locationName:"computeEnvironment" type:"string" required:"true"`

	// Details of the compute resources managed by the compute environment. Required
	// for a managed compute environment.
	ComputeResources *ComputeResourceUpdate `locationName:"computeResources" type:"structure"`

	// The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch
	// to make calls to other AWS services on your behalf.
	//
	// If your specified role has a path other than /, then you must either specify
	// the full role ARN (this is recommended) or prefix the role name with the
	// path.
	//
	// Depending on how you created your AWS Batch service role, its ARN may contain
	// the service-role path prefix. When you only specify the name of the service
	// role, AWS Batch assumes that your ARN does not use the service-role path
	// prefix. Because of this, we recommend that you specify the full ARN of your
	// service role when you create compute environments.
	ServiceRole *string `locationName:"serviceRole" type:"string"`

	// The state of the compute environment. Compute environments in the ENABLED
	// state can accept jobs from a queue and scale in or out automatically based
	// on the workload demand of its associated queues.
	State CEState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateComputeEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComputeEnvironmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateComputeEnvironmentInput"}

	if s.ComputeEnvironment == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComputeEnvironment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateComputeEnvironmentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ComputeEnvironment != nil {
		v := *s.ComputeEnvironment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeEnvironment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ComputeResources != nil {
		v := s.ComputeResources

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "computeResources", v, metadata)
	}
	if s.ServiceRole != nil {
		v := *s.ServiceRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironmentResponse
type UpdateComputeEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	ComputeEnvironmentArn *string `locationName:"computeEnvironmentArn" type:"string"`

	// The name of the compute environment.
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string"`
}

// String returns the string representation
func (s UpdateComputeEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateComputeEnvironmentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComputeEnvironmentArn != nil {
		v := *s.ComputeEnvironmentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeEnvironmentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ComputeEnvironmentName != nil {
		v := *s.ComputeEnvironmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeEnvironmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateComputeEnvironment = "UpdateComputeEnvironment"

// UpdateComputeEnvironmentRequest returns a request value for making API operation for
// AWS Batch.
//
// Updates an AWS Batch compute environment.
//
//    // Example sending a request using UpdateComputeEnvironmentRequest.
//    req := client.UpdateComputeEnvironmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironment
func (c *Client) UpdateComputeEnvironmentRequest(input *UpdateComputeEnvironmentInput) UpdateComputeEnvironmentRequest {
	op := &aws.Operation{
		Name:       opUpdateComputeEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/updatecomputeenvironment",
	}

	if input == nil {
		input = &UpdateComputeEnvironmentInput{}
	}

	req := c.newRequest(op, input, &UpdateComputeEnvironmentOutput{})
	return UpdateComputeEnvironmentRequest{Request: req, Input: input, Copy: c.UpdateComputeEnvironmentRequest}
}

// UpdateComputeEnvironmentRequest is the request type for the
// UpdateComputeEnvironment API operation.
type UpdateComputeEnvironmentRequest struct {
	*aws.Request
	Input *UpdateComputeEnvironmentInput
	Copy  func(*UpdateComputeEnvironmentInput) UpdateComputeEnvironmentRequest
}

// Send marshals and sends the UpdateComputeEnvironment API request.
func (r UpdateComputeEnvironmentRequest) Send(ctx context.Context) (*UpdateComputeEnvironmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateComputeEnvironmentResponse{
		UpdateComputeEnvironmentOutput: r.Request.Data.(*UpdateComputeEnvironmentOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateComputeEnvironmentResponse is the response type for the
// UpdateComputeEnvironment API operation.
type UpdateComputeEnvironmentResponse struct {
	*UpdateComputeEnvironmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateComputeEnvironment request.
func (r *UpdateComputeEnvironmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
