// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains detailed information about a backup job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/BackupJob
type BackupJob struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a request to AWS Backup to back up a resource.
	BackupJobId *string `type:"string"`

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64 `type:"long"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// The size in bytes transferred to a backup vault at the time that the job
	// status was queried.
	BytesTransferred *int64 `type:"long"`

	// The date and time a job to create a backup job is completed, in Unix format
	// and Coordinated Universal Time (UTC). The value of CompletionDate is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Contains identifying information about the creation of a backup job, including
	// the BackupPlanArn, BackupPlanId, BackupPlanVersion, and BackupRuleId of the
	// backup plan used to create it.
	CreatedBy *RecoveryPointCreator `type:"structure"`

	// The date and time a backup job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time a job to back up resources is expected to be completed,
	// in Unix format and Coordinated Universal Time (UTC). The value of ExpectedCompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	ExpectedCompletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// Contains an estimated percentage complete of a job at the time the job status
	// was queried.
	PercentDone *string `type:"string"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// An ARN that uniquely identifies a resource. The format of the ARN depends
	// on the resource type.
	ResourceArn *string `type:"string"`

	// The type of AWS resource to be backed-up; for example, an Amazon Elastic
	// Block Store (Amazon EBS) volume or an Amazon Relational Database Service
	// (Amazon RDS) database.
	ResourceType *string `type:"string"`

	// Specifies the time in Unix format and Coordinated Universal Time (UTC) when
	// a backup job must be started before it is canceled. The value is calculated
	// by adding the start window to the scheduled time. So if the scheduled time
	// were 6:00 PM and the start window is 2 hours, the StartBy time would be 8:00
	// PM on the date specified. The value of StartBy is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	StartBy *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The current state of a resource recovery point.
	State BackupJobState `type:"string" enum:"true"`

	// A detailed message explaining the status of the job to back up a resource.
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s BackupJob) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupJob) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupJobId != nil {
		v := *s.BackupJobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupJobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupSizeInBytes != nil {
		v := *s.BackupSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupSizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.BackupVaultArn != nil {
		v := *s.BackupVaultArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupVaultName != nil {
		v := *s.BackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BytesTransferred != nil {
		v := *s.BytesTransferred

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BytesTransferred", protocol.Int64Value(v), metadata)
	}
	if s.CompletionDate != nil {
		v := *s.CompletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CreatedBy != nil {
		v := s.CreatedBy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CreatedBy", v, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.ExpectedCompletionDate != nil {
		v := *s.ExpectedCompletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpectedCompletionDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.IamRoleArn != nil {
		v := *s.IamRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PercentDone != nil {
		v := *s.PercentDone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PercentDone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceArn != nil {
		v := *s.ResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceType != nil {
		v := *s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartBy != nil {
		v := *s.StartBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartBy", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusMessage != nil {
		v := *s.StatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains an optional backup plan display name and an array of BackupRule
// objects, each of which specifies a backup rule. Each rule in a backup plan
// is a separate scheduled task and can back up a different selection of AWS
// resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/BackupPlan
type BackupPlan struct {
	_ struct{} `type:"structure"`

	// The display name of a backup plan.
	//
	// BackupPlanName is a required field
	BackupPlanName *string `type:"string" required:"true"`

	// An array of BackupRule objects, each of which specifies a scheduled task
	// that is used to back up a selection of resources.
	//
	// Rules is a required field
	Rules []BackupRule `type:"list" required:"true"`
}

// String returns the string representation
func (s BackupPlan) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupPlan) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupPlanName != nil {
		v := *s.BackupPlanName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Rules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains an optional backup plan display name and an array of BackupRule
// objects, each of which specifies a backup rule. Each rule in a backup plan
// is a separate scheduled task and can back up a different selection of AWS
// resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/BackupPlanInput
type BackupPlanInput struct {
	_ struct{} `type:"structure"`

	// The display name of a backup plan.
	//
	// BackupPlanName is a required field
	BackupPlanName *string `type:"string" required:"true"`

	// An array of BackupRule objects, each of which specifies a scheduled task
	// that is used to back up a selection of resources.
	//
	// Rules is a required field
	Rules []BackupRuleInput `type:"list" required:"true"`
}

// String returns the string representation
func (s BackupPlanInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BackupPlanInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BackupPlanInput"}

	if s.BackupPlanName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupPlanName"))
	}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupPlanInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupPlanName != nil {
		v := *s.BackupPlanName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Rules) > 0 {
		v := s.Rules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Rules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object specifying metadata associated with a backup plan template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/BackupPlanTemplatesListMember
type BackupPlanTemplatesListMember struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a stored backup plan template.
	BackupPlanTemplateId *string `type:"string"`

	// The optional display name of a backup plan template.
	BackupPlanTemplateName *string `type:"string"`
}

// String returns the string representation
func (s BackupPlanTemplatesListMember) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupPlanTemplatesListMember) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupPlanTemplateId != nil {
		v := *s.BackupPlanTemplateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanTemplateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupPlanTemplateName != nil {
		v := *s.BackupPlanTemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanTemplateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains metadata about a backup plan.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/BackupPlansListMember
type BackupPlansListMember struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example, arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50.
	BackupPlanArn *string `type:"string"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// The display name of a saved backup plan.
	BackupPlanName *string `type:"string"`

	// The date and time a resource backup plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A unique string that identifies the request and allows failed requests to
	// be retried without the risk of executing the operation twice.
	CreatorRequestId *string `type:"string"`

	// The date and time a backup plan is deleted, in Unix format and Coordinated
	// Universal Time (UTC). The value of DeletionDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	DeletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The last time a job to back up resources was executed with this rule. A date
	// and time, in Unix format and Coordinated Universal Time (UTC). The value
	// of LastExecutionDate is accurate to milliseconds. For example, the value
	// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastExecutionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most
	// 1,024 bytes long. Version IDs cannot be edited.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s BackupPlansListMember) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupPlansListMember) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupPlanArn != nil {
		v := *s.BackupPlanArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupPlanId != nil {
		v := *s.BackupPlanId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupPlanName != nil {
		v := *s.BackupPlanName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CreatorRequestId != nil {
		v := *s.CreatorRequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatorRequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeletionDate != nil {
		v := *s.DeletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeletionDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastExecutionDate != nil {
		v := *s.LastExecutionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastExecutionDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies a scheduled task used to back up a selection of resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/BackupRule
type BackupRule struct {
	_ struct{} `type:"structure"`

	// A value in minutes after a backup job is successfully started before it must
	// be completed or it is canceled by AWS Backup. This value is optional.
	CompletionWindowMinutes *int64 `type:"long"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. AWS Backup transitions and expires backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “expire after days” setting must be
	// 90 days greater than the “transition to cold after days” setting. The
	// “transition to cold after days” setting cannot be changed after a backup
	// has been transitioned to cold.
	Lifecycle *Lifecycle `type:"structure"`

	// An array of key-value pair strings that are assigned to resources that are
	// associated with this rule when restored from backup.
	RecoveryPointTags map[string]string `type:"map"`

	// Uniquely identifies a rule that is used to schedule the backup of a selection
	// of resources.
	RuleId *string `type:"string"`

	// An optional display name for a backup rule.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// A CRON expression specifying when AWS Backup initiates a backup job.
	ScheduleExpression *string `type:"string"`

	// An optional value that specifies a period of time in minutes after a backup
	// is scheduled before a job is canceled if it doesn't start successfully.
	StartWindowMinutes *int64 `type:"long"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	//
	// TargetBackupVaultName is a required field
	TargetBackupVaultName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s BackupRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.CompletionWindowMinutes != nil {
		v := *s.CompletionWindowMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionWindowMinutes", protocol.Int64Value(v), metadata)
	}
	if s.Lifecycle != nil {
		v := s.Lifecycle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Lifecycle", v, metadata)
	}
	if len(s.RecoveryPointTags) > 0 {
		v := s.RecoveryPointTags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "RecoveryPointTags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RuleId != nil {
		v := *s.RuleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScheduleExpression != nil {
		v := *s.ScheduleExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ScheduleExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartWindowMinutes != nil {
		v := *s.StartWindowMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartWindowMinutes", protocol.Int64Value(v), metadata)
	}
	if s.TargetBackupVaultName != nil {
		v := *s.TargetBackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetBackupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies a scheduled task used to back up a selection of resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/BackupRuleInput
type BackupRuleInput struct {
	_ struct{} `type:"structure"`

	// The amount of time AWS Backup attempts a backup before canceling the job
	// and returning an error.
	CompletionWindowMinutes *int64 `type:"long"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. AWS Backup will transition and expire backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “expire after days” setting must be
	// 90 days greater than the “transition to cold after days”. The “transition
	// to cold after days” setting cannot be changed after a backup has been transitioned
	// to cold.
	Lifecycle *Lifecycle `type:"structure"`

	// To help organize your resources, you can assign your own metadata to the
	// resources that you create. Each tag is a key-value pair.
	RecoveryPointTags map[string]string `type:"map"`

	// >An optional display name for a backup rule.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// A CRON expression specifying when AWS Backup initiates a backup job.
	ScheduleExpression *string `type:"string"`

	// The amount of time in minutes before beginning a backup.
	StartWindowMinutes *int64 `type:"long"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	//
	// TargetBackupVaultName is a required field
	TargetBackupVaultName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s BackupRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BackupRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BackupRuleInput"}

	if s.RuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleName"))
	}

	if s.TargetBackupVaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetBackupVaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupRuleInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CompletionWindowMinutes != nil {
		v := *s.CompletionWindowMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionWindowMinutes", protocol.Int64Value(v), metadata)
	}
	if s.Lifecycle != nil {
		v := s.Lifecycle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Lifecycle", v, metadata)
	}
	if len(s.RecoveryPointTags) > 0 {
		v := s.RecoveryPointTags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "RecoveryPointTags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScheduleExpression != nil {
		v := *s.ScheduleExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ScheduleExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartWindowMinutes != nil {
		v := *s.StartWindowMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartWindowMinutes", protocol.Int64Value(v), metadata)
	}
	if s.TargetBackupVaultName != nil {
		v := *s.TargetBackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetBackupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Used to specify a set of resources to a backup plan.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/BackupSelection
type BackupSelection struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that AWS Backup uses to authenticate when restoring
	// the target resource; for example, arn:aws:iam::123456789012:role/S3Access.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// An array of conditions used to specify a set of resources to assign to a
	// backup plan; for example, "StringEquals": {"ec2:ResourceTag/Department":
	// "accounting".
	ListOfTags []Condition `type:"list"`

	// An array of strings that either contain Amazon Resource Names (ARNs) or match
	// patterns such as "arn:aws:ec2:us-east-1:123456789012:volume/*" of resources
	// to assign to a backup plan.
	Resources []string `type:"list"`

	// The display name of a resource selection document.
	//
	// SelectionName is a required field
	SelectionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s BackupSelection) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BackupSelection) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BackupSelection"}

	if s.IamRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamRoleArn"))
	}

	if s.SelectionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SelectionName"))
	}
	if s.ListOfTags != nil {
		for i, v := range s.ListOfTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ListOfTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupSelection) MarshalFields(e protocol.FieldEncoder) error {
	if s.IamRoleArn != nil {
		v := *s.IamRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ListOfTags) > 0 {
		v := s.ListOfTags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ListOfTags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Resources) > 0 {
		v := s.Resources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Resources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SelectionName != nil {
		v := *s.SelectionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SelectionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains metadata about a BackupSelection object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/BackupSelectionsListMember
type BackupSelectionsListMember struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// The date and time a backup plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A unique string that identifies the request and allows failed requests to
	// be retried without the risk of executing the operation twice.
	CreatorRequestId *string `type:"string"`

	// Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery
	// point; for example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// Uniquely identifies a request to assign a set of resources to a backup plan.
	SelectionId *string `type:"string"`

	// The display name of a resource selection document.
	SelectionName *string `type:"string"`
}

// String returns the string representation
func (s BackupSelectionsListMember) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupSelectionsListMember) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupPlanId != nil {
		v := *s.BackupPlanId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CreatorRequestId != nil {
		v := *s.CreatorRequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatorRequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IamRoleArn != nil {
		v := *s.IamRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SelectionId != nil {
		v := *s.SelectionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SelectionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SelectionName != nil {
		v := *s.SelectionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SelectionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains metadata about a backup vault.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/BackupVaultListMember
type BackupVaultListMember struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// The date and time a resource backup is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A unique string that identifies the request and allows failed requests to
	// be retried without the risk of executing the operation twice.
	CreatorRequestId *string `type:"string"`

	// The server-side encryption key that is used to protect your backups; for
	// example, arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string `type:"string"`

	// The number of recovery points that are stored in a backup vault.
	NumberOfRecoveryPoints *int64 `type:"long"`
}

// String returns the string representation
func (s BackupVaultListMember) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackupVaultListMember) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupVaultArn != nil {
		v := *s.BackupVaultArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupVaultName != nil {
		v := *s.BackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CreatorRequestId != nil {
		v := *s.CreatorRequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatorRequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EncryptionKeyArn != nil {
		v := *s.EncryptionKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncryptionKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NumberOfRecoveryPoints != nil {
		v := *s.NumberOfRecoveryPoints

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NumberOfRecoveryPoints", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Contains DeleteAt and MoveToColdStorageAt timestamps, which are used to specify
// a lifecycle for a recovery point.
//
// The lifecycle defines when a protected resource is transitioned to cold storage
// and when it expires. AWS Backup transitions and expires backups automatically
// according to the lifecycle that you define.
//
// Backups transitioned to cold storage must be stored in cold storage for a
// minimum of 90 days. Therefore, the “expire after days” setting must be
// 90 days greater than the “transition to cold after days” setting. The
// “transition to cold after days” setting cannot be changed after a backup
// has been transitioned to cold.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CalculatedLifecycle
type CalculatedLifecycle struct {
	_ struct{} `type:"structure"`

	// A timestamp that specifies when to delete a recovery point.
	DeleteAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A timestamp that specifies when to transition a recovery point to cold storage.
	MoveToColdStorageAt *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s CalculatedLifecycle) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CalculatedLifecycle) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeleteAt != nil {
		v := *s.DeleteAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.MoveToColdStorageAt != nil {
		v := *s.MoveToColdStorageAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MoveToColdStorageAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// Contains an array of triplets made up of a condition type (such as StringEquals),
// a key, and a value. Conditions are used to filter resources in a selection
// that is assigned to a backup plan.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/Condition
type Condition struct {
	_ struct{} `type:"structure"`

	// The key in a key-value pair. For example, in "ec2:ResourceTag/Department":
	// "accounting", "ec2:ResourceTag/Department" is the key.
	//
	// ConditionKey is a required field
	ConditionKey *string `type:"string" required:"true"`

	// An operation, such as StringEquals, that is applied to a key-value pair used
	// to filter resources in a selection.
	//
	// ConditionType is a required field
	ConditionType ConditionType `type:"string" required:"true" enum:"true"`

	// The value in a key-value pair. For example, in "ec2:ResourceTag/Department":
	// "accounting", "accounting" is the value.
	//
	// ConditionValue is a required field
	ConditionValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Condition"}

	if s.ConditionKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConditionKey"))
	}
	if len(s.ConditionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ConditionType"))
	}

	if s.ConditionValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConditionValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Condition) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConditionKey != nil {
		v := *s.ConditionKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConditionKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ConditionType) > 0 {
		v := s.ConditionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConditionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ConditionValue != nil {
		v := *s.ConditionValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConditionValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains an array of Transition objects specifying how long in days before
// a recovery point transitions to cold storage or is deleted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/Lifecycle
type Lifecycle struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days after creation that a recovery point is deleted.
	// Must be greater than MoveToColdStorageAfterDays.
	DeleteAfterDays *int64 `type:"long"`

	// Specifies the number of days after creation that a recovery point is moved
	// to cold storage.
	MoveToColdStorageAfterDays *int64 `type:"long"`
}

// String returns the string representation
func (s Lifecycle) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Lifecycle) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeleteAfterDays != nil {
		v := *s.DeleteAfterDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteAfterDays", protocol.Int64Value(v), metadata)
	}
	if s.MoveToColdStorageAfterDays != nil {
		v := *s.MoveToColdStorageAfterDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MoveToColdStorageAfterDays", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A structure that contains information about a backed-up resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ProtectedResource
type ProtectedResource struct {
	_ struct{} `type:"structure"`

	// The date and time a resource was last backed up, in Unix format and Coordinated
	// Universal Time (UTC). The value of LastBackupTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	LastBackupTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	ResourceArn *string `type:"string"`

	// The type of AWS resource; for example, an Amazon Elastic Block Store (Amazon
	// EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s ProtectedResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProtectedResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.LastBackupTime != nil {
		v := *s.LastBackupTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastBackupTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.ResourceArn != nil {
		v := *s.ResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceType != nil {
		v := *s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains detailed information about the recovery points stored in a backup
// vault.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/RecoveryPointByBackupVault
type RecoveryPointByBackupVault struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64 `type:"long"`

	// An ARN that uniquely identifies a backup vault; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// A CalculatedLifecycle object containing DeleteAt and MoveToColdStorageAt
	// timestamps.
	CalculatedLifecycle *CalculatedLifecycle `type:"structure"`

	// The date and time a job to restore a recovery point is completed, in Unix
	// format and Coordinated Universal Time (UTC). The value of CompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Contains identifying information about the creation of a recovery point,
	// including the BackupPlanArn, BackupPlanId, BackupPlanVersion, and BackupRuleId
	// of the backup plan that is used to create it.
	CreatedBy *RecoveryPointCreator `type:"structure"`

	// The date and time a recovery point is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The server-side encryption key that is used to protect your backups; for
	// example, arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string `type:"string"`

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// A Boolean value that is returned as TRUE if the specified recovery point
	// is encrypted, or FALSE if the recovery point is not encrypted.
	IsEncrypted *bool `type:"boolean"`

	// The date and time a recovery point was last restored, in Unix format and
	// Coordinated Universal Time (UTC). The value of LastRestoreTime is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	LastRestoreTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. AWS Backup transitions and expires backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “expire after days” setting must be
	// 90 days greater than the “transition to cold after days” setting. The
	// “transition to cold after days” setting cannot be changed after a backup
	// has been transitioned to cold.
	Lifecycle *Lifecycle `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// An ARN that uniquely identifies a resource. The format of the ARN depends
	// on the resource type.
	ResourceArn *string `type:"string"`

	// The type of AWS resource saved as a recovery point; for example, an Amazon
	// Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database
	// Service (Amazon RDS) database.
	ResourceType *string `type:"string"`

	// A status code specifying the state of the recovery point.
	Status RecoveryPointStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s RecoveryPointByBackupVault) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RecoveryPointByBackupVault) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupSizeInBytes != nil {
		v := *s.BackupSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupSizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.BackupVaultArn != nil {
		v := *s.BackupVaultArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupVaultName != nil {
		v := *s.BackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CalculatedLifecycle != nil {
		v := s.CalculatedLifecycle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CalculatedLifecycle", v, metadata)
	}
	if s.CompletionDate != nil {
		v := *s.CompletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CreatedBy != nil {
		v := s.CreatedBy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CreatedBy", v, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.EncryptionKeyArn != nil {
		v := *s.EncryptionKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncryptionKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IamRoleArn != nil {
		v := *s.IamRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsEncrypted != nil {
		v := *s.IsEncrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsEncrypted", protocol.BoolValue(v), metadata)
	}
	if s.LastRestoreTime != nil {
		v := *s.LastRestoreTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastRestoreTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Lifecycle != nil {
		v := s.Lifecycle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Lifecycle", v, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceArn != nil {
		v := *s.ResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceType != nil {
		v := *s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains detailed information about a saved recovery point.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/RecoveryPointByResource
type RecoveryPointByResource struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, of a backup.
	BackupSizeBytes *int64 `type:"long"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// The date and time a recovery point is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The server-side encryption key that is used to protect your backups; for
	// example, arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// A status code specifying the state of the recovery point.
	Status RecoveryPointStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s RecoveryPointByResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RecoveryPointByResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupSizeBytes != nil {
		v := *s.BackupSizeBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupSizeBytes", protocol.Int64Value(v), metadata)
	}
	if s.BackupVaultName != nil {
		v := *s.BackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.EncryptionKeyArn != nil {
		v := *s.EncryptionKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncryptionKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains information about the backup plan and rule that AWS Backup used
// to initiate the recovery point backup.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/RecoveryPointCreator
type RecoveryPointCreator struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example, arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50.
	BackupPlanArn *string `type:"string"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings
	// that are at most 1,024 bytes long. They cannot be edited.
	BackupPlanVersion *string `type:"string"`

	// Uniquely identifies a rule used to schedule the backup of a selection of
	// resources.
	BackupRuleId *string `type:"string"`
}

// String returns the string representation
func (s RecoveryPointCreator) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RecoveryPointCreator) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupPlanArn != nil {
		v := *s.BackupPlanArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupPlanId != nil {
		v := *s.BackupPlanId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupPlanVersion != nil {
		v := *s.BackupPlanVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupRuleId != nil {
		v := *s.BackupRuleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupRuleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains metadata about a restore job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/RestoreJobsListMember
type RestoreJobsListMember struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, of the restored resource.
	BackupSizeInBytes *int64 `type:"long"`

	// The date and time a job to restore a recovery point is completed, in Unix
	// format and Coordinated Universal Time (UTC). The value of CompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	CreatedResourceArn *string `type:"string"`

	// The date and time a restore job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The amount of time in minutes that a job restoring a recovery point is expected
	// to take.
	ExpectedCompletionTimeMinutes *int64 `type:"long"`

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// Contains an estimated percentage complete of a job at the time the job status
	// was queried.
	PercentDone *string `type:"string"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// Uniquely identifies the job that restores a recovery point.
	RestoreJobId *string `type:"string"`

	// A status code specifying the state of the job initiated by AWS Backup to
	// restore a recovery point.
	Status RestoreJobStatus `type:"string" enum:"true"`

	// A detailed message explaining the status of the job to restore a recovery
	// point.
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s RestoreJobsListMember) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreJobsListMember) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupSizeInBytes != nil {
		v := *s.BackupSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupSizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.CompletionDate != nil {
		v := *s.CompletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.CreatedResourceArn != nil {
		v := *s.CreatedResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedResourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.ExpectedCompletionTimeMinutes != nil {
		v := *s.ExpectedCompletionTimeMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpectedCompletionTimeMinutes", protocol.Int64Value(v), metadata)
	}
	if s.IamRoleArn != nil {
		v := *s.IamRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PercentDone != nil {
		v := *s.PercentDone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PercentDone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestoreJobId != nil {
		v := *s.RestoreJobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RestoreJobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusMessage != nil {
		v := *s.StatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
