// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package autoscalingplansiface provides an interface to enable mocking the AWS Auto Scaling Plans service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package autoscalingplansiface

import (
	"github.com/aws/aws-sdk-go-v2/service/autoscalingplans"
)

// ClientAPI provides an interface to enable mocking the
// autoscalingplans.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Auto Scaling Plans.
//    func myFunc(svc autoscalingplansiface.ClientAPI) bool {
//        // Make svc.CreateScalingPlan request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := autoscalingplans.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        autoscalingplansiface.ClientPI
//    }
//    func (m *mockClientClient) CreateScalingPlan(input *autoscalingplans.CreateScalingPlanInput) (*autoscalingplans.CreateScalingPlanOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateScalingPlanRequest(*autoscalingplans.CreateScalingPlanInput) autoscalingplans.CreateScalingPlanRequest

	DeleteScalingPlanRequest(*autoscalingplans.DeleteScalingPlanInput) autoscalingplans.DeleteScalingPlanRequest

	DescribeScalingPlanResourcesRequest(*autoscalingplans.DescribeScalingPlanResourcesInput) autoscalingplans.DescribeScalingPlanResourcesRequest

	DescribeScalingPlansRequest(*autoscalingplans.DescribeScalingPlansInput) autoscalingplans.DescribeScalingPlansRequest

	GetScalingPlanResourceForecastDataRequest(*autoscalingplans.GetScalingPlanResourceForecastDataInput) autoscalingplans.GetScalingPlanResourceForecastDataRequest

	UpdateScalingPlanRequest(*autoscalingplans.UpdateScalingPlanInput) autoscalingplans.UpdateScalingPlanRequest
}

var _ ClientAPI = (*autoscalingplans.Client)(nil)
