// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicyType
type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The name or Amazon Resource Name (ARN) of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicyOutput
type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest returns a request value for making API operation for
// Auto Scaling.
//
// Deletes the specified scaling policy.
//
// Deleting a policy deletes the underlying alarm action, but does not delete
// the alarm, even if it no longer has an associated action.
//
//    // Example sending a request using DeletePolicyRequest.
//    req := client.DeletePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicy
func (c *Client) DeletePolicyRequest(input *DeletePolicyInput) DeletePolicyRequest {
	op := &aws.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	req := c.newRequest(op, input, &DeletePolicyOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeletePolicyRequest{Request: req, Input: input, Copy: c.DeletePolicyRequest}
}

// DeletePolicyRequest is the request type for the
// DeletePolicy API operation.
type DeletePolicyRequest struct {
	*aws.Request
	Input *DeletePolicyInput
	Copy  func(*DeletePolicyInput) DeletePolicyRequest
}

// Send marshals and sends the DeletePolicy API request.
func (r DeletePolicyRequest) Send(ctx context.Context) (*DeletePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePolicyResponse{
		DeletePolicyOutput: r.Request.Data.(*DeletePolicyOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePolicyResponse is the response type for the
// DeletePolicy API operation.
type DeletePolicyResponse struct {
	*DeletePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePolicy request.
func (r *DeletePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
