// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroupType
type CreateAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group. This name must be unique within the scope
	// of your AWS account.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group. This parameter is optional
	// if you specify one or more subnets for VPCZoneIdentifier.
	//
	// Conditional: If your account supports EC2-Classic and VPC, this parameter
	// is required to launch instances into EC2-Classic.
	AvailabilityZones []string `min:"1" type:"list"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start. The default value is 300.
	//
	// For more information, see Scaling Cooldowns (https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DefaultCooldown *int64 `type:"integer"`

	// The number of EC2 instances that should be running in the group. This number
	// must be greater than or equal to the minimum size of the group and less than
	// or equal to the maximum size of the group. If you do not specify a desired
	// capacity, the default is the minimum size of the group.
	DesiredCapacity *int64 `type:"integer"`

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// checking the health status of an EC2 instance that has come into service.
	// During this time, any health check failures for the instance are ignored.
	// The default value is 0.
	//
	// For more information, see Health Checks for Auto Scaling Instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// Conditional: This parameter is required if you are adding an ELB health check.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	// The default value is EC2. If you configure an Auto Scaling group to use ELB
	// health checks, it considers the instance unhealthy if it fails either the
	// EC2 status checks or the load balancer health checks.
	//
	// For more information, see Health Checks for Auto Scaling Instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	HealthCheckType *string `min:"1" type:"string"`

	// The ID of the instance used to create a launch configuration for the group.
	// This parameter, a launch configuration, a launch template, or a mixed instances
	// policy must be specified.
	//
	// When you specify an ID of an instance, Amazon EC2 Auto Scaling creates a
	// new launch configuration and associates it with the group. This launch configuration
	// derives its attributes from the specified instance, except for the block
	// device mapping.
	//
	// For more information, see Create an Auto Scaling Group Using an EC2 Instance
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	InstanceId *string `min:"1" type:"string"`

	// The name of the launch configuration. This parameter, a launch template,
	// a mixed instances policy, or an EC2 instance must be specified.
	//
	// For more information, see Creating an Auto Scaling Group Using a Launch Configuration
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg.html) in
	// the Amazon EC2 Auto Scaling User Guide.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template to use to launch instances. This parameter, a launch
	// configuration, a mixed instances policy, or an EC2 instance must be specified.
	//
	// For more information, see Creating an Auto Scaling Group Using a Launch Template
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-launch-template.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// One or more lifecycle hooks.
	LifecycleHookSpecificationList []LifecycleHookSpecification `type:"list"`

	// One or more Classic Load Balancers. To specify an Application Load Balancer
	// or a Network Load Balancer, use TargetGroupARNs instead.
	//
	// For more information, see Using a Load Balancer With an Auto Scaling Group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	LoadBalancerNames []string `type:"list"`

	// The maximum size of the group.
	//
	// MaxSize is a required field
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	//
	// MinSize is a required field
	MinSize *int64 `type:"integer" required:"true"`

	// The mixed instances policy to use to launch instances. This parameter, a
	// launch template, a launch configuration, or an EC2 instance must be specified.
	//
	// For more information, see Auto Scaling Groups with Multiple Instance Types
	// and Purchase Options (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	MixedInstancesPolicy *MixedInstancesPolicy `type:"structure"`

	// Indicates whether newly launched instances are protected from termination
	// by Amazon EC2 Auto Scaling when scaling in.
	//
	// For more information about preventing instances from terminating on scale
	// in, see Instance Protection (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection)
	// in the Amazon EC2 Auto Scaling User Guide.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of the placement group into which to launch your instances, if any.
	// A placement group is a logical grouping of instances within a single Availability
	// Zone. You cannot specify multiple Availability Zones and a placement group.
	// For more information, see Placement Groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	PlacementGroup *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling
	// group uses to call other AWS services on your behalf. By default, Amazon
	// EC2 Auto Scaling uses a service-linked role named AWSServiceRoleForAutoScaling,
	// which it creates if it does not exist. For more information, see Service-Linked
	// Roles (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	ServiceLinkedRoleARN *string `min:"1" type:"string"`

	// One or more tags.
	//
	// For more information, see Tagging Auto Scaling Groups and Instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	Tags []Tag `type:"list"`

	// The Amazon Resource Names (ARN) of the target groups.
	TargetGroupARNs []string `type:"list"`

	// One or more termination policies used to select the instance to terminate.
	// These policies are executed in the order that they are listed.
	//
	// For more information, see Controlling Which Instances Auto Scaling Terminates
	// During Scale In (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	TerminationPolicies []string `type:"list"`

	// A comma-separated list of subnet IDs for your virtual private cloud (VPC).
	//
	// If you specify VPCZoneIdentifier with AvailabilityZones, the subnets that
	// you specify for this parameter must reside in those Availability Zones.
	//
	// Conditional: If your account supports EC2-Classic and VPC, this parameter
	// is required to launch instances into a VPC.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAutoScalingGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAutoScalingGroupInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.AvailabilityZones != nil && len(s.AvailabilityZones) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AvailabilityZones", 1))
	}
	if s.HealthCheckType != nil && len(*s.HealthCheckType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HealthCheckType", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LaunchConfigurationName != nil && len(*s.LaunchConfigurationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchConfigurationName", 1))
	}

	if s.MaxSize == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxSize"))
	}

	if s.MinSize == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinSize"))
	}
	if s.PlacementGroup != nil && len(*s.PlacementGroup) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PlacementGroup", 1))
	}
	if s.ServiceLinkedRoleARN != nil && len(*s.ServiceLinkedRoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceLinkedRoleARN", 1))
	}
	if s.VPCZoneIdentifier != nil && len(*s.VPCZoneIdentifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VPCZoneIdentifier", 1))
	}
	if s.LaunchTemplate != nil {
		if err := s.LaunchTemplate.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplate", err.(aws.ErrInvalidParams))
		}
	}
	if s.LifecycleHookSpecificationList != nil {
		for i, v := range s.LifecycleHookSpecificationList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LifecycleHookSpecificationList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.MixedInstancesPolicy != nil {
		if err := s.MixedInstancesPolicy.Validate(); err != nil {
			invalidParams.AddNested("MixedInstancesPolicy", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroupOutput
type CreateAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateAutoScalingGroup = "CreateAutoScalingGroup"

// CreateAutoScalingGroupRequest returns a request value for making API operation for
// Auto Scaling.
//
// Creates an Auto Scaling group with the specified name and attributes.
//
// If you exceed your maximum limit of Auto Scaling groups, the call fails.
// For information about viewing this limit, see DescribeAccountLimits. For
// information about updating this limit, see Amazon EC2 Auto Scaling Limits
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using CreateAutoScalingGroupRequest.
//    req := client.CreateAutoScalingGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroup
func (c *Client) CreateAutoScalingGroupRequest(input *CreateAutoScalingGroupInput) CreateAutoScalingGroupRequest {
	op := &aws.Operation{
		Name:       opCreateAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAutoScalingGroupInput{}
	}

	req := c.newRequest(op, input, &CreateAutoScalingGroupOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return CreateAutoScalingGroupRequest{Request: req, Input: input, Copy: c.CreateAutoScalingGroupRequest}
}

// CreateAutoScalingGroupRequest is the request type for the
// CreateAutoScalingGroup API operation.
type CreateAutoScalingGroupRequest struct {
	*aws.Request
	Input *CreateAutoScalingGroupInput
	Copy  func(*CreateAutoScalingGroupInput) CreateAutoScalingGroupRequest
}

// Send marshals and sends the CreateAutoScalingGroup API request.
func (r CreateAutoScalingGroupRequest) Send(ctx context.Context) (*CreateAutoScalingGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAutoScalingGroupResponse{
		CreateAutoScalingGroupOutput: r.Request.Data.(*CreateAutoScalingGroupOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAutoScalingGroupResponse is the response type for the
// CreateAutoScalingGroup API operation.
type CreateAutoScalingGroupResponse struct {
	*CreateAutoScalingGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAutoScalingGroup request.
func (r *CreateAutoScalingGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
