// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecutionInput
type BatchGetQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// An array of query execution IDs.
	//
	// QueryExecutionIds is a required field
	QueryExecutionIds []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetQueryExecutionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetQueryExecutionInput"}

	if s.QueryExecutionIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueryExecutionIds"))
	}
	if s.QueryExecutionIds != nil && len(s.QueryExecutionIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QueryExecutionIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecutionOutput
type BatchGetQueryExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Information about a query execution.
	QueryExecutions []QueryExecution `type:"list"`

	// Information about the query executions that failed to run.
	UnprocessedQueryExecutionIds []UnprocessedQueryExecutionId `type:"list"`
}

// String returns the string representation
func (s BatchGetQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGetQueryExecution = "BatchGetQueryExecution"

// BatchGetQueryExecutionRequest returns a request value for making API operation for
// Amazon Athena.
//
// Returns the details of a single query execution or a list of up to 50 query
// executions, which you provide as an array of query execution ID strings.
// Requires you to have access to the workgroup in which the queries ran. To
// get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup.
// Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput
// to get details about named queries.
//
//    // Example sending a request using BatchGetQueryExecutionRequest.
//    req := client.BatchGetQueryExecutionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution
func (c *Client) BatchGetQueryExecutionRequest(input *BatchGetQueryExecutionInput) BatchGetQueryExecutionRequest {
	op := &aws.Operation{
		Name:       opBatchGetQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetQueryExecutionInput{}
	}

	req := c.newRequest(op, input, &BatchGetQueryExecutionOutput{})
	return BatchGetQueryExecutionRequest{Request: req, Input: input, Copy: c.BatchGetQueryExecutionRequest}
}

// BatchGetQueryExecutionRequest is the request type for the
// BatchGetQueryExecution API operation.
type BatchGetQueryExecutionRequest struct {
	*aws.Request
	Input *BatchGetQueryExecutionInput
	Copy  func(*BatchGetQueryExecutionInput) BatchGetQueryExecutionRequest
}

// Send marshals and sends the BatchGetQueryExecution API request.
func (r BatchGetQueryExecutionRequest) Send(ctx context.Context) (*BatchGetQueryExecutionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetQueryExecutionResponse{
		BatchGetQueryExecutionOutput: r.Request.Data.(*BatchGetQueryExecutionOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetQueryExecutionResponse is the response type for the
// BatchGetQueryExecution API operation.
type BatchGetQueryExecutionResponse struct {
	*BatchGetQueryExecutionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetQueryExecution request.
func (r *BatchGetQueryExecutionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
