// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunctionRequest
type ListResolversByFunctionInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The Function ID.
	//
	// FunctionId is a required field
	FunctionId *string `location:"uri" locationName:"functionId" type:"string" required:"true"`

	// The maximum number of results you want the request to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which you can use to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListResolversByFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolversByFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListResolversByFunctionInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.FunctionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListResolversByFunctionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionId != nil {
		v := *s.FunctionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "functionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunctionResponse
type ListResolversByFunctionOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of resolvers.
	Resolvers []Resolver `locationName:"resolvers" type:"list"`
}

// String returns the string representation
func (s ListResolversByFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListResolversByFunctionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Resolvers) > 0 {
		v := s.Resolvers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resolvers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListResolversByFunction = "ListResolversByFunction"

// ListResolversByFunctionRequest returns a request value for making API operation for
// AWS AppSync.
//
// List the resolvers that are associated with a specific function.
//
//    // Example sending a request using ListResolversByFunctionRequest.
//    req := client.ListResolversByFunctionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction
func (c *Client) ListResolversByFunctionRequest(input *ListResolversByFunctionInput) ListResolversByFunctionRequest {
	op := &aws.Operation{
		Name:       opListResolversByFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/functions/{functionId}/resolvers",
	}

	if input == nil {
		input = &ListResolversByFunctionInput{}
	}

	req := c.newRequest(op, input, &ListResolversByFunctionOutput{})
	return ListResolversByFunctionRequest{Request: req, Input: input, Copy: c.ListResolversByFunctionRequest}
}

// ListResolversByFunctionRequest is the request type for the
// ListResolversByFunction API operation.
type ListResolversByFunctionRequest struct {
	*aws.Request
	Input *ListResolversByFunctionInput
	Copy  func(*ListResolversByFunctionInput) ListResolversByFunctionRequest
}

// Send marshals and sends the ListResolversByFunction API request.
func (r ListResolversByFunctionRequest) Send(ctx context.Context) (*ListResolversByFunctionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResolversByFunctionResponse{
		ListResolversByFunctionOutput: r.Request.Data.(*ListResolversByFunctionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListResolversByFunctionResponse is the response type for the
// ListResolversByFunction API operation.
type ListResolversByFunctionResponse struct {
	*ListResolversByFunctionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResolversByFunction request.
func (r *ListResolversByFunctionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
